/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mq.components.ConfigurationChangeBindHelper;
import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.zclient.ProgressPasswordUser;

public class UserConfigChangeHelper {
    public static void handleConfigurationChange(IComponentContext context, IElementChange elementChange, String configID, Broker broker, ConfigurationChangeBindHelper bindHelper) {
        if (broker.getState() != 3) {
            return;
        }
        if (elementChange.getChangeType() == 0) {
            UserConfigChangeHelper.handleNewUser(context, elementChange, bindHelper);
        } else if (elementChange.getChangeType() == 1) {
            UserConfigChangeHelper.handleUserUpdate(context, elementChange, configID);
        } else if (elementChange.getChangeType() == 2) {
            UserConfigChangeHelper.handleUserRemoval(context, elementChange, configID);
        }
    }

    public static void handleNewUser(IComponentContext context, IElementChange elementChange, ConfigurationChangeBindHelper bindHelper) {
        IElement newElement = (IElement)elementChange.getElement();
        IAttributeSet das = newElement.getAttributes();
        String userName = (String)das.getAttribute("USER_NAME");
        byte[] passwordHash = (byte[])das.getAttribute("PASSWORD");
        if (userName != null && passwordHash != null) {
            userName = userName.replace('.', '$');
            ProgressPasswordUser user = new ProgressPasswordUser(userName, passwordHash);
            try {
                AgentRegistrar.getAgentRegistrar().getSecurityBean().setUser(user);
                bindHelper.bindUserPasswordChangeHandler(user, das);
                bindHelper.bindRemoveUserChangeHandler(userName, das);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void handleUserUpdate(IComponentContext context, IElementChange elementChange, String configID) {
    }

    public static void handleUserRemoval(IComponentContext context, IElementChange elementChange, String configID) {
        IElement removedElement = (IElement)elementChange.getElement();
        IAttributeSet das = removedElement.getAttributes();
        String userName = (String)das.getAttribute("USER_NAME");
        IElement userElement = context.getConfiguration(configID, false);
        if (userElement != null && (das = userElement.getAttributes()) != null && (userName = (String)das.getAttribute("USER_NAME")) != null) {
            userName = userName.replace('.', '$');
            try {
                AgentRegistrar.getAgentRegistrar().getSecurityBean().delUser(userName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

