/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.AccessController;
import com.sonicsw.net.http.ConfigurationException;
import com.sonicsw.net.http.HttpBaseHandler;
import com.sonicsw.net.http.HttpClientContext;
import com.sonicsw.net.http.HttpClientContextManager;
import com.sonicsw.net.http.HttpConfigInfo;
import com.sonicsw.net.http.HttpConstants;
import com.sonicsw.net.http.HttpDirectDispatchThreadPool;
import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpOutRequest;
import com.sonicsw.net.http.HttpOutResponse;
import com.sonicsw.net.http.HttpRequestContext;
import com.sonicsw.net.http.HttpResponseInfo;
import com.sonicsw.net.http.HttpRoutingInfo;
import com.sonicsw.net.http.HttpServiceException;
import com.sonicsw.net.http.TimedUrlConnection;
import com.sonicsw.net.http.prAccessor;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.broker.AMPScratchPad;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.MgramURLHelper;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.jimpl.Message;
import progress.message.msg.IMgram;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.net.https.Handler;
import progress.message.net.https.client.HTTPSURLConnection;
import progress.message.resources.prMessageFormat;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.Envelope;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.SessionConfig;
import sun.misc.BASE64Encoder;

public abstract class HttpOutboundHandler
extends HttpBaseHandler {
    private static final boolean DEBUG = false;
    private static long s_uniqueID = 1L;
    protected static URLStreamHandler s_httpsHandler = new Handler();
    protected int m_retryInterval = 3000;
    protected int m_onewayTimeout = 30000;
    protected int m_onewayRetries = 0;
    protected int m_contentReplyTimeout = 60000;
    protected int m_contentReplyRetries = 0;
    protected boolean m_oneway = true;
    protected HttpRoutingInfo m_httpRoutingInfo = null;
    protected Object m_configLock = new Object();
    protected String m_protocolPrefix = null;
    protected String m_nodeName = null;
    private String m_contentReplyUsername = null;
    protected HttpClientContext m_httpCC = null;
    protected Hashtable m_contentMaps = null;
    private IHttpProxyConfig m_httpProxyConfig;
    private RoutingConnectionInfo m_routingConnectionInfo;

    public HttpOutboundHandler(RoutingConnectionInfo connectInfo, HttpConfigInfo config) throws ConfigurationException, HttpServiceException {
        super(config);
        this.m_routingConnectionInfo = connectInfo;
        this.m_nodeName = connectInfo.getRoutingNodeName();
        this.m_httpProxyConfig = connectInfo.getProxyConfig();
        try {
            this.setHttpRoutingInfo(connectInfo);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException(e.getMessage());
        }
        HttpRoutingInfo routingInfo = this.getHttpRoutingInfo();
        if (routingInfo.getURL() == null) {
            Object[] obj = new Object[]{this.m_nodeName, routingInfo.getUrlString(), HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
            String msg = prAccessor.getString("HTTP_ROUTING_CONFIG_INVALID_URL");
            throw new ConfigurationException(prMessageFormat.format(msg, obj));
        }
        if (config != null) {
            this.m_retryInterval = config.getIntElement("RetryInterval", 3);
            String requestMode = config.getStringElement("RequestMode", "Oneway");
            this.m_onewayTimeout = config.getIntElement("OnewayTimeout", 30);
            this.m_onewayRetries = config.getIntElement("OnewayRetries", 0);
            this.m_contentReplyUsername = config.getStringElement("ContentReplyUser", null);
            this.m_contentReplyTimeout = config.getIntElement("ContentReplyTimeout", 60);
            this.m_contentReplyRetries = config.getIntElement("ContentReplyRetries", 0);
            this.m_oneway = true;
            if (requestMode != null && requestMode.equalsIgnoreCase("ContentReply")) {
                this.m_oneway = false;
            }
            this.m_retryInterval = Math.max(this.m_retryInterval, 1);
            if (this.m_retryInterval <= 2147483) {
                this.m_retryInterval *= 1000;
            }
            this.m_onewayTimeout = Math.max(this.m_onewayTimeout, 10);
            if (this.m_onewayTimeout <= 2147483) {
                this.m_onewayTimeout *= 1000;
            }
            this.m_contentReplyTimeout = Math.max(this.m_contentReplyTimeout, 10);
            if (this.m_contentReplyTimeout <= 2147483) {
                this.m_contentReplyTimeout *= 1000;
            }
            this.m_contentMaps = config.getContentMappings();
        }
        if (!this.m_oneway) {
            try {
                this.createClientContext();
            }
            catch (HttpServiceException e) {
                this.m_httpCC = null;
                HttpConstants.DEBUG("Warning: unknown content reply user for node " + this.m_nodeName, 0);
            }
        }
    }

    private void printContentProperties() {
        System.out.println("\t onewayTimeout - " + this.m_onewayTimeout);
        System.out.println("\t retryInterval - " + this.m_retryInterval);
        System.out.println("\t contentreplyUserName - " + this.m_contentReplyUsername);
        System.out.println("\t contentreplyTimeout - " + this.m_contentReplyTimeout);
        System.out.println("\t contentreplyRetryCount - " + this.m_contentReplyRetries);
    }

    public Hashtable getContentMappings() {
        return this.m_contentMaps;
    }

    protected abstract HttpOutRequest getHttpOutRequest(IMgram var1);

    protected abstract HttpOutResponse getHttpOutResponse(IMgram var1);

    public URLConnection openConnection(String url) throws ConfigurationException, IOException {
        HttpRoutingInfo routingInfo = this.getHttpRoutingInfo();
        URLWrapper w = new URLWrapper(url, routingInfo);
        return this.openConnection(w, routingInfo);
    }

    public URLConnection openConnection(IMgram mgram) throws ConfigurationException, IOException {
        HttpRoutingInfo routingInfo = this.getHttpRoutingInfo();
        URLWrapper w = new URLWrapper(mgram, routingInfo);
        return this.openConnection(w, routingInfo);
    }

    private URLConnection openConnection(URLWrapper urlWrapper, HttpRoutingInfo routingInfo) throws ConfigurationException, IOException {
        IHttpProxyConfig pConfig = this.retrievePConfig(routingInfo);
        URL sendURL = this.prossesForProxy(urlWrapper, pConfig);
        return this.openConnection(sendURL, pConfig);
    }

    private URLConnection openConnection(URL sendURL, IHttpProxyConfig pConfigParam) throws ConfigurationException, IOException {
        URLConnection connection;
        IHttpProxyConfig pConfig = pConfigParam;
        if (pConfig == null) {
            pConfig = this.m_httpProxyConfig;
        }
        if (HttpHelper.isHttps(sendURL)) {
            connection = new HTTPSURLConnection(sendURL);
            if (pConfig != null && pConfig.getHost() != null && pConfig.getHost().trim().length() > 0) {
                ((HTTPSURLConnection)connection).setProxyConfig(pConfig);
            }
            ((HTTPSURLConnection)connection).markSSLSocketAvailable();
        } else {
            connection = sendURL.openConnection();
        }
        if (pConfig != null && pConfig.getHost() != null && pConfig.getHost().trim().length() > 0) {
            String uid = pConfig.getUserName();
            String psw = pConfig.getUserPassword();
            if (uid != null && uid.trim().length() > 0) {
                String password = uid + ":" + psw;
                BASE64Encoder base64Encoder = new BASE64Encoder();
                String encodedPassword = base64Encoder.encode(password.getBytes());
                connection.setRequestProperty("Proxy-Authorization", "Basic " + encodedPassword);
            }
        }
        return connection;
    }

    protected void disconnect(URLConnection conn) {
        if (conn != null) {
            if (conn instanceof HTTPSURLConnection) {
                ((HTTPSURLConnection)conn).disconnect();
            } else {
                ((HttpURLConnection)conn).disconnect();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void sendMgram(IMgram mgram, Thread dispatchThread) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void populateMessagePrintStackTrace(HttpLock lock, Exception e) {
        lock.setMessage(e.getMessage());
        HttpOutboundHandler.logError(e);
    }

    private static void logError(Throwable t) {
    }

    protected boolean isSyncRequest(IMgram mgram) {
        String replyTo = mgram.getSidebandData().getReplyTo();
        return !this.m_oneway && replyTo != null && !"".equals(replyTo);
    }

    protected HttpResponseInfo handleRequest(HttpOutRequest request, HttpRoutingInfo routingInfo, URL sendURL, int timeout, int retries, int retryInterval, HttpDirectDispatchThreadPool.HttpDispatchThread dispatchThread) throws ConfigurationException, IOException {
        int count = 0;
        HttpResponseInfo responseInfo = new HttpResponseInfo(610);
        IHttpProxyConfig pConfig = this.retrievePConfig(routingInfo);
        while (true) {
            String msgFmt;
            URLConnection connection;
            int responseCode;
            if (HttpOutboundHandler.isStandardResponseCode(responseCode = (responseInfo = this.singleSendRequest(connection = this.openConnection(sendURL, pConfig), request, routingInfo, timeout, dispatchThread)).getResponseCode()) && responseCode != 408 && responseCode != 503) {
                if (count > 0) {
                    msgFmt = prAccessor.getString("HTTP_DIRECT_OUTBOUND_RETRY_SUCCESS");
                    Object[] obj = new String[]{sendURL.toString(), Integer.toString(count + 1), Integer.toString(retries + 1)};
                    String msg = prMessageFormat.format(msgFmt, obj);
                    BrokerComponent.getComponentContext().logMessage(msg, 3);
                }
                responseInfo.setResponseReceived(true);
                break;
            }
            if (count >= retries) {
                msgFmt = prAccessor.getString("HTTP_DIRECT_OUTBOUND_RETRY_FAILURE");
                Object[] obj = new String[]{sendURL.toString()};
                String msg = prMessageFormat.format(msgFmt, obj);
                BrokerComponent.getComponentContext().logMessage(msg, 2);
                break;
            }
            BrokerComponent brokerComponent = BrokerComponent.getBrokerComponent();
            int traceMask = brokerComponent.getTraceMask();
            if ((traceMask & 0x20) > 0 || count == 0) {
                int secRetryInterval = retryInterval / 1000;
                String msgFmt2 = prAccessor.getString("HTTP_DIRECT_OUTBOUND_RETRY_ATTEMPT");
                Object[] obj = new String[]{sendURL.toString(), Integer.toString(count + 1), Integer.toString(retries + 1), Integer.toString(secRetryInterval)};
                String msg = prMessageFormat.format(msgFmt2, obj);
                BrokerComponent.getComponentContext().logMessage(msg, 3);
            }
            try {
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++count;
        }
        return responseInfo;
    }

    private IHttpProxyConfig retrievePConfig(HttpRoutingInfo routingInfo) {
        IHttpProxyConfig pConfig = routingInfo.getHttpProxyConfig();
        if (pConfig == null) {
            pConfig = this.m_httpProxyConfig;
        }
        return pConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponseInfo singleSendRequest(URLConnection connection, HttpOutRequest request, HttpRoutingInfo routingInfo, int timeout, HttpDirectDispatchThreadPool.HttpDispatchThread dispatchThread) {
        HttpResponseInfo responseInfo = new HttpResponseInfo(610);
        try {
            String value = null;
            String key = null;
            Hashtable properties = request.getProperties();
            Enumeration enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                value = (String)properties.get(key);
                connection.setRequestProperty(key, value);
            }
            try {
                if (request.m_method != null && "GET".equalsIgnoreCase(request.m_method)) {
                    connection.setDoOutput(false);
                    if (connection instanceof HttpURLConnection) {
                        ((HttpURLConnection)connection).setRequestMethod("GET");
                    } else if (connection instanceof HTTPSURLConnection) {
                        ((HTTPSURLConnection)connection).setRequestMethod("GET");
                    }
                } else {
                    connection.setDoOutput(true);
                    request.contentToStream(connection.getOutputStream());
                }
            }
            catch (IOException ioe) {
                HttpResponseInfo httpResponseInfo = new HttpResponseInfo(611);
                BrokerComponent brokerComponent = BrokerComponent.getBrokerComponent();
                int traceMask = brokerComponent.getTraceMask();
                if ((traceMask & 0x20) > 0) {
                    String msg = this.makeTraceMessage(request, connection, request.getAuthUser(), responseInfo.getResponseCode(), traceMask);
                    BrokerComponent.getComponentContext().logMessage(msg, 7);
                }
                return httpResponseInfo;
            }
            try {
                responseInfo = new TimedUrlConnection().getResponseInfo(connection, timeout, dispatchThread);
            }
            catch (Exception e) {
                HttpConstants.DEBUG(e, 0);
                HttpResponseInfo httpResponseInfo = responseInfo;
                BrokerComponent brokerComponent = BrokerComponent.getBrokerComponent();
                int traceMask = brokerComponent.getTraceMask();
                if ((traceMask & 0x20) > 0) {
                    String msg = this.makeTraceMessage(request, connection, request.getAuthUser(), responseInfo.getResponseCode(), traceMask);
                    BrokerComponent.getComponentContext().logMessage(msg, 7);
                }
                return httpResponseInfo;
            }
        }
        finally {
            BrokerComponent brokerComponent = BrokerComponent.getBrokerComponent();
            int traceMask = brokerComponent.getTraceMask();
            if ((traceMask & 0x20) > 0) {
                String msg = this.makeTraceMessage(request, connection, request.getAuthUser(), responseInfo.getResponseCode(), traceMask);
                BrokerComponent.getComponentContext().logMessage(msg, 7);
            }
        }
        return responseInfo;
    }

    private String makeTraceMessage(HttpOutRequest request, URLConnection connection, String httpAuthUser, int responseCode, int traceMask) {
        boolean traceVerbose = (traceMask & 1) > 0;
        StringBuffer trace = new StringBuffer("Delivered HTTP Direct outbound message, containing");
        if (traceVerbose) {
            trace.append(" details");
        }
        trace.append("...");
        trace.append("\n\t").append("Destination URL=").append(connection.getURL().toString());
        trace.append("\n\t").append("User=").append(httpAuthUser);
        trace.append("\n\t").append("Status Code=").append(responseCode);
        Hashtable properties = request.getProperties();
        String key = null;
        String value = null;
        Enumeration enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            value = (String)properties.get(key);
            if (!key.equalsIgnoreCase("Content-Length")) continue;
            trace.append("\n\t[req]").append(key).append("=").append(value);
        }
        if (traceVerbose) {
            enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                value = (String)properties.get(key);
                if (key.equalsIgnoreCase("Content-Length")) continue;
                trace.append("\n\t[req]").append(key).append("=").append(value);
            }
        }
        if (responseCode != 610 && responseCode != 408 && responseCode != 503) {
            int responseLength = connection.getContentLength();
            if (responseLength > 0) {
                trace.append("\n\t[resp]Content-Length=").append(responseLength);
            }
            if (traceVerbose) {
                int i = 1;
                while (true) {
                    key = connection.getHeaderFieldKey(i);
                    value = connection.getHeaderField(i);
                    if (key == null || value == null) break;
                    if (!key.equalsIgnoreCase("Content-Length") && !HttpHelper.isIgnoredHTTPResponseTraceProperty(key)) {
                        trace.append("\n\t[resp]").append(key).append("=").append(value);
                    }
                    ++i;
                }
            }
        }
        return trace.toString();
    }

    protected void processContentReply(IMgram mgram, HttpOutResponse response) throws ConfigurationException, HttpServiceException {
        this.checkHttp();
        byte prio = mgram.getPriority();
        long ttl = mgram.getTTE() - System.currentTimeMillis();
        long senderID = mgram.getBrokerHandle().getSenderID();
        String deliveryMode = null;
        deliveryMode = mgram.isJMSPersistent() ? (mgram.isNonPersistentReplicated() ? "NON_PERSISTENT_REPLICATED" : "PERSISTENT") : (mgram.isDiscardable() ? "DISCARDABLE" : "NON_PERSISTENT");
        String replyTo = mgram.getSidebandData().getReplyTo();
        String corrID = mgram.getSidebandData().getCorrelationID();
        boolean notifyUndeliv = this.getBooleanProperty(mgram, "JMS_SonicMQ_preserveUndelivered");
        boolean preserveUndeliv = this.getBooleanProperty(mgram, "JMS_SonicMQ_notifyUndelivered");
        String destinationUndeliv = this.getStringProperty(mgram, "JMS_SonicMQ_destinationUndelivered");
        String destinationUndelivType = null;
        String destinationUndelivName = null;
        if (destinationUndeliv != null) {
            if (destinationUndeliv.startsWith("$Q.")) {
                destinationUndelivType = "QUEUE";
                destinationUndelivName = destinationUndeliv.substring("$Q.".length());
            } else {
                destinationUndelivType = "TOPIC";
                destinationUndelivName = destinationUndeliv;
            }
        }
        response.setMessageProperties(replyTo, deliveryMode, prio, ttl, corrID, notifyUndeliv, preserveUndeliv, destinationUndelivType, destinationUndelivName);
        try {
            this.deliverResponseMgram(this.createMgramFromResponse(response));
        }
        catch (InterruptedException e) {
            throw new HttpServiceException(e.getMessage());
        }
    }

    public void processContentReply(HttpOutResponse response, String replyTo) throws ConfigurationException, HttpServiceException {
        this.checkHttp();
        String deliveryMode = "PERSISTENT";
        response.setMessageProperties(replyTo, deliveryMode, -1, -1L, null, false, false, null, null);
        try {
            this.deliverResponseMgram(this.createMgramFromResponse(response));
        }
        catch (InterruptedException e) {
            throw new HttpServiceException(e.getMessage());
        }
    }

    private void checkHttp() throws ConfigurationException {
        if (this.m_httpCC == null) {
            Object[] obj = new Object[]{this.m_nodeName, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
            String msg = prAccessor.getString("HTTP_DIRECT_INVALID_REPLYTO_USER");
            String errorText = prMessageFormat.format(msg, obj);
            throw new ConfigurationException(errorText, "ContentReplyUser", null);
        }
    }

    private IMgram createMgramFromResponse(HttpOutResponse response) {
        progress.message.jclient.Message msg = response.getMessage();
        ClientSecurityContext csc = this.m_httpCC.getCSC();
        Envelope envelope = ((Message)msg).getEnvelope();
        envelope.setTimestamp(System.currentTimeMillis());
        envelope.setMessageID(this.getBrokerID(), this.getNextMessageID(), "");
        this.sync(csc, envelope, s_mp);
        IMgram mgram = envelope.getMgram();
        byte mgramType = mgram.getType();
        long tracking = this.getNextTrackingId();
        mgram.setGuarenteed(tracking);
        mgram.getBrokerHandle().setSenderID(csc.getClientId());
        return mgram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverResponseMgram(IMgram m) throws InterruptedException {
        AMPScratchPad sp = new AMPScratchPad();
        sp.setClientContext(this.m_httpCC);
        long tracking = this.getNextTrackingId();
        m.setGuarenteed(tracking);
        HttpRequestContext reqContext = null;
        HttpLock lock = null;
        try {
            lock = this.m_httpCC.setAckLock(tracking);
            AgentRegistrar.getAgentRegistrar().getMsgProc().newMgram(m, sp);
            reqContext = this.m_httpCC.waitForAck(lock);
        }
        finally {
            if (lock != null) {
                this.m_httpCC.releaseAckLock(lock);
                int returnCode = lock.getErrorType();
                if (returnCode > 300) {
                    this.ackOrDmq(lock, m);
                }
            }
        }
    }

    private void createClientContext() throws ConfigurationException, HttpServiceException {
        AccessController ac = AccessController.getController();
        ProgressPasswordUser user = ac.authenticate(this.m_contentReplyUsername, null, false, null);
        if (user == null) {
            throw new HttpServiceException("Failed to authenticate reply-to user.");
        }
        this.m_httpCC = HttpClientContextManager.getInstance().connect(user);
        this.m_httpCC.setHTTPDirectOutbound();
    }

    private boolean getBooleanProperty(IMgram m, String p) {
        Hashtable props = m.getSidebandData().getProperties();
        if (props.containsKey(p)) {
            Object value = props.get(p);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
            return false;
        }
        return false;
    }

    private String getStringProperty(IMgram m, String p) {
        Hashtable props = m.getSidebandData().getProperties();
        if (props.containsKey(p)) {
            Object value = props.get(p);
            if (value instanceof String) {
                return (String)value;
            }
            return null;
        }
        return null;
    }

    public synchronized long getUniqueID() {
        return s_uniqueID++;
    }

    public void updateRoutingConfig(RoutingConnectionInfo newConfig, RoutingConnectionInfo oldConfig) {
        if (newConfig == null) {
            return;
        }
        try {
            this.setHttpRoutingInfo(newConfig);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpRoutingInfo getHttpRoutingInfo() {
        Object object = this.m_configLock;
        synchronized (object) {
            return this.m_httpRoutingInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHttpRoutingInfo(RoutingConnectionInfo routingInfo) throws ConfigurationException, MalformedURLException {
        Object object = this.m_configLock;
        synchronized (object) {
            String username = routingInfo.getUserName();
            String password = routingInfo.getPassword();
            String urlString = null;
            String[] urls = routingInfo.getArrayOfURLs();
            if (urls != null && urls[0] != null) {
                urlString = urls[0];
            }
            if (!HttpHelper.startsWithIgnoreCase(urlString, "https:") && !HttpHelper.startsWithIgnoreCase(urlString, "http:")) {
                Object[] obj = new Object[]{this.m_nodeName, urlString, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                String msg = prAccessor.getString("HTTP_ROUTING_CONFIG_INVALID_URL");
                BrokerComponent.getComponentContext().logMessage(prMessageFormat.format(msg, obj), 2);
                this.m_httpRoutingInfo = new HttpRoutingInfo(urlString, null, routingInfo.getRouteType(), username, password, routingInfo.getProxyConfig());
                throw new ConfigurationException(prMessageFormat.format(msg, obj));
            }
            try {
                URL url = null;
                url = HttpHelper.isHttps(urlString) ? new URL(null, urlString, s_httpsHandler) : new URL(urlString);
                this.m_httpRoutingInfo = new HttpRoutingInfo(urlString, url, routingInfo.getRouteType(), username, password, routingInfo.getProxyConfig());
            }
            catch (MalformedURLException e) {
                Object[] obj = new Object[]{this.m_nodeName, urlString, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                String msg = prAccessor.getString("HTTP_ROUTING_CONFIG_INVALID_URL");
                BrokerComponent.getComponentContext().logMessage(prMessageFormat.format(msg, obj), 2);
                this.m_httpRoutingInfo = new HttpRoutingInfo(urlString, null, routingInfo.getRouteType(), username, password, routingInfo.getProxyConfig());
                throw e;
            }
            this.m_routingConnectionInfo = routingInfo;
        }
    }

    public static boolean isStandardResponseCode(int code) {
        return code >= 100 && code < 600;
    }

    public static boolean isHttpErrorCode(int responseCode) {
        return responseCode >= 300;
    }

    public void ackOrDmq(HttpLock lock, IMgram mgram) {
        int httpCode = lock.getErrorType();
        if (this.shouldAckRequestMgram(mgram, lock, httpCode)) {
            this.ack(mgram);
        } else {
            int dmqReason = 0;
            String msg = lock.getMessage();
            switch (httpCode) {
                case 400: {
                    dmqReason = 12;
                    break;
                }
                case 401: {
                    dmqReason = 13;
                    break;
                }
                case 404: {
                    dmqReason = 14;
                    break;
                }
                case 505: {
                    dmqReason = 22;
                    break;
                }
                case 408: {
                    dmqReason = 11;
                    if (msg != null) break;
                    msg = prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_TIMEOUT");
                    break;
                }
                case 413: {
                    dmqReason = 15;
                    if (msg != null) break;
                    msg = prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_MESSAGE_TOO_LARGE");
                    break;
                }
                case 500: {
                    dmqReason = 16;
                    if (msg != null) break;
                    msg = prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_SERVICE_UNAVAILABLE");
                    break;
                }
                case 501: {
                    dmqReason = 17;
                    if (msg != null) break;
                    msg = prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_PROTOCOL_NOT_SUPPORTED");
                    break;
                }
                case 503: {
                    dmqReason = 11;
                    if (msg != null) break;
                    msg = prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_SERVICE_UNAVAILABLE");
                    break;
                }
                case 611: {
                    dmqReason = 11;
                    if (msg != null) break;
                    msg = prAccessor.getString("HTTP_DIRECT_UNDELIVERABLE_HOST_UNREACHABLE");
                    break;
                }
                case 612: {
                    dmqReason = 13;
                    Object[] obj = new Object[]{this.m_nodeName, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                    msg = prMessageFormat.format(prAccessor.getString("HTTP_DIRECT_INVALID_REPLYTO_USER"), obj);
                    BrokerComponent.getComponentContext().logMessage(msg, 2);
                    break;
                }
                case 613: {
                    dmqReason = 10;
                    Object[] obj = new Object[]{this.m_nodeName, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                    msg = prMessageFormat.format(prAccessor.getString("HTTP_ROUTING_UNSUPPORTED_JMS_MESSAGE_TYPE"), obj);
                    BrokerComponent.getComponentContext().logMessage(msg, 2);
                    break;
                }
                case 615: {
                    dmqReason = 21;
                    msg = lock.getMessage();
                    break;
                }
                case 616: {
                    dmqReason = 16;
                    break;
                }
                default: {
                    dmqReason = 10;
                    if (msg == null) break;
                    BrokerComponent.getComponentContext().logMessage(msg, 2);
                }
            }
            if (this.shouldReplySimpleMessage(lock, mgram)) {
                lock.setDmqReason(dmqReason);
                lock.setDmqMessage(msg);
            }
            try {
                this.dmq(mgram, dmqReason, msg);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    protected boolean shouldAckRequestMgram(IMgram mgram, HttpLock lock, int responseCode) {
        return responseCode < 300;
    }

    public boolean shouldReplyFault(HttpLock lock, IMgram m) {
        return false;
    }

    public boolean shouldReplySimpleMessage(HttpLock lock, IMgram m) {
        return false;
    }

    protected abstract void handleResponse(HttpLock var1, IMgram var2, URLConnection var3, HttpOutResponse var4);

    private URL prossesForProxy(URLWrapper urlWrapper, IHttpProxyConfig pConfig) throws MalformedURLException {
        URL originalUrl = urlWrapper.m_url;
        if (!SessionConfig.IN_BROKER) {
            return originalUrl;
        }
        if (pConfig == null) {
            return originalUrl;
        }
        if (HttpHelper.isHttps(originalUrl)) {
            return originalUrl;
        }
        if (pConfig.getHost() != null && pConfig.getHost().trim().length() > 0) {
            String proxyProtocol = pConfig.getProtocol();
            String proxyHost = pConfig.getHost();
            int proxyPort = pConfig.getPort();
            String urlProtocol = originalUrl.getProtocol();
            String urlFile = urlWrapper.m_urlFile;
            originalUrl = new URL(proxyProtocol, proxyHost, proxyPort, urlFile);
        }
        return originalUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutingConnectionInfo getRoutingConnectionInfo() {
        Object object = this.m_configLock;
        synchronized (object) {
            return this.m_routingConnectionInfo;
        }
    }

    public boolean isContentReply(IMgram m) {
        return this.isSyncRequest(m);
    }

    public int getHttpRequestTimeout(IMgram m) {
        if (m == null || !this.isContentReply(m)) {
            return this.m_onewayTimeout;
        }
        int timeout = this.m_contentReplyTimeout;
        try {
            Integer intValue = (Integer)m.getSidebandData().getProperty("X-HTTP-RequestTimeout");
            timeout = this.retrieveRetryInterval(intValue, timeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeout;
    }

    public int getHttpRequestRetry(IMgram m) {
        if (m == null || !this.isContentReply(m)) {
            return this.m_onewayRetries;
        }
        int retry = this.m_contentReplyRetries;
        try {
            Integer intValue = (Integer)m.getSidebandData().getProperty("X-HTTP-Retries");
            if (intValue != null && intValue >= 0) {
                retry = intValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retry;
    }

    public int getHttpRetryInterval(IMgram m) {
        int retryInterval = this.m_retryInterval;
        if (m == null) {
            return retryInterval;
        }
        try {
            Integer intValue = (Integer)m.getSidebandData().getProperty("X-HTTP-RetryInterval");
            retryInterval = this.retrieveRetryInterval(intValue, retryInterval);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retryInterval;
    }

    private int retrieveRetryInterval(Integer intValue, int retryIntervalParam) {
        int retryInterval = retryIntervalParam;
        if (intValue != null && intValue >= 0) {
            retryInterval = intValue * 1000;
        }
        return retryInterval;
    }

    protected static void logLargeMessageWarning(HttpOutResponse response, URLConnection connection) {
        String msg = "Rejected HTTP routing response exceeding " + SessionConfig.MAX_MSG_SIZE / 0x100000 + "Mb message size limit.";
        if (response != null) {
            int size = response.getContentLength();
            msg = msg + " Response size " + (size > 0 ? Integer.toString(size) + " bytes" : "unknown");
        }
        if (connection != null) {
            msg = msg + ", url " + connection.getURL();
        }
        BrokerComponent.getComponentContext().logMessage(msg, 2);
    }

    class URLWrapper {
        private URL m_url = null;
        private String m_urlFile = null;

        URLWrapper(IMgram mgram, HttpRoutingInfo routingInfo) throws ConfigurationException {
            String messageURL = MgramURLHelper.getEffectiveURLDestination(mgram);
            if (messageURL != null && !"".equals(messageURL)) {
                this.init(messageURL, routingInfo);
            } else {
                this.init(null, routingInfo);
            }
        }

        URLWrapper(String messageURL, HttpRoutingInfo routingInfo) throws ConfigurationException {
            this.init(messageURL, routingInfo);
        }

        final void init(String messageURL, HttpRoutingInfo routingInfo) throws ConfigurationException {
            if (messageURL != null && !"".equals(messageURL)) {
                try {
                    this.m_url = HttpHelper.isHttps(messageURL) ? new URL(null, messageURL, s_httpsHandler) : new URL(messageURL);
                    this.m_urlFile = messageURL;
                }
                catch (MalformedURLException e) {
                    Object[] obj = new Object[]{HttpOutboundHandler.this.m_nodeName, messageURL, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                    String msg = prAccessor.getString("HTTP_ROUTING_INVALID_DESTINATION_URL");
                    String errorText = prMessageFormat.format(msg, obj);
                    throw new ConfigurationException(errorText);
                }
            } else {
                this.m_url = routingInfo.getURL();
                this.m_urlFile = routingInfo.getUrlString();
                if (this.m_url == null) {
                    Object[] obj = new Object[]{HttpOutboundHandler.this.m_nodeName, routingInfo.getUrlString(), HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                    String msg = prAccessor.getString("HTTP_ROUTING_CONFIG_INVALID_URL");
                    String errorText = prMessageFormat.format(msg, obj);
                    throw new ConfigurationException(errorText);
                }
            }
        }
    }
}

