/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.soap;

import com.sonicsw.net.http.HttpConstants;
import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.HttpOutResponse;
import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.net.http.HttpServiceException;
import com.sonicsw.net.http.direct.DirectHttpOutResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;

public class SoapHttpOutResponse
extends DirectHttpOutResponse {
    private InputStream m_faultStream;

    @Override
    public void buildResponse(HttpOutResponse response, URLConnection connection, HttpOutboundHandler handler) throws HttpServiceException {
        InputStream is;
        int responseCode = response.getResponseCode();
        if (connection != null && !response.isInternal()) {
            String contentType;
            String key = null;
            String value = null;
            int i = 1;
            while (true) {
                key = connection.getHeaderFieldKey(i);
                value = connection.getHeaderField(i);
                if (key == null || value == null) break;
                if ("Content-Type".equalsIgnoreCase(key)) {
                    if (response.getContentType() == null) {
                        response.setProperty("Content-Type", value);
                    }
                } else if ("Content-Length".equalsIgnoreCase(key)) {
                    if (response.getContentLength() < 0) {
                        response.setProperty("Content-Length", value);
                    }
                } else {
                    response.setProperty(key, value);
                }
                ++i;
            }
            int len = response.getContentLength();
            if (len < 0) {
                len = connection.getContentLength();
                response.setProperty("Content-Length", Integer.toString(len));
            }
            if ((contentType = response.getContentType()) == null && (contentType = connection.getContentType()) != null) {
                response.setProperty("Content-Type", contentType);
            }
        }
        if (response.getContentType() == null) {
            response.setProperty("Content-Type", "text/xml");
        }
        response.createMessage(handler.getContentMappings());
        if (HttpOutboundHandler.isHttpErrorCode(responseCode) && response.isInternal()) {
            try {
                is = ((SoapHttpOutResponse)response).getInternalFaultStream();
                if (is != null && is.available() > 0) {
                    response.handleContent(is, -1);
                    HttpConstants.DEBUG("Outbound handler responding a local fault ", 1);
                    return;
                }
            }
            catch (Exception e) {
                throw new HttpServiceException(e);
            }
        }
        if (connection == null) {
            return;
        }
        try {
            is = null;
            if (HttpOutboundHandler.isHttpErrorCode(responseCode)) {
                InputStream inputStream = is = HttpHelper.isHttps(connection) ? connection.getInputStream() : ((HttpURLConnection)connection).getErrorStream();
                if (is != null) {
                    int fault_length = -1;
                    response.setProperty("Content-Length", Integer.toString(fault_length));
                    HttpConstants.DEBUG("Outbound handler responding an error stream of the connection", 1);
                } else {
                    is = ((SoapHttpOutResponse)response).getInternalFaultStream();
                    if (is != null) {
                        response.handleContent(is, -1);
                        return;
                    }
                }
            } else {
                is = connection.getInputStream();
                HttpConstants.DEBUG("Outbound handler build Response for OK, use connection InputStream", 1);
            }
            response.handleContent(is, response.getContentLength());
        }
        catch (Exception e) {
            throw new HttpServiceException(e);
        }
    }

    public InputStream getInternalFaultStream() {
        return this.m_faultStream;
    }

    private void setInternalFaultStream(InputStream is) {
        this.m_faultStream = is;
    }

    protected void assignInternalFault(String msg) {
        this.setInternalFaultStream(new ByteArrayInputStream(msg.getBytes()));
    }
}

