/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.common;

import com.sonicsw.ws.rm.common.ISequence;
import com.sonicsw.ws.rm.common.IState;
import com.sonicsw.ws.rm.common.RMEvent;
import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.ws.rm.common.RMSequence;
import com.sonicsw.ws.rm.protocol.Constants;
import org.apache.axis.AxisFault;
import org.apache.axis.soap.SOAPConstants;
import progress.message.util.PriorityQueue;

public abstract class RMSequenceSupport
implements ISequence {
    private static int MAX_WORKQ_SIZE = 75000;
    private PriorityQueue m_workQ = new PriorityQueue(13);
    private int m_workQSize = 0;
    private int m_workQCount = 0;
    private long m_lastActive = 0L;
    private volatile boolean m_isOkToSend = true;
    private Object m_notifyTarget = null;
    private Thread m_dispatchThread;
    private IState m_state;
    private RMSequence m_rmseq;
    private Constants m_constants;
    private String m_wsaNS;
    private SOAPConstants m_soapconstants;
    private boolean m_markedForTermination = false;
    private boolean m_isLocallyHomed = false;

    @Override
    public IState getState() {
        return this.m_state;
    }

    @Override
    public final void changeState(IState state) {
        this.m_state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDispatchThread(Thread dispatchThread) {
        PriorityQueue priorityQueue = this.m_workQ;
        synchronized (priorityQueue) {
            this.m_dispatchThread = dispatchThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDispatching() {
        PriorityQueue priorityQueue = this.m_workQ;
        synchronized (priorityQueue) {
            return this.m_dispatchThread != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQuiet() {
        PriorityQueue priorityQueue = this.m_workQ;
        synchronized (priorityQueue) {
            return this.m_workQ.isEmpty();
        }
    }

    public boolean isOkToSend(Object notifyTarget) {
        this.m_notifyTarget = notifyTarget;
        return this.m_isOkToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(RMEvent e, int pri) {
        boolean needDispatch = false;
        PriorityQueue priorityQueue = this.m_workQ;
        synchronized (priorityQueue) {
            if (this.m_workQ.isEmpty() && this.m_dispatchThread == null) {
                needDispatch = true;
            }
            this.m_workQ.enqueue(e, pri);
            this.m_workQSize = (int)((long)this.m_workQSize + e.memoryLength());
            ++this.m_workQCount;
            this.m_lastActive = System.currentTimeMillis();
            if (this.m_workQSize >= MAX_WORKQ_SIZE) {
                this.m_isOkToSend = false;
            }
        }
        if (needDispatch) {
            RMManager.getRMManager().requestDispatch();
        }
    }

    public abstract void faultSequence(AxisFault var1);

    public abstract boolean isOutbound();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMEvent dequeueAndNotify() throws InterruptedException {
        RMEvent evt = null;
        PriorityQueue priorityQueue = this.m_workQ;
        synchronized (priorityQueue) {
            evt = (RMEvent)this.m_workQ.dequeue();
            if (evt == null) {
                return null;
            }
            this.m_workQSize = (int)((long)this.m_workQSize - evt.memoryLength());
            --this.m_workQCount;
            if (this.m_workQSize >= MAX_WORKQ_SIZE) {
                return evt;
            }
            if (!this.m_isOkToSend) {
                this.m_isOkToSend = true;
                if (this.m_notifyTarget != null) {
                    Object object = this.m_notifyTarget;
                    synchronized (object) {
                        this.m_notifyTarget.notifyAll();
                    }
                }
            }
        }
        return evt;
    }

    public RMSequence getSequenceState() {
        return this.m_rmseq;
    }

    public void setSequenceState(RMSequence rms) {
        this.m_rmseq = rms;
    }

    public abstract void service();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markForTermination(RMEvent cancellationEvent) {
        PriorityQueue priorityQueue = this.m_workQ;
        synchronized (priorityQueue) {
            this.m_markedForTermination = true;
            this.m_workQ.cancel();
            while (this.m_workQ.dequeue() != null) {
            }
            this.m_workQSize = 0;
            this.m_workQCount = 0;
        }
        if (cancellationEvent != null) {
            this.enqueue(cancellationEvent, 12);
        }
    }

    public void setWSANS(String ns) {
        this.m_wsaNS = ns;
    }

    public String getWSANS() {
        return this.m_wsaNS;
    }

    public void setConstants(Constants c) {
        this.m_constants = c;
    }

    public Constants getConstants() {
        return this.m_constants;
    }

    public void setSOAPConstants(SOAPConstants c) {
        this.m_soapconstants = c;
    }

    public SOAPConstants getSOAPConstants() {
        return this.m_soapconstants;
    }

    public String getId() {
        return this.m_rmseq.getSequenceIdentifier().getIdentifier();
    }

    public static long evaluateBinaryExponentialInterval(long baseline, long maxBackoffs, long retransmits) {
        if (maxBackoffs <= 0L) {
            return baseline;
        }
        long exponent = retransmits;
        if (retransmits > maxBackoffs) {
            exponent = maxBackoffs;
        }
        long result = baseline * (long)Math.pow(2.0, exponent);
        return result;
    }

    public boolean isMarkedForTermination() {
        return this.m_markedForTermination;
    }

    public boolean isLocallyHomed() {
        return this.m_isLocallyHomed;
    }

    public void setLocallyHomed(boolean isLocallyHomed) {
        this.m_isLocallyHomed = isLocallyHomed;
    }

    public String toString() {
        return new String(this.getId() + ":" + this.getState() + " " + this.getSequenceState());
    }
}

