/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy;

import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.action.Action;
import com.sonicsw.ws.security.action.Encryption;
import com.sonicsw.ws.security.action.MessagePart;
import com.sonicsw.ws.security.action.Signature;
import com.sonicsw.ws.security.action.SupportingToken;
import com.sonicsw.ws.security.action.Timestamp;
import com.sonicsw.ws.security.action.TransportBindingAction;
import com.sonicsw.ws.security.policy.Assertion;
import com.sonicsw.ws.security.policy.WSSPConstants;
import com.sonicsw.ws.security.policy.model.HttpsToken;
import com.sonicsw.ws.security.policy.model.KeyStoreEntry;
import com.sonicsw.ws.security.policy.model.RequiredElements;
import com.sonicsw.ws.security.policy.model.TransportBinding;
import com.sonicsw.ws.security.policy.model.TransportToken;
import com.sonicsw.ws.security.policy.model.Trust10Token;
import com.sonicsw.ws.security.policy.model.X509IssuerSerial;
import com.sonicsw.ws.security.policy.model.X509Token;
import com.sonicsw.wsp.PolicyException;
import com.sonicsw.wsp.SecurityPolicyException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ws.security.policy.model.AlgorithmSuite;
import org.apache.ws.security.policy.model.AsymmetricBinding;
import org.apache.ws.security.policy.model.Binding;
import org.apache.ws.security.policy.model.Header;
import org.apache.ws.security.policy.model.Layout;
import org.apache.ws.security.policy.model.PolicyEngineData;
import org.apache.ws.security.policy.model.RootPolicyEngineData;
import org.apache.ws.security.policy.model.SignedEncryptedElements;
import org.apache.ws.security.policy.model.SignedEncryptedParts;
import org.apache.ws.security.policy.model.SymmetricAsymmetricBindingBase;
import org.apache.ws.security.policy.model.SymmetricBinding;
import org.apache.ws.security.policy.model.Token;
import org.apache.ws.security.policy.model.UsernameToken;
import org.apache.ws.security.policy.model.Wss10;
import org.apache.ws.security.policy.model.Wss11;

public class SecurityPolicyAlternative {
    private ArrayList m_actions = new ArrayList();
    private boolean m_secPolicy2002 = true;

    public boolean isPolicy2002() {
        return this.m_secPolicy2002;
    }

    public void addAction(Assertion assertion) {
        this.m_actions.add(assertion.getAction());
    }

    public void addAction(Action action) {
        this.m_actions.add(action);
    }

    public Action[] getActions() {
        Action[] actions = new Action[this.m_actions.size()];
        actions = this.m_actions.toArray(actions);
        return actions;
    }

    public void addActions(ArrayList actions) {
        this.m_actions.addAll(actions);
    }

    public void addActions(Action[] actions) {
        for (int i = 0; i < actions.length; ++i) {
            this.m_actions.add(actions[i]);
        }
    }

    public void buildActions(RootPolicyEngineData rootPed) throws PolicyException {
        this.m_secPolicy2002 = false;
        try {
            ActionBuilder actionBuilder = new ActionBuilder();
            actionBuilder.build(rootPed, this.m_actions);
        }
        catch (PolicyException e) {
            DebugObjects.getPolicyDebug().debug("Exception encountered processing the Policy: " + e.getMessage());
            throw e;
        }
    }

    private static class ActionBuilder {
        private Encryption m_encryption;
        private Signature m_signature;
        private SupportingToken m_supportingToken;
        private Timestamp m_timestamp;
        private TransportBindingAction m_transport;
        private Binding m_binding = null;
        private boolean m_encryptBeforeSigning = false;
        private boolean m_encryptSignature = false;

        ActionBuilder() {
            this.init();
        }

        private void init() {
            this.clear();
            this.m_encryption = new Encryption(2005);
            this.m_signature = new Signature(2005);
            this.m_supportingToken = new SupportingToken(2005);
            this.m_timestamp = new Timestamp(2005);
            this.m_transport = new TransportBindingAction(2005);
        }

        private void clear() {
            this.m_encryption = null;
            this.m_signature = null;
            this.m_supportingToken = null;
            this.m_timestamp = null;
            this.m_transport = null;
            this.m_binding = null;
            this.m_encryptBeforeSigning = false;
            this.m_encryptSignature = false;
        }

        void build(RootPolicyEngineData rootPed, ArrayList actionList) throws PolicyException {
            ArrayList peds = rootPed.getTopLevelPEDs();
            for (PolicyEngineData ped : peds) {
                DebugObjects.getPolicyDebug().debug("SecurityPolicyAlternative about to process " + ped);
                if (ped instanceof AsymmetricBinding) {
                    this.processBinding((AsymmetricBinding)ped);
                    continue;
                }
                if (ped instanceof SymmetricBinding) {
                    this.processBinding((SymmetricBinding)ped);
                    continue;
                }
                if (ped instanceof TransportBinding) {
                    this.processBinding((TransportBinding)ped);
                    continue;
                }
                if (ped instanceof SignedEncryptedParts) {
                    this.processSignedEncryptedParts((SignedEncryptedParts)ped);
                    continue;
                }
                if (ped instanceof SignedEncryptedElements) {
                    this.processSignedEncryptedElements((SignedEncryptedElements)ped);
                    continue;
                }
                if (ped instanceof RequiredElements) {
                    this.processRequiredElements((RequiredElements)ped);
                    continue;
                }
                if (ped instanceof org.apache.ws.security.policy.model.SupportingToken) {
                    this.processSupportingToken((org.apache.ws.security.policy.model.SupportingToken)ped);
                    continue;
                }
                if (ped instanceof Wss11) {
                    this.processWss11((Wss11)ped);
                    continue;
                }
                if (ped instanceof Wss10) {
                    this.processWss10((Wss10)ped);
                    continue;
                }
                if (ped instanceof Trust10Token) {
                    this.processTrust10((Trust10Token)ped);
                    continue;
                }
                throw new SecurityPolicyException(ped + " not supported as top level Assertion.");
            }
            this.addRequiredActions(actionList);
            this.clear();
        }

        private void processSupportingToken(org.apache.ws.security.policy.model.SupportingToken supportingToken) throws SecurityPolicyException {
            Token token;
            if (this.m_binding != null && !(this.m_binding instanceof TransportBinding)) {
                throw new SecurityPolicyException("Binding assertion is incompatible with supporting token assertion.");
            }
            int type = supportingToken.getType();
            if (type == 3) {
                if (supportingToken.getAlgorithmSuite() != null || supportingToken.getEncryptedElements() != null || supportingToken.getEncryptedParts() != null || supportingToken.getSignedElements() != null || supportingToken.getSignedParts() != null) {
                    throw new SecurityPolicyException("Policy contains SignedSupportingToken assertion that is not yet supported. The only assertion currently supported is UsernameToken.");
                }
                ArrayList tokenList = supportingToken.getToken();
                if (tokenList == null || tokenList.isEmpty()) {
                    throw new SecurityPolicyException("No token specified in SupportingToken assertion.");
                }
                if (tokenList.size() > 1) {
                    throw new SecurityPolicyException("Multiple tokens specified but not supported in SupportingToken assertion.");
                }
                token = (Token)tokenList.get(0);
                if (!(token instanceof UsernameToken)) {
                    throw new SecurityPolicyException("Invalid token type " + token.getClass().getName());
                }
            } else {
                if (HttpHelper.ENABLE_SECURE_CONVERSATION) {
                    if (type == 2) {
                        throw new UnsupportedOperationException("EndorsingSupportingToken not yet supported.");
                    }
                    throw new SecurityPolicyException("Unsupported SupportingToken type. Only SignedSupportingToken and EndorsingSupportingToken are supported.");
                }
                throw new SecurityPolicyException("Unsupported SupportingToken type. Only SignedSupportingToken is supported.");
            }
            this.m_supportingToken.setUsernameToken((UsernameToken)token);
            this.m_supportingToken.setTokenType(WSSPConstants.QN_TOKENTYPE_USERNAME);
            this.m_supportingToken.setRequired();
        }

        private void processBinding(Binding binding) throws SecurityPolicyException {
            this.validateBinding(binding);
            this.populateSignature(binding);
            this.populateTimeStamp(binding);
            this.validateLayout(binding);
            this.m_binding = binding;
        }

        private void populateSignature(Binding binding) throws SecurityPolicyException {
            AlgorithmSuite algoSuite = binding.getAlgorithmSuite();
            if (algoSuite.getDigest() != "http://www.w3.org/2000/09/xmldsig#sha1") {
                throw new SecurityPolicyException("Unsupported AlgorithmSuite: " + algoSuite.getDigest());
            }
            if (binding instanceof SymmetricBinding) {
                this.m_signature.setAlgSignature(algoSuite.getSymmetricSignature());
            } else if (binding instanceof AsymmetricBinding) {
                this.m_signature.setAlgSignature(algoSuite.getAsymmetricSignature());
            } else if (binding instanceof TransportBinding) {
                this.m_transport.setAlgorithmSuite(algoSuite);
            }
            this.m_signature.setAlgCanonicalization(algoSuite.getInclusiveC14n());
            this.m_signature.setAlgDigest(algoSuite.getDigest());
            this.m_encryption.setAlgEncryption(algoSuite.getEncryption());
            this.m_encryption.setKeyEncryptionAlgorithm(algoSuite.getAsymmetricKeyWrap());
        }

        private void validateLayout(Binding binding) throws SecurityPolicyException {
            Layout layout = binding.getLayout();
            if (!"Lax".equals(layout.getValue())) {
                throw new SecurityPolicyException("Unsupported Layout specified " + layout.getValue() + ".");
            }
        }

        private void validateBinding(Binding binding) throws SecurityPolicyException {
            if (this.m_binding != null) {
                throw new SecurityPolicyException(binding.getClass().getName() + " encountered in a policy alternative that already includes a " + this.m_binding.getClass().getName() + ".");
            }
        }

        private void populateTimeStamp(Binding binding) {
            if (binding.isIncludeTimestamp()) {
                this.m_timestamp.setRequired();
                this.m_timestamp.requireTimestamp();
                if (binding instanceof AsymmetricBinding) {
                    this.m_signature.setRequired();
                    this.m_signature.addPart(new MessagePart("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp"));
                }
            }
        }

        private void processBinding(SymmetricAsymmetricBindingBase binding) throws SecurityPolicyException {
            this.processBinding((Binding)binding);
            if (this.m_supportingToken.isRequired()) {
                throw new SecurityPolicyException("Binding assertion is incompatible with supporting token assertion");
            }
            if (binding.getProtectionOrder().equals("EncryptBeforeSigning")) {
                this.m_encryptBeforeSigning = true;
            }
            if (binding.isSignatureProtection()) {
                this.m_encryptSignature = true;
            }
            if (binding.isTokenProtection()) {
                this.m_signature.addPart(new MessagePart(WSSPConstants.QN_SIGNING_TOKEN));
            }
            if (binding.isEntireHeaderAndBodySignatures()) {
                this.m_signature.setEntireHeaderAndBodySignatures(true);
            }
        }

        private void processBinding(AsymmetricBinding as) throws SecurityPolicyException {
            this.processBinding((SymmetricAsymmetricBindingBase)as);
            Token token = as.getInitiatorToken().getInitiatorToken();
            this.processToken(token, true);
            this.m_signature.setInitiatorToken(as.getInitiatorToken());
            this.m_encryption.setInitiatorToken(as.getInitiatorToken());
            token = as.getRecipientToken().getRecipientToken();
            this.processToken(token, false);
            this.m_signature.setRecipientToken(as.getRecipientToken());
            this.m_encryption.setRecipientToken(as.getRecipientToken());
        }

        private void processBinding(SymmetricBinding sb) throws SecurityPolicyException {
            this.processBinding((SymmetricAsymmetricBindingBase)sb);
            if (HttpHelper.ENABLE_SECURE_CONVERSATION) {
                if (sb.getProtectionToken() == null) {
                    throw new SecurityPolicyException("Only ProtectionToken use is supported for SymmetricBinding assertions");
                }
                this.m_signature.setProtectionToken(sb.getProtectionToken());
                this.m_encryption.setProtectionToken(sb.getProtectionToken());
                return;
            }
            throw new SecurityPolicyException("SymmetricBinding not supported" + (HttpHelper.ENABLE_SECURE_CONVERSATION ? "outside of a SecureConversation" : "") + ".");
        }

        private void processBinding(TransportBinding tb) throws SecurityPolicyException {
            Token transportToken;
            this.processBinding((Binding)tb);
            this.m_transport.setRequired();
            this.m_transport.setTokenType(WSSPConstants.QN_TRANSPORT_BINDING);
            if (tb.getSupportingToken() != null) {
                this.processSupportingToken(tb.getSupportingToken());
            }
            if ((transportToken = tb.getTransportToken()) != null && transportToken instanceof TransportToken) {
                this.m_transport.setTransportToken((TransportToken)transportToken);
                Token httpsToken = ((TransportToken)transportToken).getTransportToken();
                if (httpsToken != null && httpsToken instanceof HttpsToken) {
                    this.m_transport.setHttpsToken((HttpsToken)httpsToken);
                }
            }
        }

        private void processToken(Token token, boolean initiator) throws SecurityPolicyException {
            if (!(token instanceof X509Token)) {
                throw new SecurityPolicyException("Unsupported " + (initiator ? "Initiator" : "Recipient") + "Token type: " + token.getClass().getName() + ". Only X509Token is supported.");
            }
            X509Token x509Token = this.retrieveX509Token(initiator, token);
            this.validateVersionAndType(initiator, x509Token);
            this.validateData(initiator, x509Token);
            this.populateSignatureEncryption(initiator, x509Token);
        }

        private void populateSignatureEncryption(boolean initiator, X509Token x509Token) throws SecurityPolicyException {
            KeyStoreEntry keyStoreEntry = x509Token.getKeyStoreEntry();
            X509IssuerSerial issuerSerial = x509Token.getX509IssuerSerial();
            if (keyStoreEntry != null && issuerSerial != null) {
                throw new SecurityPolicyException("Invalid use of multiple per-mesage override assertions in " + (initiator ? "Initiator" : "Recipient") + "Token.");
            }
            if (keyStoreEntry != null) {
                this.m_signature.setX509TokenAlias(keyStoreEntry.getAlias());
                this.m_signature.setX509TokenPrivateKeyPassword(keyStoreEntry.getPrivateKeyPassword());
            }
            if (issuerSerial != null) {
                this.m_encryption.setX509TokenRefIssuer(issuerSerial.getX509IssuerName());
                this.m_encryption.setX509TokenRefSerialNumber(issuerSerial.getX509SerialNumber());
            }
        }

        private void validateData(boolean initiator, X509Token x509Token) throws SecurityPolicyException {
            if (x509Token.isRequireEmbeddedTokenReference() || x509Token.isRequireThumbprintReference()) {
                throw new SecurityPolicyException("Unsupported token reference model required by " + (initiator ? "Initiator" : "Recipient") + "Token. Only RequireKeyIdentierReference and RequireIssuerSerialReference are supported.");
            }
            if (x509Token.isRequireKeyIdentifierReference() && x509Token.isRequireIssuerSerialReference()) {
                throw new SecurityPolicyException("Invalid specification of multiple token reference models in " + (initiator ? "Initiator" : "Recipient") + "Token.");
            }
        }

        private void validateVersionAndType(boolean initiator, X509Token x509Token) throws SecurityPolicyException {
            if (x509Token.getTokenVersionAndType() != null && !x509Token.getTokenVersionAndType().equals("WssX509V3Token10")) {
                throw new SecurityPolicyException("Unsupported " + (initiator ? "Initiator" : "Recipient") + "Token X509Token version: " + x509Token.getTokenVersionAndType() + ". Only " + "WssX509V3Token10" + " is supported.");
            }
        }

        private X509Token retrieveX509Token(boolean initiator, Token token) throws SecurityPolicyException {
            X509Token x509Token = (X509Token)token;
            if ("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Once".equals(x509Token.getInclusion())) {
                throw new SecurityPolicyException("Unsupported  " + (initiator ? "Initiator" : "Recipient") + "Token IncludeToken value" + "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Once" + ".");
            }
            return x509Token;
        }

        private void processSignedEncryptedParts(SignedEncryptedParts sep) throws SecurityPolicyException {
            ArrayList<MessagePart> parts = new ArrayList<MessagePart>();
            if (sep.isBody()) {
                parts.add(new MessagePart());
            }
            List headers = this.retrieveHeaders(parts, sep);
            this.populateSignatureAndEncryption(headers, parts, sep);
        }

        private List retrieveHeaders(ArrayList parts, SignedEncryptedParts sep) throws SecurityPolicyException {
            ArrayList headers = sep.getHeaders();
            if (!headers.isEmpty()) {
                if (sep.isSignedParts()) {
                    for (Header header : headers) {
                        if (header.getName() == null || header.getName().length() == 0) {
                            throw new SecurityPolicyException((sep.isSignedParts() ? "Signed" : "Encrypted") + "Parts optional ommission of Header Name attribute is not supported.");
                        }
                        parts.add(new MessagePart(header.getNamespace(), header.getName()));
                    }
                } else {
                    throw new SecurityPolicyException("Encrypting headers requires unsupported WSS 1.1 Encrypted Headers.");
                }
            }
            return headers;
        }

        private void populateSignatureAndEncryption(List headers, ArrayList parts, SignedEncryptedParts sep) throws SecurityPolicyException {
            if (!sep.isBody() && headers.isEmpty()) {
                if (sep.isSignedParts()) {
                    throw new SecurityPolicyException("Empty SignedParts assertion is not supported.");
                }
                parts.add(new MessagePart());
            }
            if (sep.isSignedParts()) {
                this.m_signature.setRequired();
                this.m_signature.addParts(parts);
            } else {
                this.m_encryption.setRequired();
                this.m_encryption.addParts(parts);
            }
        }

        private void processSignedEncryptedElements(SignedEncryptedElements see) throws SecurityPolicyException {
            throw new SecurityPolicyException((see.isSignedElements() ? "Signed" : "Encrypted") + "Elements assertion not supported.");
        }

        private void processRequiredElements(RequiredElements see) throws SecurityPolicyException {
            throw new SecurityPolicyException("RequiredElements assertion not supported.");
        }

        private void processWss10(Wss10 wss10) throws SecurityPolicyException {
            if (wss10.isMustSupportRefEmbeddedToken() || wss10.isMustSupportRefExternalURI()) {
                throw new SecurityPolicyException("Unsupported Wss10 assertion(s) " + (wss10.isMustSupportRefEmbeddedToken() ? "MustSupportRefEmbeddedToken " : "") + (wss10.isMustSupportRefExternalURI() ? "MustSupportRefExternalURI " : ""));
            }
            if (wss10.isMustSupportRefKeyIdentifier()) {
                this.m_signature.setMustSupportRefKeyIdentifier(true);
                this.m_encryption.setMustSupportRefKeyIdentifier(true);
            }
            if (wss10.isMustSupportRefIssuerSerial()) {
                this.m_signature.setMustSupportRefIssuerSerial(true);
                this.m_encryption.setMustSupportRefIssuerSerial(true);
            }
        }

        private void processWss11(Wss11 wss11) throws SecurityPolicyException {
            if (wss11.isMustSupportRefThumbprint() || wss11.isMustSupportRefEncryptedKey() || wss11.isRequireSignatureConfirmation()) {
                throw new SecurityPolicyException("Unsupported Wss11 assertion(s) " + (wss11.isMustSupportRefThumbprint() ? "MustSupportRefThumbprint " : "") + (wss11.isMustSupportRefEncryptedKey() ? "MustSupportRefEncryptedKey " : "") + (wss11.isRequireSignatureConfirmation() ? "MustRequireSignatureConfirmation " : ""));
            }
            this.processWss10((Wss10)wss11);
        }

        private void processTrust10(Trust10Token trust10) throws SecurityPolicyException {
            if (trust10.getRequireClientEntropy()) {
                this.m_signature.setRequireClientEntropy(true);
                this.m_encryption.setRequireClientEntropy(true);
            }
            if (trust10.getRequireServerEntropy()) {
                this.m_signature.setRequireServerEntropy(true);
                this.m_encryption.setRequireServerEntropy(true);
            }
            if (trust10.getMustSupportClientChallenge()) {
                throw new SecurityPolicyException("/sp:Trust10/wsp:Policy/sp:MustSupportClientChallenge is not supported by SonicMQ in either direction. ");
            }
            if (trust10.getMustSupportServerChallenge()) {
                throw this.createSecurityPolicyException();
            }
            if (trust10.getMustSupportIssuedTokens()) {
                throw this.createSecurityPolicyException();
            }
        }

        private SecurityPolicyException createSecurityPolicyException() {
            return new SecurityPolicyException("/sp:Trust10/wsp:Policy/sp:MustSupportServerChallenge is not supported by SonicMQ in either direction. ");
        }

        private void addRequiredActions(ArrayList actions) {
            if (this.m_timestamp.isRequired()) {
                actions.add(this.m_timestamp);
            }
            if (this.m_supportingToken.isRequired()) {
                actions.add(this.m_supportingToken);
            }
            if (this.m_encryptBeforeSigning && this.m_encryption.isRequired()) {
                actions.add(this.m_encryption);
            }
            if (this.m_signature.isRequired()) {
                actions.add(this.m_signature);
                if (this.m_encryptSignature) {
                    if (this.m_encryptBeforeSigning) {
                        Encryption encryptSignature = new Encryption(this.m_encryption);
                        encryptSignature.addPart(new MessagePart("http://www.w3.org/2000/09/xmldsig#", "Signature", true));
                        actions.add(encryptSignature);
                    } else {
                        this.m_encryption.addPart(new MessagePart("http://www.w3.org/2000/09/xmldsig#", "Signature", true));
                        this.m_encryption.setRequired();
                    }
                }
            }
            if (this.m_encryption.isRequired() && !actions.contains(this.m_encryption)) {
                actions.add(this.m_encryption);
            }
            if (this.m_transport.isRequired()) {
                actions.add(this.m_transport);
            }
        }
    }
}

