/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy.model;

import com.sonicsw.wsp.PolicyException;
import org.apache.ws.security.policy.model.AlgorithmSuite;

public class SonicAlgorithmSuiteUtils {
    public static String getAlgorithmSuiteName(AlgorithmSuite algo) throws PolicyException {
        if (algo.getDigest() == "http://www.w3.org/2000/09/xmldsig#sha1" && algo.getEncryption() == "http://www.w3.org/2001/04/xmlenc#aes256-cbc" && algo.getSymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#kw-aes128" && algo.getAsymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p" && algo.getEncryptionKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getSignatureKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getMinimumSymmetricKeyLength() == 256) {
            return "Basic256";
        }
        if (algo.getDigest() == "http://www.w3.org/2000/09/xmldsig#sha1" && algo.getEncryption() == "http://www.w3.org/2001/04/xmlenc#aes192-cbc" && algo.getSymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#kw-aes192" && algo.getAsymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p" && algo.getEncryptionKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getSignatureKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getMinimumSymmetricKeyLength() == 192) {
            return "Basic192";
        }
        if (algo.getDigest() == "http://www.w3.org/2000/09/xmldsig#sha1" && algo.getEncryption() == "http://www.w3.org/2001/04/xmlenc#aes128-cbc" && algo.getSymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#kw-aes256" && algo.getAsymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p" && algo.getEncryptionKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getSignatureKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getMinimumSymmetricKeyLength() == 128) {
            return "Basic128";
        }
        if (algo.getDigest() == "http://www.w3.org/2000/09/xmldsig#sha1" && algo.getEncryption() == "http://www.w3.org/2001/04/xmlenc#tripledes-cbc" && algo.getSymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#kw-tripledes" && algo.getAsymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p" && algo.getEncryptionKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getSignatureKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getMinimumSymmetricKeyLength() == 192) {
            return "TripleDes";
        }
        if (algo.getDigest() == "http://www.w3.org/2000/09/xmldsig#sha1" && algo.getEncryption() == "http://www.w3.org/2001/04/xmlenc#aes256-cbc" && algo.getSymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#kw-aes128" && algo.getAsymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#rsa-1_5" && algo.getEncryptionKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getSignatureKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getMinimumSymmetricKeyLength() == 256) {
            return "Basic256Rsa15";
        }
        if (algo.getDigest() == "http://www.w3.org/2000/09/xmldsig#sha1" && algo.getEncryption() == "http://www.w3.org/2001/04/xmlenc#aes192-cbc" && algo.getSymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#kw-aes192" && algo.getAsymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#rsa-1_5" && algo.getEncryptionKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getSignatureKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getMinimumSymmetricKeyLength() == 192) {
            return "Basic192Rsa15";
        }
        if (algo.getDigest() == "http://www.w3.org/2000/09/xmldsig#sha1" && algo.getEncryption() == "http://www.w3.org/2001/04/xmlenc#aes128-cbc" && algo.getSymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#kw-aes256" && algo.getAsymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#rsa-1_5" && algo.getEncryptionKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getSignatureKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getMinimumSymmetricKeyLength() == 128) {
            return "Basic128Rsa15";
        }
        if (algo.getDigest() == "http://www.w3.org/2000/09/xmldsig#sha1" && algo.getEncryption() == "http://www.w3.org/2001/04/xmlenc#tripledes-cbc" && algo.getSymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#kw-tripledes" && algo.getAsymmetricKeyWrap() == "http://www.w3.org/2001/04/xmlenc#rsa-1_5" && algo.getEncryptionKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getSignatureKeyDerivation() == "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1" && algo.getMinimumSymmetricKeyLength() == 192) {
            return "TripleDesRsa15";
        }
        throw new PolicyException("Cannot determine name for specified AlgorithmSuite,  uite not enabled with algo.getDigest()=" + algo.getDigest() + " algo.getEncryption()=" + algo.getEncryption() + " algo.getSymmetricKeyWrap()=" + algo.getSymmetricKeyWrap() + " algo.getAsymmetricKeyWrap()=" + algo.getAsymmetricKeyWrap() + " algo.getEncryptionKeyDerivation()=" + algo.getEncryptionKeyDerivation() + " algo.getSignatureKeyDerivation()=" + algo.getSignatureKeyDerivation() + " algo.getMinimumSymmetricKeyLength()=" + algo.getMinimumSymmetricKeyLength());
    }

    public static String getRSACipherSuiteName(String wsStandardName) throws PolicyException {
        if (wsStandardName.equalsIgnoreCase("Basic256")) {
            return "RSA_WITH_AES_256_CBC_SHA";
        }
        if (wsStandardName.equalsIgnoreCase("Basic192")) {
            return "RSA_WITH_AES_192_CBC_SHA";
        }
        if (wsStandardName.equalsIgnoreCase("Basic128")) {
            return "RSA_WITH_AES_128_CBC_SHA";
        }
        if (wsStandardName.equalsIgnoreCase("TripleDes")) {
            return "RSA_WITH_3DES_EDE_CBC_SHA";
        }
        if (wsStandardName.equalsIgnoreCase("Basic256Rsa15")) {
            return "RSA_WITH_AES_256_CBC_SHA";
        }
        if (wsStandardName.equalsIgnoreCase("Basic192Rsa15")) {
            return "RSA_WITH_AES_192_CBC_SHA";
        }
        if (wsStandardName.equalsIgnoreCase("Basic128Rsa15")) {
            return "RSA_WITH_AES_128_CBC_SHA";
        }
        if (wsStandardName.equalsIgnoreCase("TripleDesRsa15")) {
            return "RSA_WITH_3DES_EDE_CBC_SHA";
        }
        throw new PolicyException("getRSACipherSuiteName: Cannot determine enabled RSA SSL CipherSuite to match " + wsStandardName);
    }

    public static String getWSAlgorithmSuiteName(String wsRSAName) throws PolicyException {
        if ("RSA_WITH_AES_256_CBC_SHA".equalsIgnoreCase(wsRSAName)) {
            return "Basic256Rsa15";
        }
        if ("RSA_WITH_AES_192_CBC_SHA".equalsIgnoreCase(wsRSAName)) {
            return "Basic192Rsa15";
        }
        if ("RSA_WITH_AES_128_CBC_SHA".equalsIgnoreCase(wsRSAName)) {
            return "Basic128Rsa15";
        }
        if ("RSA_WITH_3DES_EDE_CBC_SHA".equalsIgnoreCase(wsRSAName)) {
            return "TripleDesRsa15";
        }
        throw new PolicyException("getWSAlgorithmSuiteName: Cannot determine WS Standard AlgorithmSuite to match RSA CipherSuite " + wsRSAName);
    }
}

