/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.processingresult;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.action.SupportingToken;
import com.sonicsw.ws.security.policy.WSSPConstants;
import com.sonicsw.ws.security.policy.WSSPUtils;

public class SupportingTokenResult {
    private String m_nonce = null;
    private String m_createdTime = null;
    private boolean m_isPasswordDigest = false;
    private String m_username = null;
    private String m_password = null;

    public SupportingTokenResult(String name, String pwd, boolean digest, String nonce, String timestamp) {
        if (name == null) {
            throw new NullPointerException("illegal null input");
        }
        this.setUsername(name);
        this.setPassword(pwd);
        this.m_isPasswordDigest = digest;
        this.m_nonce = nonce;
        this.m_createdTime = timestamp;
    }

    public boolean isPasswordDigest() {
        return this.m_isPasswordDigest;
    }

    public void setNonce(String nonce) {
        this.m_nonce = nonce;
    }

    public String getNonce() {
        return this.m_nonce;
    }

    public void setCreatedTime(String createdTime) {
        this.m_createdTime = createdTime;
    }

    public String getCreatedTime() {
        return this.m_createdTime;
    }

    public String getUsername() {
        return this.m_username;
    }

    public String getPassword() {
        return this.m_password;
    }

    public final void setUsername(String uid) {
        this.m_username = uid;
    }

    public final void setPassword(String pwd) {
        this.m_password = pwd;
    }

    public boolean validate(SupportingToken sta) {
        if (!sta.getTokenType().equals(WSSPConstants.QN_TOKENTYPE_USERNAME)) {
            return false;
        }
        if (sta.getPasswordType() != null) {
            if (sta.getPasswordType().equals(WSSPConstants.QN_PASSWORDTYPE_DIGEST) && !this.isPasswordDigest()) {
                return false;
            }
            if (sta.getPasswordType().equals(WSSPConstants.QN_PASSWORDTYPE_TEXT) && this.isPasswordDigest()) {
                return false;
            }
        }
        if (sta.getSubjectName() != null) {
            DebugObjects.getPolicyDebug().debug("SupportingTokenResult: Validating the subject name match, match type = " + sta.getSubjectNameMatchType() + ", expected subject = " + sta.getSubjectName());
            if (!WSSPUtils.match(sta.getSubjectNameMatchType(), sta.getSubjectName(), this.getUsername())) {
                DebugObjects.getPolicyDebug().debug("SupportingTokenResult: Validation of subject name failed, found " + this.getUsername());
                return false;
            }
        }
        return true;
    }
}

