/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.ETxnAccessViolation;
import progress.message.broker.ETxnNotFound;
import progress.message.broker.ETxnSequenceError;
import progress.message.client.EGeneralException;
import progress.message.client.EXADuplicateXidException;
import progress.message.client.EXAThereIsNoXidException;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Message;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;

public final class AbortGlobalTransaction
extends DebugObject
implements IMessageHandler {
    private AgentRegistrar m_reg;

    AbortGlobalTransaction(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "AbortGT" : null);
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block21: {
            Message rep = new Message();
            try {
                long clientId = AddrUtil.getIdFromAdmin(env.getSubject());
                Message req = env.getMessage();
                Object xid = req.readObject();
                int tid = req.readInt();
                boolean startTx = req.readBoolean();
                if (this.DEBUG) {
                    this.debug("startTx=" + startTx);
                }
                this.m_reg.getTransactionMgr().abortTxn(tid, xid, clientId);
                rep.writeShort(0);
                if (startTx) {
                    int newTx = 0;
                    ISubject subj = env.getMessage().getSubject();
                    String uid = subj.extractSubjectLevel(2);
                    String appid = subj.extractSubjectLevel(3);
                    newTx = this.m_reg.getTransactionMgr().beginTxn(uid, appid, xid);
                    rep.writeInt(newTx);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (EInvalidAdminAddress e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                rep.writeShort(1);
            }
            catch (ClassNotFoundException e) {
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                rep.writeShort(1);
            }
            catch (EXAThereIsNoXidException e) {
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                rep.writeShort(12);
            }
            catch (ETxnNotFound e) {
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                rep.writeShort(2);
            }
            catch (ETxnSequenceError e) {
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                rep.writeShort(3);
            }
            catch (ETxnAccessViolation e) {
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                rep.writeShort(6);
            }
            catch (EXADuplicateXidException e) {
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                rep.writeShort(11);
            }
            catch (IOException e) {
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                rep.writeShort(1);
            }
            try {
                s.reply(rep, env);
            }
            catch (EGeneralException e) {
                if (Broker.isInShutdown()) break block21;
                SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            }
        }
    }
}

