/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import progress.message.broker.AgentAdminSession;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BaseAgentQueue;
import progress.message.broker.DelayedDeliveryQueue;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IClientContext;
import progress.message.broker.ISavableAgentQueue;
import progress.message.broker.QElement;
import progress.message.broker.QToken;
import progress.message.broker.SavableQElement;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.TokenMgrError;
import progress.message.broker.prAccessor;
import progress.message.client.EGeneralException;
import progress.message.client.ESecurityGeneralException;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.IndexedList;
import progress.message.util.QueueUtil;
import progress.message.zclient.Envelope;
import progress.message.zclient.Label;
import progress.message.zclient.Message;

public class AgentDelayedDeliveryQueue
extends BaseAgentQueue
implements IAgentQueue,
ISavableAgentQueue {
    private String m_name;
    private String m_address;
    private AgentRegistrar m_reg;
    private Label m_emptyLabel;
    private DelayedDeliveryQueue m_queue;
    private int m_state = 0;
    private boolean m_global = false;
    private boolean m_clustered = false;
    private boolean m_readOnly = false;
    private boolean m_readExclusive = false;
    private boolean m_writeOnly = false;
    private boolean m_writeExclusive = false;
    private int m_nonDelayableReceiverCount = 0;
    Object m_dispatchLock = new Object();
    static final int s_SAVABLE_QUEUE_ELEMENT_TYPE_CODE = 1;

    public AgentDelayedDeliveryQueue(String qName, DelayedDeliveryQueue ddq, AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "AgentDelayedDeliveryQueue" : null);
        this.m_queue = ddq;
        this.initInstance(qName, reg);
    }

    @Override
    public synchronized void clearExpiredMsgs() throws InterruptedException {
        this.clearExpiredMsgs(false);
    }

    public synchronized void clearExpiredMsgs(boolean checkRemoteSubscriptionDeletion) throws InterruptedException {
        this.m_queue.checkForExpiredMsgs();
        this.updateQueueStats();
    }

    @Override
    public void onOutstandingLocalClientGetRequests() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(long cid, short requestType, int countParam, boolean isRemoteGetRequest) {
        int count = countParam;
        IMgram m = null;
        switch (requestType) {
            case 1: {
                if (this.DEBUG) {
                    this.debug("RCV request from CID:" + cid + ", Count:" + count);
                }
                this.addRequest(cid, count, isRemoteGetRequest);
                break;
            }
            case 2: {
                if (this.DEBUG) {
                    this.debug("RCVNOWAIT request from CID:" + cid + ", Count:" + count);
                }
                DelayedDeliveryQueue delayedDeliveryQueue = this.m_queue;
                synchronized (delayedDeliveryQueue) {
                    m = (IMgram)this.m_queue.dequeue(cid);
                    try {
                        IClientContext cc = this.m_reg.getClient(cid);
                        String subject = QueueUtil.getQueueClientSubject(cc.getUid(), cc.getAppid(), m == null ? "queueEmpty" : "queueNotEmpty");
                        Envelope env = new Envelope(new Message(subject));
                        this.m_reg.getAdminSession().publish(env, 0, false);
                        if (this.DEBUG) {
                            this.debug("Sent notification to:" + subject);
                        }
                        if (m != null) {
                            this.deliver(m, cid);
                        }
                    }
                    catch (EClientNotRegistered e) {
                        this.m_queue.reenqueue(m, true);
                        return;
                    }
                    catch (ESecurityGeneralException e) {
                        this.m_queue.reenqueue(m, true);
                        return;
                    }
                    catch (EGeneralException e) {
                        this.m_queue.reenqueue(m, true);
                        return;
                    }
                }
            }
            case 3: {
                if (this.DEBUG) {
                    this.debug("BROWSE request from CID:" + cid + ", Count:" + count + ", for queue:" + this.getQueueName());
                }
                try {
                    while (count > 0 && (m = (IMgram)this.m_queue.browse(cid)) != null) {
                        if (m.isGuarenteed()) {
                            m.setReliable();
                        }
                        this.deliver(m, cid);
                        --count;
                    }
                    if (count <= 0) break;
                    IClientContext cc = null;
                    cc = this.m_reg.getClient(cid);
                    String uid = cc.getUid();
                    String appid = cc.getAppid();
                    AgentAdminSession sn = this.m_reg.getAdminSession();
                    Message reply = new Message();
                    reply.setSubject(QueueUtil.getQueueClientSubject(uid, appid, "endOfBrowse"));
                    try {
                        sn.publish(reply, 0, false);
                    }
                    catch (EGeneralException eGeneralException) {}
                    break;
                }
                catch (EClientNotRegistered e) {
                    return;
                }
                catch (ESecurityGeneralException eSecurityGeneralException) {
                    break;
                }
            }
        }
    }

    @Override
    public String getQueueName() {
        return this.m_name;
    }

    @Override
    public String getQueueAddress() {
        return this.m_address;
    }

    @Override
    public void restore(IndexedList unacked, boolean preserveRedelivery, boolean notifyMsgEnqueued) {
        this.restore(unacked.elements(), preserveRedelivery, notifyMsgEnqueued);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(Enumeration enu, boolean preserveRedelivery, boolean notifyMsgEnqueued) {
        if (!enu.hasMoreElements()) {
            return;
        }
        Vector v = new Vector();
        while (enu.hasMoreElements()) {
            v.addElement(enu.nextElement());
        }
        Object[] msgs = new Object[v.size()];
        v.copyInto(msgs);
        if (this.DEBUG) {
            this.debug("restoring " + msgs.length + " messages to queue");
        }
        DelayedDeliveryQueue delayedDeliveryQueue = this.m_queue;
        synchronized (delayedDeliveryQueue) {
            for (int i = msgs.length - 1; i >= 0; --i) {
                IMgram m = (IMgram)msgs[i];
                if (this.DEBUG) {
                    this.debug("restoring " + m.getGuarenteedTrackingNum());
                }
                this.m_queue.reenqueue(m, preserveRedelivery);
            }
        }
        if (notifyMsgEnqueued) {
            this.initiateDispatching();
        }
        this.updateQueueStats();
    }

    @Override
    public void unreserve(int size) {
        this.m_queue.unreserve(size);
    }

    @Override
    public void acknowledge(long tracking, long ackTracking) {
    }

    @Override
    public void clear() throws InterruptedException {
        this.m_queue.clear();
    }

    @Override
    public synchronized void close() {
        this.m_state = 4;
        this.dispatchShutdown();
        this.m_state = 5;
    }

    @Override
    public boolean closeBrowser(long clientId) {
        return this.m_queue.closeBrowser(clientId);
    }

    @Override
    public void closeReceiver(long clientId) {
    }

    @Override
    public IMgram dequeue(long clientId) throws InterruptedException {
        return null;
    }

    @Override
    public IMgram dequeueByTrackingNum(long trackingNum) {
        return null;
    }

    @Override
    public int dispatch(long clientId, int count, boolean forRemoteBroker) throws InterruptedException {
        if (this.DEBUG) {
            this.debug("dispatch: count of enqueued msgs = " + this.getTotalEnqueued());
        }
        int dispatched = this.dispatchDelayedMsgs();
        if (this.DEBUG) {
            this.debug("dispatch: count of dispatched msgs = " + dispatched);
        }
        return dispatched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int dispatchDelayedMsgs() {
        if (this.m_queue.m_totalEnqueuedCount == 0) {
            this.notifyAll();
            return 0;
        }
        QElement next = this.m_queue.m_queuePriorityToken[this.m_queue.m_highestNonEmptyPriority + 1].getNext();
        int dispatched = 0;
        while (next != null) {
            Long deliveryTime;
            if (next instanceof QToken) {
                next = next.getNext();
                continue;
            }
            SavableQElement elem = (SavableQElement)next;
            next = elem.getNext();
            int reason = 0;
            if (this.m_queue.hasMsgExpired(elem)) {
                reason = 1;
            }
            if (reason != 0) {
                if (this.DEBUG) {
                    this.debug("message expired before dispatch = " + elem);
                }
                this.m_queue.dequeueMsgForCleanup(elem, reason);
                this.updateQueueStats();
                continue;
            }
            IMgram payload = this.m_queue.retrieve(elem);
            if (!payload.hasSidebandData() || (deliveryTime = (Long)payload.getSidebandDataReadOnly().getProperty("JMSDeliveryTime")) == null || deliveryTime > System.currentTimeMillis()) continue;
            if (this.DEBUG) {
                this.debug("message ready to dispatch = " + elem);
            }
            try {
                long tmInQueue;
                long enqTm = elem.getEnqueueTime();
                long l = tmInQueue = enqTm > 0L ? System.currentTimeMillis() - enqTm : 0L;
                if (!this.m_queue.dequeueMsgForUltimateDelivery(elem)) continue;
                ++dispatched;
                this.updateQueueDelvStats(payload);
                if (tmInQueue <= 0L) continue;
                this.updateStatistic(this.m_timeInQueueStat, tmInQueue);
            }
            catch (InterruptedException ex) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ex, 1);
                break;
            }
            finally {
                this.updateQueueStats();
            }
        }
        this.m_queue.notifySpaceAvailable();
        this.notifyAll();
        return dispatched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(IMgram m) {
        long size = 0L;
        if (!m.isGuarenteed()) {
            throw new EAssertFailure("Attemped to enqueue unguaranteed message");
        }
        DelayedDeliveryQueue delayedDeliveryQueue = this.m_queue;
        synchronized (delayedDeliveryQueue) {
            this.m_queue.enqueue(m);
            if (this.DEBUG) {
                size = this.m_queue.getCurrentTotalSize();
            }
            this.m_queue.notifyAll();
        }
        this.initiateDispatching();
        if (this.DEBUG) {
            this.debug("Enqueued TKID:" + m.getGuarenteedTrackingNum() + ", PRI:" + m.getPriority() + ", Queue Size:" + size + (m.isJMSPersistent() ? " PERSISTENT" : ""));
        }
        this.updateQueueStats();
        this.updateQueueRcvdStats(m);
    }

    @Override
    public boolean forceReserve(IMgram m) {
        return this.m_queue.forceReserve(m);
    }

    @Override
    public void forcedSave() {
        this.m_queue.forcedSave();
    }

    @Override
    public Object getDequeueLock() {
        return this.m_queue;
    }

    @Override
    public int getMaxQueueSizeInKiloBytes() {
        return this.m_queue.getMaxQueueSizeInKiloBytes();
    }

    @Override
    public synchronized int getNonDelayableReceiverCount() {
        return this.m_nonDelayableReceiverCount;
    }

    @Override
    public long getMaxQueueSizeInBytes() {
        return this.m_queue.getMaxQueueSizeInBytes();
    }

    @Override
    public int getQueueType() {
        return 6;
    }

    @Override
    public int getReceiverCount() {
        return 0;
    }

    @Override
    public int getSaveThresholdInKiloBytes() {
        return this.m_queue.getSaveThresholdInKiloBytes();
    }

    @Override
    public int getTotalEnqueued() {
        return this.m_queue.getCurrentEnqueuedCount();
    }

    @Override
    public long getTotalSize() {
        return this.m_queue.getCurrentEnqueuedSize();
    }

    @Override
    protected long getOldestEnqueueTime() {
        return this.m_queue.getMinEnqueueTime();
    }

    @Override
    public boolean isReadExclusive() {
        return this.m_readExclusive;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public boolean isWriteExclusive() {
        return this.m_writeExclusive;
    }

    @Override
    public boolean isWriteOnly() {
        return this.m_writeOnly;
    }

    @Override
    public boolean isGlobal() {
        return this.m_global;
    }

    @Override
    public boolean isClustered() {
        return this.m_clustered;
    }

    @Override
    public boolean openBrowser(long clientId) throws ParseException, TokenMgrError {
        return this.m_queue.openBrowser(clientId, null);
    }

    @Override
    public boolean openBrowser(long clientId, String selector) throws ParseException, TokenMgrError {
        return this.m_queue.openBrowser(clientId, selector);
    }

    @Override
    public boolean openReceiver(long clientId) throws ParseException, TokenMgrError {
        return false;
    }

    @Override
    public boolean openReceiver(long clientId, String selector) throws ParseException, TokenMgrError {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(IMgram mgrm, long sender_cid) {
        this.enqueue(mgrm);
        Object object = this.m_dispatchLock;
        synchronized (object) {
            this.m_dispatchLock.notifyAll();
        }
    }

    @Override
    public boolean reserve(IMgram m) {
        return this.m_queue.reserve(m);
    }

    @Override
    public boolean reserve(int size) {
        return this.m_queue.reserve(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void restore(List elems) {
        Object[] obj1;
        int numElements = elems.size();
        Object[] obj = new Object[]{new Integer(elems.size()).toString(), this.getQueueName()};
        BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RESTORING_COUNT"), obj), 3);
        int count = this.m_queue.restore(elems);
        if (count < numElements) {
            obj1 = new Object[]{new Integer(numElements - count).toString(), this.getQueueName()};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("MESSAGES_EXPIRED"), obj1), 3);
        }
        obj1 = new Object[]{new Integer(count).toString(), this.getQueueName()};
        BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RESTORED_COUNT"), obj1), 3);
        Object object = this.m_dispatchLock;
        synchronized (object) {
            this.m_dispatchLock.notifyAll();
        }
        this.updateQueueStats();
    }

    @Override
    public void setFlowControl(boolean fc) {
    }

    @Override
    public void setGlobal(boolean global) {
        this.m_global = false;
    }

    @Override
    public void setClustered(boolean clustered) {
        this.m_clustered = false;
    }

    @Override
    public void setMaxQueueSizeInBytes(long max) {
        this.m_queue.setMaxQueueSizeInBytes(max);
    }

    @Override
    public void setMaxQueueSizeInKiloBytes(int max) {
        this.m_queue.setMaxQueueSizeInKiloBytes(max);
    }

    @Override
    public void setReadExclusiveMode(boolean mode) {
        this.m_readExclusive = mode;
    }

    @Override
    public void setReadOnlyMode(boolean mode) {
        this.m_readOnly = mode;
    }

    @Override
    public void setSaveThresholdInKiloBytes(int newSaveThreshold) {
        this.m_queue.setSaveThresholdInKiloBytes(newSaveThreshold);
    }

    @Override
    public void setWriteExclusiveMode(boolean mode) {
        this.m_writeExclusive = mode;
    }

    @Override
    public void setWriteOnlyMode(boolean mode) {
        this.m_writeOnly = mode;
    }

    @Override
    public synchronized void start() {
        if (!this.m_reg.getQueueProc().isStarted()) {
            String gl = this.isGlobal() ? prAccessor.getString("GLOBAL") : prAccessor.getString("LOCAL");
            String se = this.isReadExclusive() ? prAccessor.getString("EXCLUSIVE") : prAccessor.getString("SHARED");
            String cl = this.isClustered() ? prAccessor.getString("CLUSTERED") : prAccessor.getString("NONCLUSTERED");
            Object[] obj = new Object[]{this.getQueueName(), gl, cl, se, new Integer(this.getSaveThresholdInKiloBytes()).toString(), new Integer(this.getMaxQueueSizeInKiloBytes()).toString()};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("STARTING_QUEUE"), obj), 3);
        }
        this.dispatchStartup(this.m_reg.getQueueProc().getDispatcher());
        this.m_state = 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deliver(IMgram m, long clientId) throws EClientNotRegistered, ESecurityGeneralException {
        IClientContext cc = null;
        int sendStatus = 0;
        if (this.DEBUG) {
            this.debug("Message sent as " + (m.isGuarenteed() ? "guaranteed" : "reliable"));
        }
        cc = this.m_reg.getClient(clientId);
        if (this.DEBUG) {
            this.debug("Sending mgram: " + m + " to client " + clientId);
        }
        sendStatus = cc.send(m, this.m_emptyLabel, null);
        if (this.DEBUG) {
            String stat = null;
            switch (sendStatus) {
                case 1: {
                    stat = "REJECTED";
                    break;
                }
                case 2: {
                    stat = "DISCARDED";
                    break;
                }
                case 0: {
                    stat = "ACCEPTED";
                    break;
                }
                default: {
                    stat = "UNKNOWN";
                }
            }
            this.debug("IMgram sent to CID: " + clientId + ", status = " + stat);
        }
        if (sendStatus == 1) {
            boolean reenqueued = false;
            DelayedDeliveryQueue delayedDeliveryQueue = this.m_queue;
            synchronized (delayedDeliveryQueue) {
                this.m_queue.reenqueue(m, true);
                reenqueued = true;
                this.m_queue.notifyAll();
            }
            if (reenqueued) {
                this.updateQueueStats();
            }
            return false;
        }
        return true;
    }

    @Override
    public synchronized void decrementNonDelayableReceiverCount() {
        --this.m_nonDelayableReceiverCount;
    }

    @Override
    public synchronized void incrementNonDelayableReceiverCount() {
        ++this.m_nonDelayableReceiverCount;
    }

    private void initInstance(String qName, AgentRegistrar reg) {
        this.m_name = qName;
        this.m_address = "$Q." + this.m_name;
        this.m_reg = reg;
        this.m_emptyLabel = new Label();
        this.initMetrics();
    }

    @Override
    public long getPercentageFull() {
        return this.m_queue.getCurrentEnqueuedSize() * 100L / this.m_queue.getMaxQueueSizeInBytes();
    }
}

