/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.Broker;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.Config;
import progress.message.zclient.DebugThread;

public class ExpiredMessageCleaner
extends DebugThread {
    private final int m_pollingIntervalInSeconds;
    private final BrokerDatabase m_db;

    ExpiredMessageCleaner(BrokerDatabase m_db, int pollingIntervalInSeconds) {
        super("ExpiredMessageCleaner");
        this.m_db = m_db;
        this.m_pollingIntervalInSeconds = pollingIntervalInSeconds;
        this.start();
    }

    public static boolean isEnabled() {
        return Config.EXP_MSG_CLEAN_POLL_INTERVAL > 0;
    }

    @Override
    public void start() {
        if (ExpiredMessageCleaner.isEnabled()) {
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void threadMain() throws InterruptedException {
        if (this.DEBUG) {
            this.debug("Thread started. m_pollingInterval = " + this.m_pollingIntervalInSeconds + " secs,");
        }
        try {
            while (!Broker.exiting && !Broker.isInShutdown()) {
                if (this.DEBUG) {
                    this.debug("m_pollingInterval = " + this.m_pollingIntervalInSeconds + " (seconds),");
                }
                this.m_db.runCleaner();
                ExpiredMessageCleaner expiredMessageCleaner = this;
                synchronized (expiredMessageCleaner) {
                    this.wait(this.m_pollingIntervalInSeconds * 1000);
                }
            }
            return;
        }
        catch (InterruptedException ie) {
            if (Broker.exiting) return;
            throw ie;
        }
        finally {
            if (this.DEBUG) {
                this.debug("Thread exiting, broker exiting = " + Broker.exiting);
            }
        }
    }
}

