/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.Config;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.LogManager;
import progress.message.broker.MsgRestoreBeginEvt;
import progress.message.broker.MsgRestoreEndEvt;
import progress.message.broker.MsgRestorePos;
import progress.message.broker.MsgSaver;
import progress.message.broker.SyncMsgRestoreEvt;
import progress.message.client.EGeneralException;
import progress.message.db.EDatabaseException;
import progress.message.dbq.IQueryCancelCheck;
import progress.message.dbsc.data.IDbUndelData;
import progress.message.zclient.DebugObject;

public class MsgRestoreMgr
extends DebugObject {
    private HashMap m_currentRestorers = new HashMap();
    private HashMap m_recoveredEndRestores = new HashMap();
    private AgentRegistrar m_reg = AgentRegistrar.getAgentRegistrar();
    private LogManager m_logMgr = this.m_reg.getLogManager();
    private BrokerDatabase m_brokerDb = this.m_reg.getBrokerDatabase();
    private MsgSaver m_msgSaver = this.m_reg.getMsgSaver();

    public MsgRestoreMgr() {
        super("MsgRestoreMgr");
        if (this.checkDebugFlags(64)) {
            this.debug("Started ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginRestore(IClientContext cc, boolean remote, boolean SMO, boolean replicateOnly) {
        long cid = cc.getId();
        MsgRestoreBeginEvt evt = null;
        if (this.DEBUG) {
            this.debug("beginRestore cid= " + cid + " remote= " + remote + " SMO= " + SMO + " " + cc.getAppid());
        }
        HashMap hashMap = this.m_currentRestorers;
        synchronized (hashMap) {
            RestoreData rdat = (RestoreData)this.m_currentRestorers.get(new Long(cid));
            if (rdat != null && this.DEBUG) {
                this.debug("beginRestore: cid " + cid + " already exists; overwriting restore state ");
            }
            long id = this.m_logMgr.getSeqNo();
            int size = Config.GUAR_QUEUE.SIZE;
            rdat = new RestoreData(cid, id, remote, SMO, size);
            rdat.replicateOnly = true;
            evt = new MsgRestoreBeginEvt(cid, id, remote, SMO, size);
            evt.setReplicateOnly(replicateOnly);
            this.m_currentRestorers.put(new Long(cid), rdat);
        }
        if (evt != null) {
            this.m_logMgr.addEvent(evt, !evt.isReplicateOnly());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRestore(long clientId) {
        MsgRestoreEndEvt evt = null;
        RestoreData rdat = null;
        if (this.DEBUG) {
            this.debug("endRestore cid= " + clientId);
        }
        HashMap hashMap = this.m_currentRestorers;
        synchronized (hashMap) {
            rdat = (RestoreData)this.m_currentRestorers.get(new Long(clientId));
        }
        if (rdat != null) {
            evt = new MsgRestoreEndEvt(rdat.m_cid, rdat.m_rid);
            evt.setReplicateOnly(rdat.replicateOnly);
            this.m_logMgr.addEvent(evt, !rdat.replicateOnly);
            hashMap = this.m_currentRestorers;
            synchronized (hashMap) {
                this.m_currentRestorers.remove(new Long(clientId));
            }
        } else if (this.checkDebugFlags(64)) {
            this.debug("EndRestore; cid not found " + clientId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverRedeliveries(boolean recoveryFromLog) {
        HashMap hashMap = this.m_currentRestorers;
        synchronized (hashMap) {
            if (this.checkDebugFlags(64)) {
                this.debug("recoverRedeliveries: starting: m_recoveredEndRestores.size= " + this.m_recoveredEndRestores.size() + " m_currentRestorers.size= " + this.m_currentRestorers.size() + " recoveryFromLog= " + recoveryFromLog);
            }
            for (Long cidL : this.m_recoveredEndRestores.keySet()) {
                long rid;
                RestoreData rdat = (RestoreData)this.m_currentRestorers.get(cidL);
                if (rdat == null || (rid = ((Long)this.m_recoveredEndRestores.get(cidL)).longValue()) != rdat.m_rid) continue;
                this.m_currentRestorers.remove(cidL);
            }
            this.m_recoveredEndRestores.clear();
            if (this.checkDebugFlags(64)) {
                this.debug("recoverRedeliveries: applied recoveredEndRestores:  m_currentRestorers.size= " + this.m_currentRestorers.size());
            }
            for (RestoreData rdat : ((HashMap)this.m_currentRestorers.clone()).values()) {
                IClientContext cc = null;
                try {
                    cc = this.m_reg.getClient(rdat.m_cid);
                }
                catch (EClientNotRegistered ex) {
                    this.m_currentRestorers.remove(new Long(rdat.m_cid));
                    continue;
                }
                if (this.checkDebugFlags(64) && cc != null) {
                    this.debug("recoverRedeliveries: recovered " + rdat.m_cid + " state= " + cc.getState() + " " + cc.getAppid());
                }
                if (recoveryFromLog) {
                    this.setRedeliveries(rdat);
                    this.m_currentRestorers.remove(new Long(rdat.m_cid));
                    continue;
                }
                if (cc.isXOnce()) continue;
                this.setRedeliveries(rdat);
                this.m_currentRestorers.remove(new Long(rdat.m_cid));
            }
            if (this.checkDebugFlags(64)) {
                this.debug("recoverRedeliveries complete; m_currentRestorers.size= " + this.m_currentRestorers.size());
            }
        }
    }

    private void setRedeliveries(RestoreData rdat) {
        int restoreMsgsCt = Config.RESTORE_MSGS_COUNT;
        if (restoreMsgsCt == 0) {
            restoreMsgsCt = 400;
        }
        MsgRestorePos pos = new MsgRestorePos();
        MsgRestorePos rpos = new MsgRestorePos();
        long msgId = AgentRegistrar.getAgentRegistrar().getDeleteSubscriptionManager().getMaxDeleteMsgId(rdat.m_cid);
        if (msgId > -1L) {
            pos.update(msgId, pos.getSeqno());
            rpos.update(msgId, rpos.getSeqno());
        }
        try {
            List undelBatch = null;
            int totsize = 0;
            int ctRedelivered = 0;
            int ctProcessed = 0;
            boolean continueRestore = true;
            while (continueRestore) {
                undelBatch = rdat.m_SMO ? this.m_brokerDb.restoreMsgsForSMODurable(new IQueryCancelCheck(){

                    @Override
                    public boolean cancelQuery() {
                        return false;
                    }

                    @Override
                    public void beginDbWork() {
                    }

                    @Override
                    public void endDbWork() {
                    }
                }, rdat.m_cid, rdat.m_remote, pos, rpos, restoreMsgsCt, false, 0) : this.m_brokerDb.restoreMsgs(new IQueryCancelCheck(){

                    @Override
                    public boolean cancelQuery() {
                        return false;
                    }

                    @Override
                    public void beginDbWork() {
                    }

                    @Override
                    public void endDbWork() {
                    }
                }, rdat.m_cid, pos, restoreMsgsCt, false, 0);
                if (undelBatch == null) {
                    continueRestore = false;
                    break;
                }
                for (IDbUndelData undel : undelBatch) {
                    if (undel.getMessageSize() + totsize >= rdat.m_maxSizeInDoubt) {
                        continueRestore = false;
                        break;
                    }
                    ++ctProcessed;
                    totsize += undel.getMessageSize();
                    if (!undel.getRedelivery()) {
                        this.m_msgSaver.updateMsg(rdat.m_cid, undel.getMessageId(), undel.getMessageId(), null, true);
                        ++ctRedelivered;
                    }
                    if (rdat.m_SMO && undel.getFromRemoteBroker()) {
                        rpos.update(undel.getMessageId(), undel.getSequenceNumber());
                        continue;
                    }
                    pos.update(undel.getMessageId(), undel.getSequenceNumber());
                }
                if (undelBatch.size() >= restoreMsgsCt) continue;
                break;
            }
            if (this.checkDebugFlags(64)) {
                this.debug("recoverRedeliveries: cid= " + rdat.m_cid + " numProcessed= " + ctProcessed + " numRedelivered= " + ctRedelivered + " sizeProcessed= " + totsize);
            }
        }
        catch (EDatabaseException edbx) {
            edbx.printStackTrace();
        }
        catch (EGeneralException egx) {
            egx.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        catch (InterruptedIOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redoMsgRestoreBeginEvt(MsgRestoreBeginEvt evt) {
        if (this.DEBUG) {
            this.debug("redoMsgRestoreBeginEvt starting: cid= " + evt.getCid() + " rid= " + evt.getRestoreId());
        }
        HashMap hashMap = this.m_currentRestorers;
        synchronized (hashMap) {
            long cid = evt.getCid();
            RestoreData rdat = (RestoreData)this.m_currentRestorers.get(new Long(cid));
            if (rdat == null || evt.getRestoreId() > rdat.m_rid) {
                rdat = new RestoreData(evt.getCid(), evt.getRestoreId(), evt.getRemote(), evt.getSMO(), evt.getSize());
                this.m_currentRestorers.put(new Long(cid), rdat);
            } else {
                if (evt.getRestoreId() == rdat.m_rid) {
                    return;
                }
                this.debugData(cid, evt, rdat);
            }
        }
    }

    private void debugData(long cid, MsgRestoreBeginEvt evt, RestoreData rdat) {
        if (this.checkDebugFlags(64)) {
            this.debug("redoMsgRestoreBeginEvt: RestoreData exists for a newer rid: cid= " + cid + " rid= " + rdat.m_rid + " evt= " + evt.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redoMsgRestoreEndEvt(MsgRestoreEndEvt evt) {
        HashMap hashMap = this.m_currentRestorers;
        synchronized (hashMap) {
            long cid = evt.getCid();
            RestoreData rdat = (RestoreData)this.m_currentRestorers.get(new Long(cid));
            if (rdat == null) {
                this.m_recoveredEndRestores.put(new Long(cid), new Long(evt.getRestoreId()));
            } else {
                if (evt.getRestoreId() == rdat.m_rid) {
                    this.m_currentRestorers.remove(new Long(cid));
                    return;
                }
                if (this.checkDebugFlags(64)) {
                    this.debug("redoMsgRestoreSyncEvt: RestoreData exists for a different rid: cid= " + cid + " rid= " + rdat.m_rid + " evt= " + evt.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redoSyncMsgRestoreEvt(SyncMsgRestoreEvt evt) {
        HashMap hashMap = this.m_currentRestorers;
        synchronized (hashMap) {
            long cid = evt.getCid();
            RestoreData rdat = (RestoreData)this.m_currentRestorers.get(new Long(cid));
            if (rdat == null || evt.getRestoreId() > rdat.m_rid) {
                rdat = new RestoreData(evt.getCid(), evt.getRestoreId(), evt.getRemote(), evt.getSMO(), evt.getSize());
                this.m_currentRestorers.put(new Long(cid), rdat);
            } else {
                if (evt.getRestoreId() == rdat.m_rid) {
                    return;
                }
                if (this.checkDebugFlags(64)) {
                    this.debug("redoMsgRestoreSyncEvt: RestoreData exists for a newer rid: cid= " + cid + " rid= " + rdat.m_rid + " evt= " + evt.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSyncRecords() throws ECannotFlushEvents {
        HashMap currentRestores = null;
        HashMap hashMap = this.m_currentRestorers;
        synchronized (hashMap) {
            currentRestores = (HashMap)this.m_currentRestorers.clone();
        }
        Iterator it = currentRestores.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            RestoreData dat = (RestoreData)it.next();
            SyncMsgRestoreEvt evt = new SyncMsgRestoreEvt(dat.m_cid, dat.m_rid, dat.m_remote, dat.m_SMO, dat.m_maxSizeInDoubt);
            this.m_reg.getLogManager().tryAddEvent(evt, false);
            ++i;
        }
        if (this.checkDebugFlags(64)) {
            this.debug("writeSyncRecords: wrote " + i + " events");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRestoreState(long cid) {
        RestoreData rdat = null;
        HashMap hashMap = this.m_currentRestorers;
        synchronized (hashMap) {
            rdat = (RestoreData)this.m_currentRestorers.get(new Long(cid));
        }
        if (rdat == null) {
            return;
        }
        if (this.DEBUG) {
            this.debug("Clearing restore state " + cid);
        }
        this.setRedeliveries(rdat);
        this.endRestore(cid);
    }

    @Override
    public String toString() {
        return "MsgRestoreMgr";
    }

    public static final class RestoreData {
        private long m_cid;
        private long m_rid;
        private boolean m_remote;
        private boolean m_SMO;
        private int m_maxSizeInDoubt;
        private boolean replicateOnly;

        RestoreData(long cid, long rid, boolean remote, boolean SMO, int size) {
            this.m_cid = cid;
            this.m_rid = rid;
            this.m_remote = remote;
            this.m_SMO = SMO;
            this.m_maxSizeInDoubt = size;
        }
    }
}

