/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.HashSet;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.SyncQueueMsgGroupsEvt;
import progress.message.zclient.DebugObject;

final class OpenReceiverTable
extends DebugObject {
    private OpenReceiverEntry m_head;
    private OpenReceiverEntry m_tail;
    private OpenReceiverEntry m_current;

    public OpenReceiverTable() {
        this.debugName("OpenReceiverTable");
    }

    public OpenReceiverEntry removeReceiver(long id) {
        OpenReceiverEntry entry = this.locateEntryCorrespondingReceiver(id);
        if (entry == null) {
            return null;
        }
        if (entry.m_prev != null) {
            entry.m_prev.m_next = entry.m_next;
        }
        if (entry.m_next != null) {
            entry.m_next.m_prev = entry.m_prev;
        }
        if (this.m_head == entry) {
            this.m_head = entry.m_next;
        }
        if (this.m_tail == entry) {
            this.m_tail = entry.m_prev;
        }
        if (this.m_current == entry) {
            this.updatePointerForNextReceiver();
        }
        if (this.DEBUG) {
            this.dumpOpenReceiver("Dumping receivers after removing receiver " + id + "...");
        }
        return entry;
    }

    public boolean removeGroup(long id, String group) {
        OpenReceiverEntry entry = this.locateEntryCorrespondingReceiver(id);
        if (entry == null) {
            String err;
            try {
                IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(id);
                err = new String("Queue receiver not found, uid = " + cc.getUid() + ", appid = " + cc.getAppid());
            }
            catch (EClientNotRegistered ex) {
                err = new String("Queue receiver not found (not registered), id = " + id);
            }
            throw new AssertionError((Object)err);
        }
        return entry.m_table.remove(group);
    }

    private OpenReceiverEntry locateEntryCorrespondingReceiver(long id) {
        OpenReceiverEntry entry = this.m_head;
        while (entry != null && entry.m_uid != id) {
            entry = entry.m_next;
        }
        return entry;
    }

    public void addReceiver(long uid) {
        OpenReceiverEntry entry = new OpenReceiverEntry(uid);
        if (this.m_tail == null) {
            this.m_tail = this.m_current = entry;
            this.m_head = this.m_current;
        } else {
            this.m_tail.m_next = entry;
            entry.m_prev = this.m_tail;
            entry.m_next = null;
            this.m_tail = entry;
        }
        if (this.DEBUG) {
            this.dumpOpenReceiver("Dumping receivers after adding receiver " + uid + "...");
        }
    }

    public long nextReceiver(String group) {
        long ret = -1L;
        if (this.m_current != null) {
            ret = this.m_current.m_uid;
            this.m_current.m_table.add(group);
            this.updatePointerForNextReceiver();
        }
        if (this.DEBUG) {
            this.dumpOpenReceiver("Dumping receivers after assigning receiver " + ret + " to group " + group);
        }
        return ret;
    }

    private void updatePointerForNextReceiver() {
        this.m_current = this.m_current.m_next == null ? this.m_head : this.m_current.m_next;
    }

    public OpenReceiverEntry find(long id) {
        OpenReceiverEntry ret = null;
        OpenReceiverEntry next = this.m_head;
        while (next != null) {
            if (next.m_uid == id) {
                ret = next;
                break;
            }
            next = next.m_next;
        }
        return ret;
    }

    public void addGroupsToReceiver(long id, HashSet<String> groups) {
        OpenReceiverEntry entry = this.find(id);
        if (entry != null) {
            entry.m_table.addAll(groups);
        }
        if (this.DEBUG) {
            this.dumpOpenReceiver("Dumping receivers after adding groups to receiver " + id);
        }
    }

    public void writeSyncGroupAssignments(String queueName) throws ECannotFlushEvents {
        OpenReceiverEntry next = this.m_head;
        while (next != null) {
            long receiverId = next.m_uid;
            if (!next.m_table.isEmpty()) {
                SyncQueueMsgGroupsEvt evt = new SyncQueueMsgGroupsEvt(queueName, receiverId);
                for (String group : next.m_table) {
                    evt.addGroupName(group);
                }
                AgentRegistrar.getAgentRegistrar().getLogManager().tryAddEvent(evt, false);
            }
            next = next.m_next;
        }
    }

    private void dumpOpenReceiver(String title) {
        StringBuffer st = new StringBuffer(title + "\n");
        OpenReceiverEntry next = this.m_head;
        int index = 1;
        while (next != null) {
            st.append("Receiver[" + index + "]: id = " + next.m_uid + ", groups = {");
            for (String group : next.m_table) {
                st.append(" " + group + " ");
            }
            st.append("}");
            if (next == this.m_current) {
                st.append(" <- is the next group owner");
            }
            next = next.m_next;
            ++index;
        }
        st.append("\nEnd of dumping open receiver(s).\n");
        this.debug(st.toString());
    }

    class OpenReceiverEntry {
        long m_uid;
        HashSet<String> m_table;
        OpenReceiverEntry m_prev;
        OpenReceiverEntry m_next;

        OpenReceiverEntry(long uid) {
            this.m_uid = uid;
            this.m_table = new HashSet();
        }
    }
}

