/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.EBrokerTxnFailure;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.ETxnAborted;
import progress.message.broker.ETxnAccessViolation;
import progress.message.broker.ETxnNotFound;
import progress.message.broker.ETxnSequenceError;
import progress.message.client.EGeneralException;
import progress.message.client.EXAThereIsNoXidException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class PrepareGlobalTransaction
implements IMessageHandler {
    private AgentRegistrar m_reg;

    PrepareGlobalTransaction(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block13: {
            Message req = env.getMessage();
            Message rep = new Message();
            try {
                long clientId = AddrUtil.getIdFromAdmin(env.getSubject());
                Object xid = req.readObject();
                int tid = req.readInt();
                this.m_reg.getTransactionMgr().prepareTxn(tid, xid, clientId);
                rep.writeShort(0);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (ClassNotFoundException e) {
                rep.writeShort(1);
            }
            catch (EXAThereIsNoXidException e) {
                rep.writeShort(12);
            }
            catch (ETxnNotFound e) {
                rep.writeShort(2);
            }
            catch (ETxnSequenceError e) {
                rep.writeShort(3);
            }
            catch (ETxnAborted e) {
                rep.writeShort(4);
            }
            catch (ETxnAccessViolation e) {
                rep.writeShort(6);
            }
            catch (EInvalidAdminAddress e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            catch (EBrokerTxnFailure e) {
                rep.writeShort(1);
            }
            catch (IOException e) {
                rep.writeShort(1);
            }
            try {
                s.reply(rep, env);
            }
            catch (EGeneralException e) {
                if (Broker.isInShutdown()) break block13;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }
}

