/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.ETxnAborted;
import progress.message.broker.ETxnAccessViolation;
import progress.message.broker.ETxnNotFound;
import progress.message.broker.ETxnSequenceError;
import progress.message.client.EGeneralException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class PrepareTransaction
implements IMessageHandler {
    private AgentRegistrar m_reg;

    PrepareTransaction(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block11: {
            try {
                Message req = env.getMessage();
                Message rep = new Message();
                int uid = AddrUtil.getUidFromAdmin(env.getSubject());
                try {
                    this.m_reg.getTransactionMgr().prepare(req.readInt(), uid, req.readUTF());
                    rep.writeShort(0);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (ETxnNotFound e) {
                    rep.writeShort(2);
                }
                catch (ETxnSequenceError e) {
                    rep.writeShort(3);
                }
                catch (ETxnAborted e) {
                    rep.writeShort(4);
                }
                catch (ETxnAccessViolation e) {
                    rep.writeShort(6);
                }
                catch (EGeneralException e) {
                    rep.writeShort(5);
                }
                catch (IOException e) {
                    rep.writeShort(1);
                }
                s.reply(rep, env);
            }
            catch (EInvalidAdminAddress e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block11;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }
}

