/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import progress.message.broker.Config;
import progress.message.zclient.DebugObject;

public final class StatsMetrics
extends DebugObject {
    public static final int ENABLE_STATS_MISC = 1;
    public static final int ENABLE_STATS_SYSTEM = 2;
    public static final int ENABLE_STATS_LOG = 4;
    public static final int ENABLE_STATS_DATABASE = 8;
    public static final int ENABLE_STATS_PUBSUB = 16;
    public static final int ENABLE_STATS_PTP = 32;
    public static final int ENABLE_STATS_TRANSACTION = 64;
    public static final int ENABLE_STATS_FLOW_CONTROL = 128;
    public static final int ENABLE_STATS_ALL = 255;
    public static final int ENABLE_STATS_NONE = 0;
    public static final int FACILITY_MISC = 0;
    public static final int FACILITY_SYSTEM = 1;
    public static final int FACILITY_LOG = 2;
    public static final int FACILITY_DATABASE = 3;
    public static final int FACILITY_PUBSUB = 4;
    public static final int FACILITY_PTP = 5;
    public static final int FACILITY_TRANSACTION = 6;
    public static final int FACILITY_FLOW_CONTROL = 7;
    public static final int NUM_FACILITIES = 8;
    private static final String[] facilityConfigCodes = new String[]{"MISC", "SYSTEM", "LOG", "DATABASE", "PUBSUB", "PTP", "TRANSACTION", "FLOW_CONTROL"};
    private static final int[] facilityMasks = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    public static final List<String> facilityDisplayNames = Arrays.asList("MISC", "SYSTEM", "LOG", "DATABASE", "PUBSUB", "PTP", "TRANSACTION", "FLOW_CONTROL");
    private static int[] metricIds = new int[]{2, 8, 2, 0, 5, 6, 2, 0};
    private static int statsEnable;

    public static int getNewMetricIdForFacility(int facility) {
        int n = facility;
        metricIds[n] = metricIds[n] + 1;
        return metricIds[facility];
    }

    StatsMetrics() {
        super("StatsMetrics");
        StringTokenizer stz = new StringTokenizer(Config.METRICS_ENABLE, ",");
        statsEnable = 0;
        block0: while (stz.hasMoreTokens()) {
            String entry = stz.nextToken().toUpperCase();
            if (entry.equals("ALL")) {
                statsEnable = 255;
                this.debugEnablingStats(entry);
                break;
            }
            if (entry.equals("NONE")) {
                statsEnable = 0;
                this.debugEnablingStats(entry);
                break;
            }
            for (int i = 0; i < facilityConfigCodes.length; ++i) {
                if (!facilityConfigCodes[i].equals(entry)) continue;
                statsEnable |= facilityMasks[i];
                this.debugEnablingStats(entry);
                continue block0;
            }
        }
        if (this.DEBUG) {
            this.debug("StatsEnable= " + statsEnable);
        }
    }

    private void debugEnablingStats(String entry) {
        if (this.DEBUG) {
            this.debug("StatsMetrics: Enabling stats for " + entry);
        }
    }

    public static boolean areStatsEnabled(int facilityCode) {
        return (statsEnable & facilityMasks[facilityCode]) > 0;
    }

    public static String getFacilityName(int facility) {
        if (facility < facilityDisplayNames.size()) {
            return facilityDisplayNames.get(facility);
        }
        return null;
    }
}

