/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.broker.TempQueueData;
import progress.message.util.LongHashTable;
import progress.message.util.StreamUtil;

public class SyncTempQueueEvt
extends LogEvent {
    private LongHashTable<LinkedList<TempQueueData>> m_tempQueues = new LongHashTable();

    @Override
    public short type() {
        return 81;
    }

    @Override
    protected int memSizeBody() {
        int size = this.m_tempQueues.size() * 8;
        Enumeration<LinkedList<TempQueueData>> entries = this.m_tempQueues.elements();
        while (entries.hasMoreElements()) {
            LinkedList<TempQueueData> list = entries.nextElement();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                size += ((TempQueueData)iter.next()).size();
            }
        }
        return size;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        int size = 0;
        Enumeration<LinkedList<TempQueueData>> entries = this.m_tempQueues.elements();
        size += 4;
        while (entries.hasMoreElements()) {
            LinkedList<TempQueueData> list = entries.nextElement();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                size += ((TempQueueData)iter.next()).size();
            }
            size += 12;
        }
        return size;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        int size = this.m_tempQueues.size();
        StreamUtil.writeInt(size, os);
        Enumeration<Long> entries = this.m_tempQueues.keys();
        while (entries.hasMoreElements()) {
            Long cid = entries.nextElement();
            StreamUtil.writeLong((long)cid, os);
            LinkedList<TempQueueData> tq = this.m_tempQueues.get(cid);
            StreamUtil.writeInt(tq.size(), os);
            for (TempQueueData tqd : tq) {
                tqd.writeToStream(os);
            }
        }
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream is, boolean tteTTLConvert) throws IOException {
        int cidSize = StreamUtil.readInt(is);
        for (int cidCount = 0; cidCount < cidSize; ++cidCount) {
            long cid = StreamUtil.readLong(is);
            int tqdSize = StreamUtil.readInt(is);
            for (int tqdCount = 0; tqdCount < tqdSize; ++tqdCount) {
                TempQueueData tqd = new TempQueueData();
                tqd.readFromStream(is);
                this.addTempQueueData(cid, tqd);
            }
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoSyncTempQueueEvt(this);
    }

    @Override
    public String toString() {
        return super.toString() + "SyncTempQueueEvt";
    }

    public void addTempQueue(long cid, String queueName, int type, boolean isGlobal, int maxSize) {
        TempQueueData data = new TempQueueData(queueName, type, isGlobal, maxSize);
        this.addTempQueueData(cid, data);
    }

    private void addTempQueueData(long cid, TempQueueData tqd) {
        LinkedList<TempQueueData> queues = this.m_tempQueues.get(cid);
        if (queues == null) {
            queues = new LinkedList();
            this.m_tempQueues.put(cid, queues);
        }
        queues.add(tqd);
    }

    public Enumeration getCIDs() {
        return this.m_tempQueues.keys();
    }

    public LinkedList getTempQueueData(long cid) {
        return this.m_tempQueues.get(cid);
    }
}

