/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

class TxnCommitEvt
extends LogEvent {
    private int m_tid;
    private long m_requestId;
    private boolean m_chained;
    private short m_type = (short)83;

    TxnCommitEvt(int tid, long requestId, boolean chained) {
        this.m_tid = tid;
        this.m_requestId = requestId;
        this.m_chained = chained;
    }

    TxnCommitEvt(short typ) {
        this.m_type = typ;
    }

    int getTid() {
        return this.m_tid;
    }

    long getRequestId() {
        return this.m_requestId;
    }

    boolean getChained() {
        return this.m_chained;
    }

    @Override
    public short type() {
        return 83;
    }

    @Override
    protected int memSizeBody() {
        return 13;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        return 13;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        StreamUtil.writeInt(this.m_tid, out);
        StreamUtil.writeLong(this.m_requestId, out);
        StreamUtil.writeBoolean(this.m_chained, out);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        StreamUtil.writeInt(this.m_tid, os);
        StreamUtil.writeLong(this.m_requestId, os);
        StreamUtil.writeBoolean(this.m_chained, os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_tid = StreamUtil.readInt(in);
        if (this.m_type == 83 || this.m_type == 98) {
            this.m_requestId = StreamUtil.readLong(in);
            this.m_chained = StreamUtil.readBoolean(in);
        } else {
            this.m_requestId = 0L;
            this.m_chained = false;
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoTxnCommit(this);
    }

    @Override
    public String toString() {
        return super.toString() + "Txn " + this.m_tid + ", requestId " + this.m_requestId + ", chained " + this.m_chained + ": commit";
    }
}

