/*
 * Decompiled with CFR 0.152.
 */
package progress.message.db.pse.util;

import com.odi.Session;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import progress.message.db.pse.IRWXLock;
import progress.message.db.pse.util.DbCounter;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.DebugThread;
import progress.message.zclient.SessionConfig;

public class DbMetrics
extends DebugObject {
    private static String[] m_storageMetrics = new String[]{"allocateCount     ", "deletedBytes      ", "deletedCount      ", "readBytes         ", "readCount         ", "writeBytes        ", "writeCount        ", "transactionCount  ", "logPagesRead      ", "logPagesWrite     ", "masterLogPageRead ", "masterLogPageWrite", "logFileSync       ", "dataPagesWrite    ", "dataPagesRead     ", "masterPageWrite   ", "masterPageRead    ", "dataFileSync      "};
    private Vector m_dbCounters;
    private String m_dbName;
    private String m_dbShortName;
    private long m_start;
    private int m_counter = -1;
    private int m_maxctr;
    private Session m_session;
    private IRWXLock m_lck;
    private boolean m_terminate;
    private long m_intervalSecs;
    private Thread m_metricsThread;
    private Object m_metricsThreadLockObj = new Object();

    public DbMetrics(String dbname, String dbShortname, int counter) {
        super(DebugState.GLOBAL_DEBUG_ON ? "DbMetrics " + dbShortname : null);
        this.m_dbCounters = new Vector();
        this.m_dbName = dbname;
        this.m_dbShortName = dbShortname;
        if (this.DEBUG) {
            this.debug("dbShortname= " + dbShortname + " counter= " + counter);
        }
        this.countersAddStorageMetrics(dbname);
        this.m_maxctr = counter;
    }

    public DbMetrics(String dbname, String dbShortname, long intervalsecs) {
        super(DebugState.GLOBAL_DEBUG_ON ? "DbMetrics " + dbShortname : null);
        this.m_dbCounters = new Vector();
        this.m_dbName = dbname;
        this.m_dbShortName = dbShortname;
        if (this.DEBUG) {
            this.debug("dbShortname= " + dbShortname + " intervalSecs= " + intervalsecs);
        }
        this.countersAddStorageMetrics(dbname);
        this.m_intervalSecs = intervalsecs;
    }

    private void countersAddStorageMetrics(String dbname) {
        for (int i = 0; i < m_storageMetrics.length; ++i) {
            String nameInDb = dbname + "." + m_storageMetrics[i].trim() + "_statistics";
            this.m_dbCounters.addElement(new DbCounter(nameInDb, m_storageMetrics[i]));
            if (!this.DEBUG) continue;
            this.debug("Added metric " + nameInDb);
        }
        this.m_start = System.currentTimeMillis();
    }

    public void init(Session sess, IRWXLock lck) {
        this.m_session = sess;
        this.m_lck = lck;
        this.m_metricsThread = new MetricsThread();
        this.m_metricsThread.setDaemon(true);
        this.m_metricsThread.start();
        if (this.DEBUG) {
            this.debug("MetricsThread started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.m_terminate = true;
        if (this.m_metricsThread != null && this.m_metricsThread.isAlive()) {
            Object object = this.m_metricsThreadLockObj;
            synchronized (object) {
                this.m_metricsThreadLockObj.notifyAll();
            }
        }
    }

    public boolean outputMetrics(Session sess, String header) {
        DbCounter ctr;
        Properties props = sess.getCounters(false);
        Iterator it = this.m_dbCounters.iterator();
        long sum = 0L;
        while (it.hasNext()) {
            ctr = (DbCounter)it.next();
            ctr.calcNextValue(props);
            sum += ctr.getValue();
        }
        if (sum == 0L) {
            return false;
        }
        it = this.m_dbCounters.iterator();
        SessionConfig.logMessage(header, SessionConfig.getLevelInfo());
        while (it.hasNext()) {
            ctr = (DbCounter)it.next();
            StringBuffer strbuf = new StringBuffer(this.m_dbShortName);
            strbuf.append(": ");
            strbuf.append(ctr.getName());
            strbuf.append(" ");
            strbuf.append(ctr.getValue());
            SessionConfig.logMessage(strbuf.toString(), SessionConfig.getLevelInfo());
        }
        return true;
    }

    public void updatectr(Session sess) {
        ++this.m_counter;
        if (this.m_counter % this.m_maxctr == 0) {
            long t = (System.currentTimeMillis() - this.m_start + 500L) / 1000L;
            String header = this.m_dbShortName + ": secs= " + t + " counter= " + this.m_counter;
            this.outputMetrics(sess, header);
            this.m_start = System.currentTimeMillis();
        }
    }

    public class MetricsThread
    extends DebugThread {
        MetricsThread() {
            super("MetricsThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadMain() {
            long msecs = DbMetrics.this.m_intervalSecs * 1000L;
            int nodata = 0;
            if (this.DEBUG) {
                this.debug("starting; interval= " + msecs);
            }
            try {
                DbMetrics.this.m_session.join();
                while (!DbMetrics.this.m_terminate) {
                    Object header;
                    DbMetrics.this.m_lck.acquireReadLock();
                    try {
                        header = DbMetrics.this.m_dbShortName + ": Stats for last interval; secs= " + DbMetrics.this.m_intervalSecs + " nodata= " + nodata;
                        boolean hasData = DbMetrics.this.outputMetrics(DbMetrics.this.m_session, (String)header);
                        nodata = hasData ? 0 : ++nodata;
                    }
                    finally {
                        DbMetrics.this.m_lck.releaseReadLock();
                    }
                    try {
                        header = DbMetrics.this.m_metricsThreadLockObj;
                        synchronized (header) {
                            DbMetrics.this.m_metricsThreadLockObj.wait(msecs);
                        }
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
            }
            finally {
                DbMetrics.this.m_session;
                Session.leave();
            }
            if (this.DEBUG) {
                this.debug("Exited ");
            }
        }
    }
}

