/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse;

import com.odi.Database;
import com.odi.Session;
import progress.message.broker.BrokerStatus;
import progress.message.dbsc.pse.ILog;
import progress.message.dbsc.pse.pc.reg.PSEBrokerState;
import progress.message.dbsc.pse.pc.reg.PSESyncPoint;
import progress.message.util.EAssertFailure;

public class DbSchemaCheckReg {
    Database m_db;
    ILog m_logger;

    public DbSchemaCheckReg(Database db, ILog log) {
        this.m_db = db;
        this.m_logger = log;
    }

    public void checkDb() {
        Session sess = Session.getCurrent();
        if (sess == null) {
            throw new EAssertFailure("No current Session");
        }
        if (!sess.inTransaction()) {
            throw new EAssertFailure("No current Transaction");
        }
        this.m_logger.logln("\nChecking Reg Schema...");
        this.dumpRegInfo();
        this.m_logger.logln("\nCompleted Checking Reg Schema.");
    }

    private void dumpRegInfo() {
        PSESyncPoint sp = (PSESyncPoint)this.m_db.getRoot("SyncPoint");
        if (sp != null) {
            short fileNumber = (short)sp.getFileNumber();
            long position = sp.getPos();
            this.m_logger.logln("SyncpointLoc: fileNumber= " + fileNumber + " position= " + position);
        } else {
            this.m_logger.logln("PSESyncpoint does not exist in Db");
        }
        this.m_logger.logln("\n");
        int state = 0;
        PSEBrokerState bstate = (PSEBrokerState)this.m_db.getRoot("BrokerState");
        if (bstate != null) {
            state = bstate.getLastBrokerState();
            this.m_logger.logln("BrokerLastKnownState= " + BrokerStatus.State.get(state));
        } else {
            this.m_logger.logln("PSEBrokerState does not exist in Db");
        }
    }
}

