/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.EOFException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ClientAckEvt;
import progress.message.broker.ClientContextMgramQueue;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.IProxyingHandle;
import progress.message.broker.MsgSaver;
import progress.message.client.EGeneralException;
import progress.message.client.EInterrupted;
import progress.message.client.ENetworkFailure;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.InterbrokerConfig;
import progress.message.interbroker.InterbrokerSession;
import progress.message.interbroker.Neighbor;
import progress.message.util.ArrayUtil;
import progress.message.util.DebugState;
import progress.message.util.ISizedEnumeration;
import progress.message.util.LongHashTable;
import progress.message.zclient.Connection;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.FastVector;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Session;
import progress.message.zclient.Solicitation;

final class GuarAckExchanger
extends DebugObject {
    private static final int MAX_ACKS_PER_MSG = 2000;
    private static final String REQ_SUBJ = InterbrokerConfig.addPrefix("ACK_EXCHANGE");
    private static final int TYPE_PUBSUB = 1;
    private static final int TYPE_QUEUE = 2;
    private static final byte SUBTYPE_PUB_SUB_TARGETED = 1;
    private static final byte SUBTYPE_PUB_SUB_MIXED = 2;
    private static final byte SUBTYPE_PUB_SUB_UNTARGETED = 4;
    private long m_localId;
    private long m_remoteId;
    private long m_token;
    private Neighbor m_neighbor;
    private Connection m_con;
    private Session m_ssn;
    private MessageHandler m_reqMH;
    private MessageHandler m_repMH;
    private boolean m_isClient;
    private boolean m_localReqDone;
    private boolean m_remoteReqDone;
    private Solicitation m_localReq;
    private Envelope m_remoteReq;
    private EGeneralException m_err;
    private boolean m_repHandlerRunning;
    private boolean m_reqHandlerRunning;
    private boolean m_connDropped;
    private boolean DEBUG1;

    GuarAckExchanger(Session ssn, long localId, long remoteId, long token, boolean localIsClient) throws EGeneralException {
        super(DebugState.GLOBAL_DEBUG_ON ? "GuarAckExchanger " + Interbroker.getInterbroker().getNeighborByID(remoteId) : null);
        boolean bl = this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        if (this.DEBUG1) {
            this.debug("Constructor: localId= " + localId + " remoteId= " + remoteId + " localIsClient= " + localIsClient);
        }
        try {
            this.m_localId = localId;
            this.m_remoteId = remoteId;
            this.m_token = token;
            this.m_isClient = localIsClient;
            this.m_ssn = ssn;
            this.m_con = ssn.getConnection();
            this.m_neighbor = Interbroker.getInterbroker().getNeighborByID(this.m_remoteId);
            if (this.DEBUG) {
                this.debug("m_neighbor = " + this.m_neighbor);
            }
            this.m_reqMH = new MessageHandler(new IMessageHandler(){

                @Override
                public void handleMessage(Session s, Envelope env) {
                    try {
                        GuarAckExchanger.this.handleRequest(env);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
            this.m_reqMH.setName("IB GuarAck request handler");
            this.m_reqMH.bind(REQ_SUBJ);
            this.m_con.addMessageHandler(this.m_reqMH);
            this.m_repMH = new MessageHandler(new IMessageHandler(){

                @Override
                public void handleMessage(Session s, Envelope env) {
                    try {
                        GuarAckExchanger.this.handleReply(env);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
            this.m_repMH.setName("IB GuarAck reply handler");
            this.m_con.addMessageHandler(this.m_repMH);
        }
        catch (EGeneralException e) {
            this.m_remoteReqDone = true;
            this.m_localReqDone = true;
            this.m_err = e;
            throw e;
        }
        if (this.DEBUG) {
            this.debug("Created GuarAckExchanger");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void doExchange() throws EGeneralException {
        GuarAckExchanger guarAckExchanger = this;
        synchronized (guarAckExchanger) {
            try {
                if (this.DEBUG) {
                    this.debug("doExchange: starting exchange");
                }
                if (this.m_isClient) {
                    this.sendClientSolicit();
                }
                if (this.DEBUG) {
                    this.debug("doExchange: waiting for exchange");
                }
                while (!(this.m_localReqDone && this.m_remoteReqDone || this.m_connDropped)) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new EInterrupted();
                    }
                }
            }
            catch (EGeneralException e) {
                this.m_err = e;
            }
        }
        this.cleanUp();
        if (this.m_err != null) {
            throw this.m_err;
        }
    }

    void cleanUp() {
        if (this.DEBUG) {
            this.debug("cleaning up");
        }
        if (this.m_localReq != null) {
            this.m_localReq.cancel();
        }
        try {
            if (this.m_reqMH != null) {
                this.m_con.removeMessageHandler(this.m_reqMH);
            }
        }
        catch (EGeneralException eGeneralException) {
            // empty catch block
        }
        try {
            if (this.m_repMH != null) {
                this.m_con.removeMessageHandler(this.m_repMH);
            }
        }
        catch (EGeneralException eGeneralException) {
            // empty catch block
        }
    }

    synchronized void notifyConnDropped() {
        this.m_connDropped = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() {
        GuarAckExchanger guarAckExchanger = this;
        synchronized (guarAckExchanger) {
            if (this.DEBUG) {
                this.debug("aborting");
            }
            boolean interrupted = false;
            while (this.m_reqHandlerRunning || this.m_repHandlerRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            this.m_remoteReqDone = true;
            this.m_localReqDone = true;
            this.notifyAll();
        }
        this.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRequest(Envelope env) throws InterruptedException {
        GuarAckExchanger guarAckExchanger = this;
        synchronized (guarAckExchanger) {
            this.m_reqHandlerRunning = true;
        }
        try {
            Message m = env.getMessage();
            byte[] body = m.getBody();
            long remoteId = ArrayUtil.readLong(body, 0);
            if (remoteId != this.m_remoteId || ArrayUtil.readLong(body, 8) != this.m_token) {
                if (this.DEBUG1) {
                    this.debug("handleRequest: discarding remote request for Id " + remoteId + "; Expecting " + this.m_remoteId);
                }
                return;
            }
            Vector xOnceTrackNums = this.retrieveXOnceTrackNums(env);
            int numAcks = xOnceTrackNums.size();
            ISizedEnumeration enumXOnceQMsgs = this.m_neighbor.getXOnceQMsgTrackNums();
            int numqAcks = enumXOnceQMsgs.size();
            Enumeration enu = xOnceTrackNums.elements();
            LongHashTable redirectAckTable = this.m_neighbor.getXOnceRedirectTrkNums();
            ISizedEnumeration<Long> redirectAcks = redirectAckTable.keyList();
            int numRedirectAcks = this.getNumRedirectAcks(numAcks, redirectAcks);
            this.debugData(numAcks, numRedirectAcks, numqAcks);
            do {
                int numInMsg = Math.min(numAcks + numRedirectAcks, 2000);
                boolean more = this.isMore(numAcks, numInMsg, numRedirectAcks, numqAcks);
                Message rep = this.getRep(more);
                if (numAcks >= numInMsg) {
                    numAcks = this.getNumAcks(enu, more, numAcks, numInMsg, rep);
                } else if (numAcks > 0 && numRedirectAcks > 0) {
                    rep.writeByte(2);
                    this.writeData(enu, numAcks, numInMsg, redirectAckTable, redirectAcks, rep);
                    numRedirectAcks = this.getNumRedirectAcks(more, numAcks, numInMsg, numRedirectAcks);
                    numAcks = 0;
                } else if (numRedirectAcks > 0) {
                    rep.writeByte(1);
                    this.writeData(more, numInMsg, redirectAckTable, redirectAcks, rep);
                    numRedirectAcks -= numInMsg;
                }
                this.m_ssn.reply(rep, env);
            } while (numAcks > 0 || numRedirectAcks > 0);
            this.debugData(numqAcks);
            this.retrieveNumqAcks(enumXOnceQMsgs, env, numqAcks);
        }
        catch (IOException e) {
            this.logMessage(e);
        }
        finally {
            GuarAckExchanger guarAckExchanger2 = this;
            synchronized (guarAckExchanger2) {
                this.m_reqHandlerRunning = false;
                this.notifyAll();
            }
        }
    }

    private void retrieveNumqAcks(ISizedEnumeration enumXOnceQMsgs, Envelope env, int numqAcksParam) throws EGeneralException {
        int numqAcks = numqAcksParam;
        while (numqAcks > 0) {
            int numInMsg = Math.min(numqAcks, 2000);
            numqAcks = this.getNumqAcks(enumXOnceQMsgs, env, numInMsg, numqAcks);
        }
        if (this.DEBUG) {
            this.debug("handleRequest: all Qacks sent");
        }
    }

    private Vector retrieveXOnceTrackNums(Envelope env) throws InterruptedException, EGeneralException {
        if (this.DEBUG) {
            this.debug("got remote request");
        }
        Vector xOnceTrackNums = this.getXOnceTrackNums(env);
        return xOnceTrackNums;
    }

    private int getNumqAcks(ISizedEnumeration enumXOnceQMsgs, Envelope env, int numInMsg, int numqAcksParam) throws EGeneralException {
        int numqAcks = numqAcksParam;
        boolean more = numInMsg < numqAcks;
        Message rep = new Message();
        rep.writeBoolean(false);
        rep.writeBoolean(more);
        rep.writeByte(2);
        for (int i = 0; i < numInMsg; ++i) {
            rep.writeLong((Long)enumXOnceQMsgs.nextElement());
        }
        this.m_ssn.reply(rep, env);
        numqAcks -= numInMsg;
        if (this.DEBUG) {
            this.debug("handleRequest: sending replies: sent 1 queue reply; acks in msg= " + numInMsg + " more= " + more);
        }
        return numqAcks;
    }

    private void debugData(int numAcks, int numRedirectAcks, int numqAcks) {
        if (this.DEBUG) {
            this.debug("Initiating in doubt resolution, numAcks=" + numAcks + ", redirectAcks=" + numRedirectAcks + " numQAcks=" + numqAcks);
        }
    }

    private void writeData(boolean more, int numInMsg, LongHashTable redirectAckTable, ISizedEnumeration redirectAcks, Message rep) {
        for (int i = 0; i < numInMsg; ++i) {
            try {
                Long backTrackingLong = (Long)redirectAcks.nextElement();
                long backTracking = backTrackingLong;
                rep.writeLong(backTracking);
                ISizedEnumeration trackers = ((LongHashTable)redirectAckTable.get(backTracking)).elementList();
                rep.writeInt(trackers.size());
                while (trackers.hasMoreElements()) {
                    rep.writeLong(((AgentGuarMsgTracker)trackers.nextElement()).getRedirectAckClient());
                }
                continue;
            }
            catch (NoSuchElementException nsee) {
                BrokerComponent.getComponentContext().logMessage((Throwable)nsee, 2);
                break;
            }
        }
        if (this.DEBUG) {
            this.debug("handleRequest: sending replies: sent 1 pub/sub reply; numRedirectAcks=" + numInMsg + ", more= " + more);
        }
    }

    private void writeData(Enumeration enu, int numAcks, int numInMsg, LongHashTable redirectAckTable, ISizedEnumeration redirectAcks, Message rep) {
        rep.writeInt(numAcks);
        while (enu.hasMoreElements()) {
            rep.writeLong((Long)enu.nextElement());
        }
        for (int i = numAcks; i < numInMsg; ++i) {
            try {
                Long backTrackingLong = (Long)redirectAcks.nextElement();
                long backTracking = backTrackingLong;
                rep.writeLong(backTracking);
                ISizedEnumeration trackers = ((LongHashTable)redirectAckTable.get(backTracking)).elementList();
                rep.writeInt(trackers.size());
                while (trackers.hasMoreElements()) {
                    rep.writeLong(((AgentGuarMsgTracker)trackers.nextElement()).getRedirectAckClient());
                }
                continue;
            }
            catch (NoSuchElementException nsee) {
                BrokerComponent.getComponentContext().logMessage((Throwable)nsee, 2);
                break;
            }
        }
    }

    private Message getRep(boolean more) {
        Message rep = new Message();
        rep.writeBoolean(false);
        rep.writeBoolean(more);
        rep.writeByte(1);
        return rep;
    }

    private int getNumAcks(Enumeration enu, boolean more, int numAcksParam, int numInMsg, Message rep) {
        int numAcks = numAcksParam;
        rep.writeByte(4);
        for (int i = 0; i < numInMsg; ++i) {
            rep.writeLong((Long)enu.nextElement());
        }
        numAcks -= numInMsg;
        if (this.DEBUG) {
            this.debug("handleRequest: sending replies: sent 1 pub/sub reply; acks in msg= " + numInMsg + " more= " + more);
        }
        return numAcks;
    }

    private int getNumRedirectAcks(boolean more, int numAcks, int numInMsg, int numRedirectAcksParam) {
        int numRedirectAcks = numRedirectAcksParam;
        if (this.DEBUG) {
            this.debug("handleRequest: sending replies: sent 1 pub/sub reply; acks in msg= " + numAcks + ", numRedirectAcks=" + (numInMsg - numAcks) + ", more= " + more);
        }
        return numRedirectAcks -= numInMsg - numAcks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getXOnceTrackNums(Envelope env) throws InterruptedException, EGeneralException {
        GuarAckExchanger guarAckExchanger = this;
        synchronized (guarAckExchanger) {
            this.m_remoteReq = env;
            this.notifyAll();
        }
        if (!this.m_isClient) {
            this.sendBrokerSolicit();
        }
        AgentRegistrar.getAgentRegistrar().getLogManager().flush();
        if (this.DEBUG) {
            this.debug("sending replies");
        }
        Vector xOnceTrackNums = this.m_neighbor.getXOnceMsgTrackNums();
        return xOnceTrackNums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessage(IOException e) {
        if (this.DEBUG) {
            this.debug("Exception in request handler, aborting: " + e);
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        GuarAckExchanger guarAckExchanger = this;
        synchronized (guarAckExchanger) {
            this.m_reqHandlerRunning = this.logMessageCreateFailureError(e);
        }
        this.abort();
    }

    private void debugData(int numqAcks) {
        if (this.DEBUG) {
            this.debug("handleRequest: all pubsub acks sent");
        }
        if (this.DEBUG) {
            this.debug("handleRequest: sending replies: numqAcks to send= " + numqAcks);
        }
    }

    private boolean isMore(int numAcks, int numInMsg, int numRedirectAcks, int numqAcks) {
        boolean more;
        boolean bl = more = numInMsg < numAcks + numRedirectAcks;
        if (numqAcks > 0) {
            more = true;
        }
        return more;
    }

    private int getNumRedirectAcks(int numAcks, ISizedEnumeration redirectAcks) {
        int numRedirectAcks = redirectAcks.size();
        if (this.DEBUG) {
            this.debug("handleRequest: sending replies: numAcks to send= " + numAcks);
        }
        return numRedirectAcks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleReply(Envelope env) throws InterruptedException {
        GuarAckExchanger guarAckExchanger = this;
        synchronized (guarAckExchanger) {
            this.m_repHandlerRunning = true;
        }
        try {
            Message m = env.getMessage();
            if (m.readBoolean()) {
                this.acksAndCancel();
            } else {
                MsgSaver deleter = this.getDeleter();
                boolean more = m.readBoolean();
                byte type = m.readByte();
                int ctp = 0;
                int ctq = 0;
                switch (type) {
                    case 1: {
                        try {
                            byte subType = m.readByte();
                            int numUntargeted = Integer.MAX_VALUE;
                            switch (subType) {
                                case 2: {
                                    numUntargeted = m.readInt();
                                }
                                case 4: {
                                    IClientContext cc = this.getCc();
                                    for (int i = 0; i < numUntargeted; ++i) {
                                        long tracking = m.readLong();
                                        FastVector proxied = this.getProxied(cc, tracking);
                                        ClientContextMgramQueue.InDoubtXOGroupSend idgs = null;
                                        if (cc != null) {
                                            proxied = cc.getProxyHandle().getProxyRecips(tracking);
                                            cc.removeLBSWrapperInfo(tracking);
                                            idgs = cc.removeInDoubtXOnceGroupSend(tracking);
                                            if (idgs != null) {
                                                tracking = idgs.gma.msgTracking;
                                            }
                                        }
                                        this.removeProxyTrackingAndDelete(cc, deleter, proxied, tracking);
                                        ClientAckEvt evt = this.getEvt(cc, idgs, proxied, tracking);
                                        ctp = this.getCtp(ctp, deleter, evt, idgs, tracking);
                                    }
                                }
                                case 1: {
                                    block31: while (true) {
                                        long tracking = m.readLong();
                                        long numClients = m.readInt();
                                        int i = 0;
                                        while (true) {
                                            if ((long)i >= numClients) continue block31;
                                            long clientID = this.getClientID(m, tracking);
                                            ClientAckEvt evt = new ClientAckEvt(clientID, tracking, null, true);
                                            ctp = this.getCtp(clientID, ctp, deleter, evt, tracking);
                                            ++i;
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                        catch (EOFException subType) {}
                        break;
                    }
                    case 2: {
                        try {
                            while (true) {
                                long tracking = m.readLong();
                                this.m_neighbor.inDoubtQMsgAcknowledged(tracking);
                                ++ctq;
                            }
                        }
                        catch (EOFException tracking) {
                            // empty catch block
                        }
                    }
                }
                this.debugData(ctp, ctq);
                if (!more) {
                    if (this.DEBUG) {
                        this.debug("handleReply: no more (nonfinal) replies");
                    }
                    this.debugAndFlush(deleter);
                    Message rep = this.getRep();
                    this.m_ssn.reply(rep, this.m_remoteReq);
                    this.cancelAndNotify();
                }
            }
        }
        catch (IOException e) {
            this.logIOException(e);
        }
        finally {
            GuarAckExchanger guarAckExchanger2 = this;
            synchronized (guarAckExchanger2) {
                this.m_repHandlerRunning = false;
                this.notifyAll();
            }
        }
    }

    private int getCtp(long clientID, int ctpParam, MsgSaver deleter, ClientAckEvt evt, long tracking) throws InterruptedException {
        int ctp = ctpParam;
        AgentRegistrar.getAgentRegistrar().getLogManager().addEvent(evt, true);
        try {
            IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(clientID);
            cc.getGuarDoubtManager().msgAcknowledged(tracking, true);
            GuarAckExchanger.proxyingRemoveTracking(cc, tracking);
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
        deleter.deleteMsgFlushPostponedSaves(clientID, tracking, -1, true);
        return ++ctp;
    }

    private int getCtp(int ctpParam, MsgSaver deleter, ClientAckEvt evt, ClientContextMgramQueue.InDoubtXOGroupSend idgs, long tracking) throws InterruptedException {
        int ctp = ctpParam;
        AgentRegistrar.getAgentRegistrar().getLogManager().addEvent(evt, true);
        if (idgs == null) {
            deleter.deleteMsgFlushPostponedSaves(this.m_remoteId, tracking, -1, true);
        } else {
            deleter.deleteMsgFlushPostponedSaves(idgs.groupcc.getId(), tracking, -1, true);
        }
        return ++ctp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message getRep() throws EInterrupted, InterruptedException {
        Object ph;
        if (this.m_neighbor.getClient() != null) {
            ph = this.m_neighbor.getClient().getProxyHandle();
            if (this.DEBUG) {
                this.debug("handleReply: IProxyHandle ph = " + ph);
            }
            if (ph != null) {
                ph.proxyDoubtResolved(false);
            }
        }
        AgentRegistrar.getAgentRegistrar().getLogManager().flush();
        this.m_neighbor.allInDoubtQAcksReceived();
        ph = this;
        synchronized (ph) {
            while (this.m_remoteReq == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new EInterrupted();
                }
            }
        }
        if (this.DEBUG) {
            this.debug("handleReply: sending our final reply; completed processing of acks");
        }
        Message rep = new Message();
        rep.writeBoolean(true);
        return rep;
    }

    private ClientAckEvt getEvt(IClientContext cc, ClientContextMgramQueue.InDoubtXOGroupSend idgs, FastVector proxied, long tracking) {
        if (cc != null) {
            if (idgs == null) {
                cc.getGuarDoubtManager().msgAcknowledged(tracking, true);
            } else {
                idgs.groupcc.getGuarDoubtManager().msgAcknowledged(tracking, true);
            }
        }
        ClientAckEvt evt = null;
        if (idgs == null) {
            evt = new ClientAckEvt(this.m_remoteId, tracking, null, proxied != null, true);
        } else {
            evt = new ClientAckEvt(idgs.groupcc.getId(), tracking, null, proxied != null, true);
            evt.setNotifyDelete(true);
        }
        return evt;
    }

    private void removeProxyTrackingAndDelete(IClientContext cc, MsgSaver deleter, FastVector proxied, long tracking) throws InterruptedException {
        if (proxied != null) {
            for (int p = 0; p < proxied.m_count; ++p) {
                IClientContext proxiedCC = (IClientContext)proxied.m_data[p];
                if (this.DEBUG) {
                    this.debug("Deleting proxied gax GUAR=" + tracking + " CLIENT=" + proxiedCC.getId());
                }
                proxiedCC.getGuarDoubtManager().msgAcknowledged(tracking, true);
                GuarAckExchanger.proxyingRemoveTracking(cc, tracking);
                deleter.deleteMsgFlushPostponedSaves(proxiedCC.getId(), tracking, -1, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acksAndCancel() {
        if (this.DEBUG) {
            this.debug("handleReply: got final reply; remote has completed processing our acks");
        }
        this.m_neighbor.allXOnceAcksDone();
        this.m_neighbor.allXOnceQAcksDone();
        GuarAckExchanger guarAckExchanger = this;
        synchronized (guarAckExchanger) {
            if (this.m_localReqDone) {
                this.m_localReq.cancel();
            }
            this.m_remoteReqDone = true;
            this.notifyAll();
        }
        if (this.DEBUG) {
            this.debug("handleReply: done processing final reply");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAndNotify() {
        GuarAckExchanger guarAckExchanger = this;
        synchronized (guarAckExchanger) {
            if (this.m_remoteReqDone) {
                this.m_localReq.cancel();
            }
            this.m_localReqDone = true;
            this.notifyAll();
        }
        if (this.DEBUG) {
            this.debug("handleReply: final reply sent");
        }
    }

    private void debugAndFlush(MsgSaver deleter) throws EInterrupted {
        if (this.DEBUG) {
            this.debug("handleReply: GAX done, flushing deletes.");
        }
        try {
            deleter.flush();
        }
        catch (InterruptedException e) {
            throw new EInterrupted();
        }
    }

    private void debugData(int ctp, int ctq) {
        if (this.DEBUG) {
            this.debug("handleReply: finished processing reply; " + ctp + " pubsub messages acknowledged");
            this.debug("handleReply: finished processing reply; " + ctq + " queue messages acknowledged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logIOException(IOException e) {
        if (this.DEBUG) {
            this.debug("Exception in reply handler, aborting: " + e);
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        GuarAckExchanger guarAckExchanger = this;
        synchronized (guarAckExchanger) {
            this.m_repHandlerRunning = this.logMessageCreateFailureError(e);
        }
        this.abort();
    }

    private long getClientID(Message m, long tracking) throws IOException {
        long clientID = m.readLong();
        if (this.DEBUG) {
            this.debug("Deleting targeted gax GUAR=" + tracking + " CLIENT=" + clientID);
        }
        return clientID;
    }

    private FastVector getProxied(IClientContext cc, long tracking) {
        if (this.DEBUG) {
            this.debug("Deleting untargeted gax GUAR=" + tracking);
        }
        FastVector proxied = null;
        IClientContext ackClient = cc;
        return proxied;
    }

    private IClientContext getCc() {
        IClientContext cc = null;
        try {
            cc = AgentRegistrar.getAgentRegistrar().getClient(this.m_remoteId);
        }
        catch (EClientNotRegistered ecnr) {
            cc = this.m_neighbor.getClient();
        }
        return cc;
    }

    private MsgSaver getDeleter() {
        if (this.DEBUG) {
            this.debug("handleReply: got reply to our request");
        }
        MsgSaver deleter = AgentRegistrar.getAgentRegistrar().getMsgSaver();
        return deleter;
    }

    private boolean logMessageCreateFailureError(IOException e) {
        if (e instanceof EGeneralException) {
            this.m_err = (EGeneralException)e;
        } else {
            if (InterbrokerConfig.DEBUG) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            this.m_err = new ENetworkFailure(151, e.toString());
        }
        return false;
    }

    private static void proxyingRemoveTracking(IClientContext cc, long tracking) {
        IProxyingHandle proxying = cc.getProxyingHandle();
        if (proxying != null) {
            proxying.removeInDoubtProxyMessage(tracking);
        }
    }

    private void sendClientSolicit() throws EGeneralException {
        if (this.DEBUG) {
            this.debug("sending client side solicit");
        }
        Label local = new Label();
        local.setRouteLimit(1);
        Message req = this.createReqMessage();
        this.m_localReq = this.m_ssn.solicit(new Envelope(req, local), this.m_repMH);
    }

    private void sendBrokerSolicit() throws EGeneralException {
        if (this.DEBUG) {
            this.debug("sending broker side solicit");
        }
        Message req = this.createReqMessage();
        this.m_localReq = ((InterbrokerSession)this.m_ssn).solicit(this.m_neighbor.getConnectID(), req, this.m_repMH, 0);
    }

    private Message createReqMessage() {
        Message req = new Message(REQ_SUBJ);
        req.writeLong(this.m_localId);
        req.writeLong(this.m_token);
        return req;
    }
}

