/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import progress.message.broker.AddrUtil;
import progress.message.broker.AgentAdminConnection;
import progress.message.broker.AgentAdminSession;
import progress.message.broker.Broker;
import progress.message.client.EGeneralException;
import progress.message.client.ENetworkFailure;
import progress.message.interbroker.CWADSEvent;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Publication;
import progress.message.zclient.Solicitation;

public class InterbrokerSession
extends AgentAdminSession {
    InterbrokerSession(AgentAdminConnection aac) throws EGeneralException {
        super(aac);
    }

    public Publication publish(long broker, Message msg, int timeout, boolean ret) throws EGeneralException {
        Envelope env = this.buildDefaultEnvelope(msg);
        msg.setSubject(msg.getSubject().direct(AddrUtil.getSwizzleString(broker)));
        return this.publishInternal(env, timeout, ret, false);
    }

    void notifyCWADSUpdate(long broker, CWADSEvent ce) throws EGeneralException {
        block2: {
            Message req = ce.getMessage();
            Envelope env = this.buildDefaultEnvelope(req);
            req.setSubject(req.getSubject().direct(AddrUtil.getSwizzleString(broker)));
            env.setPriority((byte)10);
            try {
                this.publishInternal(env, 0, false, true);
            }
            catch (ENetworkFailure enf) {
                if (Broker.isInShutdown()) break block2;
                throw enf;
            }
        }
    }

    void proxySubscribe(long broker, ISubject subject, Label label) throws EGeneralException {
        block2: {
            Message req = this.buildSubscribeRequest(subject, label, null, false, false, 0, false);
            Envelope env = this.buildDefaultEnvelope(req);
            env.setRequest(0, this.m_parent.getClientAddrSubject());
            req.setSubject(req.getSubject().direct(AddrUtil.getSwizzleString(broker)));
            Label newLabel = (Label)env.getLabel().clone();
            newLabel.setReplyPriority((byte)10);
            env.setLabel(newLabel);
            try {
                this.publishInternal(env, 0, false, true);
            }
            catch (ENetworkFailure enf) {
                if (Broker.isInShutdown()) break block2;
                throw enf;
            }
        }
    }

    void proxyUnsubscribe(long broker, ISubject subject) throws EGeneralException {
        block2: {
            Message req = this.buildUnsubscribeRequest(subject);
            Envelope env = this.buildDefaultEnvelope(req);
            env.setRequest(0, this.m_parent.getClientAddrSubject());
            req.setSubject(req.getSubject().direct(AddrUtil.getSwizzleString(broker)));
            Label newLabel = (Label)env.getLabel().clone();
            newLabel.setReplyPriority((byte)10);
            env.setLabel(newLabel);
            try {
                this.publishInternal(env, 0, false, true);
            }
            catch (ENetworkFailure enf) {
                if (Broker.isInShutdown()) break block2;
                throw enf;
            }
        }
    }

    Solicitation solicit(long broker, Message request, MessageHandler mh, int timeout) throws EGeneralException {
        Envelope env = this.buildDefaultEnvelope(request);
        request.setSubject(request.getSubject().direct(AddrUtil.getSwizzleString(broker)));
        return this.solicitInternal(env, mh, timeout);
    }

    public void publish(long broker, Message msg) throws EGeneralException {
        block2: {
            Envelope env = this.buildDefaultEnvelope(msg);
            ISubject orig = msg.getSubject();
            String swizzleStr = AddrUtil.getSwizzleString(broker);
            ISubject sendsubj = orig.direct(swizzleStr);
            msg.setSubject(sendsubj);
            env.setPriority((byte)11);
            try {
                this.publishInternal(env, 0, false, true);
            }
            catch (ENetworkFailure enf) {
                if (Broker.isInShutdown()) break block2;
                throw enf;
            }
        }
    }
}

