/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v24;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.msg.IAckHandle;
import progress.message.msg.v24.Mgram;
import progress.message.msg.v24.Payload;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;

public final class AckPayload
extends Payload
implements IAckHandle {
    private static final byte ACK_PAYLOAD_LENGTH = 16;
    private static int s_trackingPos = 0;
    private static int s_errPos = s_trackingPos + 6;
    private static int s_clientIdPos = s_errPos + 2;
    private boolean m_preBodyDirty = true;
    private byte[] m_preBodyBuffer = null;
    private long m_guarTrackingNum = -1L;
    private boolean m_isGuarenteedInit = false;
    private long m_trackingNum;
    private short m_err;
    private long m_clientID;
    private int m_txnId;
    private boolean m_hasTxnIdInit = false;
    private byte[] m_bodyBuffer = new byte[16];

    public AckPayload(Mgram m) {
        super(m);
    }

    @Override
    public Object clone(Mgram m) throws CloneNotSupportedException {
        AckPayload ap = (AckPayload)super.clone();
        ap.m_mgram = m;
        if (this.m_preBodyBuffer != null && !this.m_preBodyDirty) {
            ap.m_preBodyBuffer = new byte[this.m_preBodyBuffer.length];
            System.arraycopy(this.m_preBodyBuffer, 0, ap.m_preBodyBuffer, 0, this.m_preBodyBuffer.length);
        } else {
            ap.m_preBodyBuffer = null;
        }
        ap.m_bodyBuffer = new byte[this.m_bodyBuffer.length];
        System.arraycopy(this.m_bodyBuffer, 0, ap.m_bodyBuffer, 0, this.m_bodyBuffer.length);
        return ap;
    }

    @Override
    void initPayloadFromStream(InputStream is) throws IOException, EMgramFormatError {
        if (this.m_mgram.isGuarenteed()) {
            this.m_guarTrackingNum = StreamUtil.read6ByteLong(is);
            this.m_preBodyDirty = true;
        }
        if (this.m_mgram.hasTxn()) {
            this.m_txnId = StreamUtil.readInt(is);
            this.m_preBodyDirty = true;
        }
        StreamUtil.readBytes(is, this.m_bodyBuffer, 0, 16);
        this.m_trackingNum = ArrayUtil.read6ByteLong(this.m_bodyBuffer, s_trackingPos);
        this.m_err = ArrayUtil.readShort(this.m_bodyBuffer, s_errPos);
        this.m_clientID = ArrayUtil.readLong(this.m_bodyBuffer, s_clientIdPos);
        this.m_mgram.setStatus(3);
    }

    @Override
    void setGuarenteed(long tracking) {
        if (this.m_isGuarenteedInit && !this.m_preBodyDirty) {
            ArrayUtil.write6ByteLong(this.m_preBodyBuffer, 0, tracking);
        } else {
            this.m_preBodyDirty = true;
        }
        this.m_guarTrackingNum = tracking;
    }

    @Override
    long getGuarenteedTrackingNum() {
        return this.m_guarTrackingNum;
    }

    @Override
    byte[] toByteArray() {
        int offset = 0;
        int preBodyLength = 0;
        if (this.m_preBodyBuffer != null) {
            preBodyLength += this.m_preBodyBuffer.length;
        }
        byte[] result = new byte[16 + preBodyLength];
        this.sync();
        if (preBodyLength > 0) {
            System.arraycopy(this.m_preBodyBuffer, 0, result, 0, preBodyLength);
            offset += preBodyLength;
        }
        System.arraycopy(this.m_bodyBuffer, 0, result, offset, 16);
        return result;
    }

    @Override
    void sync() {
        if (this.m_preBodyDirty) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                this.writePreBodyToStream(bos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.m_preBodyBuffer = bos.toByteArray();
            if (this.m_mgram.isGuarenteed()) {
                this.m_isGuarenteedInit = true;
            }
            if (this.m_mgram.hasTxn()) {
                this.m_hasTxnIdInit = true;
            }
            this.m_preBodyDirty = false;
        }
    }

    private void writePreBodyToStream(OutputStream os) throws IOException {
        if (this.m_preBodyDirty) {
            boolean isGuarenteed = this.m_mgram.isGuarenteed();
            boolean isTxn = this.m_mgram.hasTxn();
            if (isGuarenteed) {
                StreamUtil.write6ByteLong(this.m_guarTrackingNum, os);
            }
            if (isTxn) {
                StreamUtil.writeInt(this.m_txnId, os);
            }
        } else if (this.m_preBodyBuffer != null) {
            os.write(this.m_preBodyBuffer);
        }
    }

    @Override
    void writeToStream(OutputStream os) throws IOException {
        this.writePreBodyToStream(os);
        os.write(this.m_bodyBuffer);
    }

    @Override
    void setTxn(int tid) {
        if (this.m_hasTxnIdInit && !this.m_preBodyDirty) {
            if (this.m_isGuarenteedInit) {
                ArrayUtil.write6ByteLong(this.m_preBodyBuffer, 6, tid);
            } else {
                ArrayUtil.write6ByteLong(this.m_preBodyBuffer, 0, tid);
            }
        } else {
            this.m_preBodyDirty = true;
        }
        this.m_txnId = tid;
    }

    @Override
    public int length() {
        this.sync();
        int length = 0;
        if (this.m_preBodyBuffer != null) {
            length += this.m_preBodyBuffer.length;
        }
        return length + this.m_bodyBuffer.length;
    }

    @Override
    public long getClientID() {
        return this.m_clientID;
    }

    @Override
    public void setClientID(long id) {
        this.m_clientID = id;
        ArrayUtil.writeLong(this.m_bodyBuffer, s_clientIdPos, this.m_clientID);
    }

    @Override
    public short getErr() {
        return this.m_err;
    }

    @Override
    public void setErr(short err) {
        this.m_err = err;
        ArrayUtil.writeShort(this.m_bodyBuffer, s_errPos, this.m_err);
    }

    @Override
    public long getTrackingNumber() {
        return this.m_trackingNum;
    }

    @Override
    public void setTrackingNumber(long number) {
        this.m_trackingNum = number;
        ArrayUtil.write6ByteLong(this.m_bodyBuffer, s_trackingPos, this.m_trackingNum);
    }

    @Override
    public IAckHandle getAckHandle() {
        return this;
    }

    @Override
    public boolean isSubjectAck() {
        return false;
    }

    @Override
    public short getSubjectTracking() {
        return -1;
    }

    @Override
    public void setSubjectTracking(short subjectTracking) {
        throw new EAssertFailure("INVALID_OPERATION");
    }
}

