/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import progress.message.msg.IFlowControlHandle;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.Payload;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.SessionConfig;

final class FlowControlPayload
extends Payload
implements IFlowControlHandle {
    static final int FLOW_CONTROL_PAYLOAD_LEN = 1;
    private byte m_priority;
    static final int s_fcMemSize = MemoryUtil.estimateBaseSize(FlowControlPayload.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.println("Min priority: " + this.m_priority);
        }
    }

    public FlowControlPayload(Mgram m) {
        super(m);
    }

    @Override
    protected boolean isDirty() {
        return false;
    }

    @Override
    protected int memoryLength() {
        return s_fcMemSize;
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        this.m_priority = StreamUtil.readByte(is);
    }

    @Override
    protected byte[] toByteArray() {
        byte[] result = new byte[]{this.m_priority};
        return result;
    }

    @Override
    protected void syncPayload() {
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        os.write(this.m_priority);
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public byte getMinPriority() {
        return this.m_priority;
    }

    @Override
    public void setMinPriority(byte priority) {
        this.m_priority = priority;
    }

    static void setMinPriority(byte priority, byte[] buffer) {
        buffer[0] = priority;
    }

    @Override
    public IFlowControlHandle getFlowControlHandle() {
        return this;
    }

    @Override
    public HashMap getPayloadProperties() {
        HashMap<String, Byte> result = new HashMap<String, Byte>();
        result.put("FC_MIN_PRIORITY", new Byte(this.m_priority));
        return result;
    }

    @Override
    public void setPayloadProperties(HashMap map) {
        this.m_priority = (Byte)map.get("FC_MIN_PRIORITY");
    }
}

