/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26.broker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import progress.message.broker.LogEvent;
import progress.message.msg.IStateEventHandle;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.Payload;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.IStateEvent;
import progress.message.zclient.SessionConfig;

final class StateEventPayload
extends Payload
implements IStateEventHandle {
    static final int s_stateEventPayloadMemSize = MemoryUtil.estimateBaseSize(StateEventPayload.class);
    private IStateEvent m_event;
    private boolean m_tteTTLConvert = false;
    private long m_trackingNum;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            if (this.m_event != null) {
                log.print(this.m_event.toString());
                if (this.m_mgram.isGuarenteed()) {
                    log.print("Tracking Num: " + this.m_trackingNum);
                }
            }
        }
    }

    public StateEventPayload(Mgram m) {
        super(m);
    }

    public StateEventPayload(Mgram m, IStateEvent event, boolean tteTTLConvert) {
        super(m);
        this.m_tteTTLConvert = tteTTLConvert;
        this.m_event = event;
    }

    @Override
    public void setGuarenteed(long tracking) {
        this.m_trackingNum = tracking;
    }

    @Override
    public long getGuarenteedTrackingNum() {
        return this.m_trackingNum;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public int memoryLength() {
        return s_stateEventPayloadMemSize + this.m_event.memsize();
    }

    @Override
    public int length() {
        return 1 + this.m_event.length();
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        this.m_tteTTLConvert = StreamUtil.readBoolean(is);
        if (this.m_mgram.isGuarenteedInternal()) {
            this.m_trackingNum = StreamUtil.read6ByteLong(is);
        }
        this.m_event = (LogEvent)LogEvent.readFromStream(is, this.m_tteTTLConvert);
    }

    @Override
    protected void syncPayload() {
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        if (this.m_tteTTLConvert) {
            StreamUtil.writeBoolean(true, os);
        } else {
            StreamUtil.writeBoolean(false, os);
        }
        if (this.m_mgram.isGuarenteedInternal()) {
            StreamUtil.write6ByteLong(this.m_trackingNum, os);
        }
        this.m_event.writeToStream(os, this.m_tteTTLConvert);
    }

    @Override
    public IStateEventHandle getStateEventHandle() {
        return this;
    }

    @Override
    public IStateEvent getStateEvent() {
        return this.m_event;
    }

    public void setStateEvent(IStateEvent event) {
        this.m_event = event;
    }

    @Override
    protected byte[] toByteArray() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeToStream(baos);
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public HashMap getPayloadProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("SE_EVENT", this.m_event);
        result.put("SE_TRACKING_NUM", new Long(this.m_trackingNum));
        result.put("SE_TTE_TTL_CONVERT", new Boolean(this.m_tteTTLConvert));
        return result;
    }

    @Override
    public void setPayloadProperties(HashMap map) {
        this.m_event = (IStateEvent)map.get("SE_EVENT");
        this.m_trackingNum = (Long)map.get("SE_TRACKING_NUM");
        this.m_tteTTLConvert = (Boolean)map.get("SE_TTE_TTL_CONVERT");
    }
}

