/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.https.server.tunnel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import progress.message.net.http.server.IHttpRequestHandler;
import progress.message.net.http.server.SonicHttpServer;
import progress.message.net.https.server.SonicHttpsConnection;
import progress.message.net.https.server.SonicHttpsServer;
import progress.message.net.https.server.tunnel.HttpsConnectionSocket;

public class HttpsTunnelHandler
implements IHttpRequestHandler {
    private static HttpsTunnelHandler s_httpsTunnelHandler = null;
    private Hashtable m_connections = new Hashtable();
    private int m_nextConnectionId = 0;
    private Thread m_connectionCleaner = null;
    static int CONNECTION_CLEANUP_INTERVAL = 60000;
    static boolean DEBUG = false;
    static Object _sync = new Object();

    private HttpsTunnelHandler(Properties props) {
        String cleanupInterval;
        if (props != null && (cleanupInterval = props.getProperty("HTTP_CONNECTION_CLEANUP_INTERVAL")) != null) {
            CONNECTION_CLEANUP_INTERVAL = Integer.parseInt(cleanupInterval);
        }
        DEBUG = SonicHttpsServer.getDebug();
        this.startConnectionCleaner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpsTunnelHandler getTunnelHandler(Properties props) {
        Object object = _sync;
        synchronized (object) {
            if (s_httpsTunnelHandler == null) {
                s_httpsTunnelHandler = new HttpsTunnelHandler(props);
            }
            return s_httpsTunnelHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = _sync;
        synchronized (object) {
            if (s_httpsTunnelHandler != null) {
                s_httpsTunnelHandler.stopConnectionCleaner();
            }
        }
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, SonicHttpServer server, Socket socket) throws IOException {
        if (!HttpMethod.POST.asString().equals(request.getMethod().trim())) {
            if (DEBUG) {
                System.out.println("Return 400 - Method " + request.getMethod() + " is not supported.");
            }
            HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.FAIL_STATUS);
            return;
        }
        String path = request.getRequestURI();
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        if (DEBUG) {
            System.out.println(Thread.currentThread() + " handling " + path);
        }
        if (path.equals("/SC/Exist")) {
            this.handleExistingConnection(request, response);
        } else if (path.equals("/SC/ReqData")) {
            this.retrieveData(request, response);
        } else if (path.equals("/SC/New")) {
            this.handleNewConnection(request, response);
        } else if (path.equals("/SC/Close")) {
            this.closeConnection(request, response);
        } else {
            this.closeConnection(request, response);
        }
        this.castToJettyRequest(request).setHandled(true);
    }

    private Request castToJettyRequest(HttpServletRequest request) {
        if (request instanceof Request) {
            return (Request)request;
        }
        throw new IllegalArgumentException("No org.eclipse.jetty.server.Request");
    }

    private SonicHttpsConnection castToSonicHttpsConnection(HttpServletRequest request) {
        if (request instanceof Request) {
            Connection connection = ((Request)request).getHttpChannel().getConnection();
            if (connection instanceof SonicHttpsConnection) {
                return (SonicHttpsConnection)connection;
            }
            throw new IllegalArgumentException("No SonicHttpsConnection");
        }
        throw new IllegalArgumentException("No org.eclipse.jetty.server.Request");
    }

    private void handleExistingConnection(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            int bWritten;
            int id = request.getIntHeader("ConnectionId");
            HttpsConnectionSocket tSocket = (HttpsConnectionSocket)this.m_connections.get(new Integer(id));
            if (tSocket == null || tSocket.m_closedByBroker || tSocket.m_closedByClient) {
                if (DEBUG) {
                    System.out.println("Return 400 - HTTP Connection " + id + ": handleExistingConnection() non-existent or inactive socket.");
                }
                HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.CLOSING_STATUS);
                return;
            }
            if (!tSocket.isClient(this.castToSonicHttpsConnection(request).getPeerCertificate())) {
                if (DEBUG) {
                    System.out.println("Return 400 - Connection " + id + ": handleExistingConnection() not owner.");
                }
                HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.FAIL_STATUS);
                return;
            }
            int sequenceNo = request.getIntHeader("SequenceNumber");
            if (sequenceNo == -1) {
                if (DEBUG) {
                    System.out.println("Return 400 - HTTP Connection " + id + ": handleExistingConnection() invalid sequence number, timestamp = " + System.currentTimeMillis());
                }
                HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.FAIL_STATUS);
                return;
            }
            int contentLength = request.getIntHeader("Content-length");
            if (contentLength == -1) {
                bWritten = tSocket.clientWrite((InputStream)request.getInputStream(), sequenceNo);
            } else {
                byte[] buf = new byte[contentLength];
                int len = 0;
                int off = 0;
                while ((len = request.getInputStream().read(buf, off, contentLength - off)) >= 0) {
                    off += len;
                }
                bWritten = tSocket.clientWrite(new ByteArrayInputStream(buf), sequenceNo);
            }
            if (bWritten >= 0) {
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": client written " + bWritten + " bytes to the broker.");
                }
                HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.SUCCESS_STATUS);
            } else {
                if (DEBUG) {
                    System.out.println("Return 400 - HTTP Connection " + id + ": handleExistingConnection() error reading client data.");
                }
                HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.FAIL_STATUS);
            }
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.FAIL_STATUS);
        }
    }

    private void handleNewConnection(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int id = -1;
        HttpsConnectionSocket tSocket = null;
        id = request.getIntHeader("SONIC_CLIENT_PING");
        if (id != -1) {
            if (DEBUG) {
                System.out.println("HTTP Connection " + id + " pinging at " + new Date(System.currentTimeMillis()));
            }
            if ((tSocket = (HttpsConnectionSocket)this.m_connections.get(new Integer(id))) == null || tSocket.m_closedByBroker) {
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": non-existent or socket closed by broker, response = " + HttpsConnectionSocket.CLOSING_STATUS);
                }
                HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.CLOSING_STATUS);
            } else {
                tSocket.setLastReqTime(System.currentTimeMillis());
                HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.SUCCESS_STATUS);
            }
            return;
        }
        id = this.getNextConnectionId();
        SonicHttpsConnection conn = this.castToSonicHttpsConnection(request);
        tSocket = new HttpsConnectionSocket(conn.getInetAddress(), id, conn.getPeerCertificate());
        tSocket.setLastReqTime(System.currentTimeMillis());
        this.m_connections.put(new Integer(id), tSocket);
        if (DEBUG) {
            System.out.println("HTTP Connection " + id + ": created.");
        }
        conn.getSonnicHttpsServerServer().addHttpsConnection(tSocket);
        response.setIntHeader("SonicPingInterval", HttpsConnectionSocket.getClientIdleTimeout());
        response.setIntHeader("Content-Length", 4);
        response.setStatus(200);
        response.flushBuffer();
        ServletOutputStream out = response.getOutputStream();
        out.write((byte)(id >>> 24 & 0xFF));
        out.write((byte)(id >>> 16 & 0xFF));
        out.write((byte)(id >>> 8 & 0xFF));
        out.write((byte)(id & 0xFF));
        out.flush();
        HttpsTunnelHandler.commitResponse(response);
    }

    private static void commitResponse(HttpServletResponse response) throws IOException {
        if (response instanceof Request) {
            ((Response)response).completeOutput();
        } else {
            response.flushBuffer();
        }
    }

    private void closeConnection(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            int id = request.getIntHeader("ConnectionId");
            HttpsConnectionSocket tSocket = (HttpsConnectionSocket)this.m_connections.get(new Integer(id));
            if (tSocket == null) {
                if (DEBUG) {
                    System.out.println("Return 400 - HTTP Connection " + id + ": closeConnection() non-existent socket.");
                }
                HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.FAIL_STATUS);
                return;
            }
            SonicHttpsConnection conn = this.castToSonicHttpsConnection(request);
            if (!tSocket.isClient(conn.getPeerCertificate())) {
                if (DEBUG) {
                    System.out.println("Return 400 - Connection " + id + ": closeConnection() not owner.");
                }
                HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.FAIL_STATUS);
                return;
            }
            tSocket.clientClose();
            HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.SUCCESS_STATUS);
            if (DEBUG) {
                System.out.println("HTTP Connection " + id + ": closed by the client, timestamp = " + System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.FAIL_STATUS);
        }
    }

    private void retrieveData(HttpServletRequest request, HttpServletResponse response) {
        try {
            int id = request.getIntHeader("ConnectionId");
            if (id == -1) {
                if (DEBUG) {
                    System.out.println("Invalid ConnectionId. Sending response : " + HttpsConnectionSocket.NO_DATA_STATUS);
                }
                HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.NO_DATA_STATUS);
                return;
            }
            HttpsConnectionSocket tSocket = null;
            tSocket = (HttpsConnectionSocket)this.m_connections.get(new Integer(id));
            if (tSocket == null) {
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": retrieveData() invalid connection.");
                }
                HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.FAIL_STATUS);
                return;
            }
            if (tSocket.m_closedByClient) {
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": retrieveData() connection already closed by client.");
                }
                tSocket.handleError(response, false, HttpsConnectionSocket.SUCCESS_STATUS);
                return;
            }
            SonicHttpsConnection conn = this.castToSonicHttpsConnection(request);
            if (!tSocket.isClient(conn.getPeerCertificate())) {
                if (DEBUG) {
                    System.out.println("Connection " + id + ": retrieveData() not owner.");
                }
                tSocket.handleError(response, false, HttpsConnectionSocket.SUCCESS_STATUS);
                return;
            }
            int bRead = tSocket.clientRead(response);
            if (DEBUG) {
                System.out.println("HTTP Connection " + id + ": client read " + bRead + " bytes from the broker.");
            }
        }
        catch (Exception e) {
            if (DEBUG) {
                System.out.println("400 - Exception retrieving data: " + e.getMessage());
            }
            HttpsConnectionSocket.sendReplyCode(response, HttpsConnectionSocket.FAIL_STATUS);
        }
    }

    private synchronized int getNextConnectionId() throws IOException {
        this.m_nextConnectionId = this.m_nextConnectionId == Integer.MAX_VALUE ? 0 : ++this.m_nextConnectionId;
        int save = this.m_nextConnectionId;
        while (this.m_connections.get(new Integer(this.m_nextConnectionId)) != null) {
            this.m_nextConnectionId = this.m_nextConnectionId == Integer.MAX_VALUE ? 0 : ++this.m_nextConnectionId;
            if (this.m_nextConnectionId != save) continue;
            throw new IOException("Max connections exceeded.");
        }
        return this.m_nextConnectionId;
    }

    private void stopConnectionCleaner() {
        if (this.m_connectionCleaner != null) {
            Thread t = this.m_connectionCleaner;
            this.m_connectionCleaner = null;
            t.interrupt();
        }
    }

    private void startConnectionCleaner() {
        this.m_connectionCleaner = null;
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                block4: while (true) {
                    block10: {
                        try {
                            if (Thread.currentThread() != HttpsTunnelHandler.this.m_connectionCleaner) {
                                return;
                            }
                            Thread.sleep(CONNECTION_CLEANUP_INTERVAL);
                        }
                        catch (InterruptedException e) {
                            if (Thread.currentThread() == HttpsTunnelHandler.this.m_connectionCleaner) break block10;
                            if (DEBUG) {
                                System.out.println("Shutting down connection cleanup thread " + Thread.currentThread());
                            }
                            return;
                        }
                    }
                    if (DEBUG) {
                        System.out.println(Thread.currentThread() + ": starts connection cleanuping at " + new Date());
                    }
                    Enumeration conns = HttpsTunnelHandler.this.m_connections.keys();
                    while (true) {
                        if (!conns.hasMoreElements()) continue block4;
                        Integer id = (Integer)conns.nextElement();
                        HttpsConnectionSocket socket = (HttpsConnectionSocket)HttpsTunnelHandler.this.m_connections.get(id);
                        if (socket.isActive()) continue;
                        if (DEBUG) {
                            System.out.println("HTTPS Connection " + id + ": closing orphaned socket");
                        }
                        HttpsTunnelHandler.this.m_connections.remove(id);
                        try {
                            socket.cleanup();
                        }
                        catch (IOException iOException) {
                        }
                    }
                    break;
                }
            }
        };
        this.m_connectionCleaner = new Thread(runner);
        this.m_connectionCleaner.setName("HTTPS connection cleaner");
        this.m_connectionCleaner.setDaemon(true);
        this.m_connectionCleaner.start();
    }
}

