/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl;

import java.io.File;
import progress.message.broker.Config;
import progress.message.net.ssl.CRLCache;
import progress.message.net.ssl.FSCRLStore;
import progress.message.net.ssl.FSCRLStoreParameters;
import progress.message.net.ssl.InvalidCRLStoreParametersException;
import progress.message.net.ssl.LDAPCRLStore;

public abstract class CRLStore {
    public static final int FS_STORE = 0;
    public static final int LDAP_STORE = 1;
    public static final int CRLDP_STORE = 2;
    private static boolean DEBUG = false;

    protected CRLStore() {
    }

    public static CRLStore getStore() {
        return CRLStoreLazyHolder.CRL_STORE;
    }

    public static void setDebug(boolean on) {
        DEBUG = on;
    }

    public static void shutdown() {
        if (CRLStoreLazyHolder.CRL_STORE == null) {
            return;
        }
        CRLStoreLazyHolder.CRL_STORE.cleanup();
    }

    public abstract void init() throws InvalidCRLStoreParametersException;

    public abstract void cleanup();

    public abstract void bind(CRLCache var1);

    public abstract byte[] getCRLByIssuer(String var1);

    public abstract byte[] getCRLByDP(String var1);

    private static class CRLStoreLazyHolder {
        private static final CRLStore CRL_STORE = CRLStoreLazyHolder.getInstance(1);

        private CRLStoreLazyHolder() {
        }

        private static CRLStore getInstance(int storeType) {
            CRLStore crlStore = null;
            if (storeType == 0) {
                String crlDir = Config.SSL_CA_CERTIFICATES_DIR + File.separator + "CRL";
                if (new File(crlDir).exists()) {
                    crlStore = new FSCRLStore(new FSCRLStoreParameters(crlDir));
                }
            } else if (storeType == 1) {
                crlStore = new LDAPCRLStore();
            }
            return crlStore;
        }
    }
}

