/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl.jsafe;

import com.rsa.certj.CertJ;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.pkcs12.PKCS12;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.ssl.AlertException;
import com.rsa.ssl.CipherSuite;
import com.rsa.ssl.CipherSuiteLists;
import com.rsa.ssl.SSLException;
import com.rsa.ssl.SSLParams;
import com.rsa.ssl.SSLUtils;
import com.rsa.ssl.external.CertVerifier;
import com.rsa.ssl.external.Truster;
import com.sonicsw.security.ssl.SSLUtil;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import progress.message.net.ESocketConfigException;
import progress.message.net.ssl.ISSLControl;
import progress.message.net.ssl.jsafe.jsafeX509Certificate;
import progress.message.net.ssl.jsafe.prAccessor;
import progress.message.zclient.SessionConfig;

public class jsafeSSLClientControl
implements ISSLControl {
    protected SSLParams context = null;
    protected boolean DEBUG = false;
    private static Hashtable cipherSuites = new Hashtable();

    public jsafeSSLClientControl() throws ESocketConfigException {
        try {
            if (this.context == null) {
                this.context = new SSLParams();
            }
            this.context.getRandom().autoseed();
        }
        catch (SSLException ex) {
            if (this.DEBUG) {
                ex.printStackTrace();
            }
            ESocketConfigException sce = new ESocketConfigException(ex.getMessage());
            sce.fillInStackTrace();
            throw sce;
        }
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean configureKeyAndCertificate(String certificates, String certForm, String key, String keyForm, String password) {
        if (this.context == null) {
            return false;
        }
        boolean loaded = true;
        if (certForm.equalsIgnoreCase("PKCS12")) {
            if (certificates == null) return false;
            if (password == null) {
                return false;
            }
            try {
                JSAFE_PrivateKey[] keys;
                PKCS12 p12 = new PKCS12(new CertJ(), null, password.toCharArray(), certificates);
                Certificate[] certChain = p12.getCertificates();
                if (certChain == null) {
                    return false;
                }
                X509Certificate[] chain = new X509Certificate[certChain.length];
                for (int k = 0; k < certChain.length; ++k) {
                    chain[k] = (X509Certificate)certChain[k];
                }
                if (this.DEBUG) {
                    System.out.println("Loading certificate chain from PKCS12 :");
                    for (int i = 0; i < chain.length; ++i) {
                        System.out.println("certificate[" + i + "] = " + chain[i].getSubjectName().toString());
                    }
                }
                if ((keys = p12.getKeys()).length != 1) {
                    throw new Exception("More than one key exists in the specified PKCS12 object");
                }
                if (keys == null) return false;
                if (keys[0] == null) {
                    return false;
                }
                this.context.addCertificateChainAndKey(chain, keys[0]);
                return loaded;
            }
            catch (Exception ex) {
                SessionConfig.logMessage(ex.getMessage(), ex, SessionConfig.getLevelWarning());
                return false;
            }
        }
        if (certForm.equalsIgnoreCase("PKCS7")) {
            FileInputStream fin = null;
            ByteArrayOutputStream bos = null;
            if (certificates == null) return false;
            if (key == null) return false;
            if (password == null) {
                return false;
            }
            try {
                byte[] privateKey;
                Vector certs = jsafeX509Certificate.loadCertificateChain(certificates);
                if (certs == null || certs.isEmpty()) {
                    boolean keys = false;
                    return keys;
                }
                Object[] chain = new X509Certificate[certs.size()];
                certs.copyInto(chain);
                if (this.DEBUG) {
                    System.out.println("Loading certificate chain from PKCS7 :");
                    for (int i = 0; i < chain.length; ++i) {
                        System.out.println("certificate[" + i + "] = " + chain[i].getSubjectName().toString());
                    }
                    System.out.println("Loading private key from " + key + ", pwd = ********");
                }
                if ((privateKey = SSLUtils.loadKey((String)key.trim())) == null || privateKey.length == 0) {
                    boolean bl = false;
                    return bl;
                }
                this.context.addCertificateChainAndKey((X509Certificate[])chain, privateKey, password.toCharArray());
                return loaded;
            }
            catch (Exception ex) {
                SessionConfig.logMessage(ex.getMessage(), ex, SessionConfig.getLevelWarning());
                loaded = false;
                return loaded;
            }
            finally {
                try {
                    if (fin != null) {
                        fin.close();
                    }
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        try {
            byte[][] certChain = this.loadCertificateChain(certificates);
            byte[] privateKey = SSLUtils.loadKey((String)key.trim());
            this.context.addCertificateChainAndKey(certChain, privateKey, password.toCharArray());
            return loaded;
        }
        catch (Exception ex) {
            SessionConfig.logMessage(ex.getMessage(), ex, SessionConfig.getLevelWarning());
            return false;
        }
    }

    @Override
    public boolean configureCipherSuites(Vector ciphers) {
        if (this.context == null) {
            return false;
        }
        CipherSuite[] cs = null;
        cs = ciphers == null ? CipherSuiteLists.All_Ciphers() : this.verifyCiphers(ciphers);
        try {
            this.context.setCipherSuites(cs);
        }
        catch (SSLException ex) {
            SessionConfig.logMessage(ex.getMessage(), ex, SessionConfig.getLevelWarning());
            return false;
        }
        if (this.DEBUG) {
            try {
                CipherSuite[] rcs = this.context.getCipherSuites();
                System.out.println("Enabling cipher suite(s) :");
                for (int i = 0; i < rcs.length; ++i) {
                    System.out.println(rcs[i]);
                }
            }
            catch (SSLException ex) {
                SessionConfig.logMessage(ex.getMessage(), ex, SessionConfig.getLevelWarning());
            }
        }
        return true;
    }

    @Override
    public boolean configureTrustDecider(String caCerts, String trustDecider) throws ESocketConfigException {
        if (this.context == null) {
            return false;
        }
        if (caCerts == null) {
            SessionConfig.logMessage(prAccessor.getString("STR001"), SessionConfig.getLevelInfo());
            return false;
        }
        if (!caCerts.equals("NONE")) {
            try {
                X509Certificate[] certs = this.loadCACertificates(caCerts);
                if (certs == null || certs.length == 0) {
                    return false;
                }
                if (this.DEBUG) {
                    System.out.println("total CA certificate count = " + certs.length);
                }
                for (int i = 0; i < certs.length; ++i) {
                    this.context.addCACertificate(certs[i]);
                }
            }
            catch (Exception ex) {
                SessionConfig.logMessage(ex.getMessage(), ex, SessionConfig.getLevelWarning());
            }
        }
        if (trustDecider != null) {
            try {
                Class<?> trustClass = Class.forName(trustDecider);
                Object truster = trustClass.newInstance();
                if (!(truster instanceof Truster)) {
                    throw new Exception(trustDecider + " is not an instance of com.rsa.ssl.external.Truster");
                }
                this.context.setTruster((Truster)truster);
            }
            catch (Exception ex) {
                String mf104 = prAccessor.getString("STR004");
                Object[] ob104 = new Object[]{trustDecider, ex + ex.getMessage()};
                SessionConfig.logMessage(MessageFormat.format(mf104, ob104), ex, SessionConfig.getLevelWarning());
                return false;
            }
        } else {
            this.context.setTruster((Truster)new SonicCertVerifier());
        }
        return true;
    }

    public String toString() {
        return this.context == null ? null : this.context.toString();
    }

    private static byte[] getUrlData(String urlName) throws MalformedURLException, IOException {
        int nbytes;
        URL url = new URL(urlName);
        InputStream str = url.openStream();
        byte[] bytes = new byte[512];
        int len = 0;
        while ((nbytes = str.read(bytes, len, bytes.length - len)) > 0) {
            if (bytes.length - (len += nbytes) >= 1) continue;
            byte[] bigger = new byte[bytes.length * 2];
            System.arraycopy(bytes, 0, bigger, 0, len);
            bytes = bigger;
        }
        str.close();
        if (len != bytes.length) {
            byte[] ret = new byte[len];
            System.arraycopy(bytes, 0, ret, 0, len);
            bytes = ret;
        }
        return bytes;
    }

    protected byte[][] loadCertificateChain(String certChain) throws Exception {
        if (certChain == null || certChain.trim().length() == 0) {
            throw new Exception("Certificate chain is not specified");
        }
        StringTokenizer tok = new StringTokenizer(certChain, ",");
        Vector<byte[]> certs = new Vector<byte[]>();
        byte[] buffer = new byte[2048];
        if (this.DEBUG) {
            System.out.println("Loading certificate chain from a list of files/urls :");
        }
        int i = 0;
        while (tok.hasMoreElements()) {
            String next = tok.nextToken();
            next = next.trim();
            if (this.DEBUG) {
                System.out.println("reading certificate[" + i + "] from " + next);
            }
            FileInputStream in = new FileInputStream(new File(next));
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            try {
                int len;
                while ((len = ((InputStream)in).read(buffer)) >= 0) {
                    out.write(buffer, 0, len);
                }
            }
            catch (EOFException e) {
                // empty catch block
            }
            certs.addElement(out.toByteArray());
            ((InputStream)in).close();
            out.close();
        }
        if (certs.size() != 0) {
            byte[][] chain = new byte[certs.size()][];
            certs.copyInto((Object[])chain);
            return chain;
        }
        throw new Exception("Unable to load the cert chain " + certChain);
    }

    protected X509Certificate[] loadCACertificates(String caCerts) {
        File certDir = new File(caCerts);
        if (certDir.isDirectory()) {
            try {
                if (this.DEBUG) {
                    System.out.println("Loading CA Certificates from directory " + caCerts + " :");
                }
                return SSLUtils.loadCertificateDirectory((String)caCerts);
            }
            catch (Exception ex) {
                SessionConfig.logMessage(ex.getMessage(), ex, SessionConfig.getLevelWarning());
                return null;
            }
        }
        StringTokenizer st = new StringTokenizer(caCerts, ",");
        int count = st.countTokens() == 0 ? 1 : st.countTokens();
        int trustedCA = 0;
        Vector<X509Certificate> temp = new Vector<X509Certificate>();
        for (int i = 0; i < count; ++i) {
            String cert = st.nextToken();
            try {
                temp.addElement(new X509Certificate(jsafeSSLClientControl.getUrlData(cert), 0, 0));
                ++trustedCA;
                continue;
            }
            catch (MalformedURLException e) {
                try {
                    temp.addElement(SSLUtils.loadCertificate((String)cert));
                    ++trustedCA;
                }
                catch (SSLException ex) {
                    String mf85 = prAccessor.getString("STR003");
                    Object[] ob85 = new Object[]{cert, ex.getMessage()};
                    SessionConfig.logMessage(MessageFormat.format(mf85, ob85), SessionConfig.getLevelWarning());
                }
                continue;
            }
            catch (Exception e) {
                String mf85 = prAccessor.getString("STR003");
                Object[] ob85 = new Object[]{cert, e + e.getMessage()};
                SessionConfig.logMessage(MessageFormat.format(mf85, ob85), e, SessionConfig.getLevelWarning());
            }
        }
        Object[] certs = new X509Certificate[temp.size()];
        temp.copyInto(certs);
        return certs;
    }

    protected CipherSuite[] verifyCiphers(Vector ciphers) {
        CipherSuite[] csTemp = new CipherSuite[ciphers.size()];
        Enumeration csNames = ciphers.elements();
        int i = 0;
        while (csNames.hasMoreElements()) {
            CipherSuite cipher;
            block4: {
                String className = (String)csNames.nextElement();
                cipher = (CipherSuite)cipherSuites.get(className.toUpperCase());
                if (cipher == null) {
                    try {
                        cipher = (CipherSuite)Class.forName("com.rsa.ssl.ciphers." + className).newInstance();
                        cipherSuites.put(className.toUpperCase(), cipher);
                    }
                    catch (Exception ex) {
                        if (!this.DEBUG) break block4;
                        System.out.println("Unknown cipher specified: " + className);
                    }
                }
            }
            if (cipher == null) continue;
            csTemp[i++] = cipher;
        }
        CipherSuite[] cs = new CipherSuite[i];
        System.arraycopy(csTemp, 0, cs, 0, i);
        return cs;
    }

    @Override
    public void setDebug(boolean on) {
        this.DEBUG = on;
        if (this.DEBUG) {
            this.context.setDebug(1);
            this.context.setDebugOutput((OutputStream)System.out);
        }
    }

    protected void setProtocolVersions(Object properties) {
        try {
            int[] versions;
            SSLParams context = (SSLParams)this.getContext();
            String tlsV1Property = SSLUtil.getProperty(properties, "ENABLE_TLSV1_ONLY", "false");
            boolean tlsV1Only = Boolean.valueOf(tlsV1Property.trim());
            String sslV3Property = SSLUtil.getProperty(properties, "ENABLE_SSLV3_ONLY", "false");
            boolean sslV3Only = Boolean.valueOf(sslV3Property.trim());
            if (!sslV3Only && !tlsV1Only) {
                versions = new int[]{768, 769};
            } else if (sslV3Only && !tlsV1Only) {
                versions = new int[]{768};
            } else if (!sslV3Only && tlsV1Only) {
                versions = new int[]{769};
            } else {
                SessionConfig.logMessage("Conflicting values set for ENABLE_SSLV3_ONLY and ENABLE_TLSV1_ONLY properties.  Ignoring both", SessionConfig.getLevelWarning());
                versions = new int[]{768, 769};
            }
            context.setVersions(versions);
        }
        catch (SSLException ex) {
            if (this.DEBUG) {
                ex.printStackTrace();
            }
            SessionConfig.logMessage("Unable to set specified protocol versions.  Using default - both SSLV3 and TLSV1 enabled.", SessionConfig.getLevelWarning());
        }
    }

    class SonicCertVerifier
    extends CertVerifier {
        SonicCertVerifier() {
        }

        public int verifyCertificate(SSLParams paramList, X509Certificate[] certChain, CipherSuite cipherSuite) throws AlertException, SSLException {
            X509Certificate[] CAs = paramList.getCACertificates();
            if (CAs == null || CAs.length == 0) {
                return 0;
            }
            return super.verifyCertificate(paramList, certChain, cipherSuite);
        }
    }
}

