/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.util.VersionData;
import progress.message.zclient.ClientConnectParms;

public final class BrokerConnectParms {
    private static final byte CURRENT_VERSION = 4;
    private short m_version;
    private long m_brokerTransactionBufferSize;
    private byte m_bitField1 = 0;
    private static final byte NP_REPL_MASK = 1;
    private static final byte BROKER_FT_MASK = 2;
    private String m_name;
    private short m_majorVersion;
    private byte m_minorVersion;
    private byte m_pointVersion;
    private int m_buildNumber;
    private short m_flags;
    public static final short BROKER_FC_EVENTS_MASK = 1;
    public static final short BROKER_IS_ENTERPRISE_MASK = 2;
    private int m_clientFCMonitorInterval = -999;

    public BrokerConnectParms() {
    }

    public BrokerConnectParms(long brokerTransactionBufferSize, boolean faultTolerantBroker, boolean npReplUpgrade, ClientConnectParms ccp, int clientDefaultFCMonitorInterval, boolean isEnterprise) {
        this.m_brokerTransactionBufferSize = brokerTransactionBufferSize;
        this.m_version = ccp == null ? (short)0 : (ccp.getVersion() < 4 ? ccp.getVersion() : (short)4);
        if (npReplUpgrade) {
            this.m_bitField1 = (byte)(this.m_bitField1 | 1);
        }
        if (faultTolerantBroker) {
            this.m_bitField1 = (byte)(this.m_bitField1 | 2);
        }
        this.m_name = "SonicMQ/Java";
        this.m_majorVersion = (short)12;
        this.m_minorVersion = 0;
        this.m_pointVersion = (byte)9;
        this.m_buildNumber = 127;
        if (isEnterprise) {
            this.m_flags = (short)(this.m_flags | 2);
        }
        if (ccp != null) {
            if (ccp.supportsBrokerFcEvents()) {
                this.m_flags = (short)(this.m_flags | 1);
            }
            this.m_clientFCMonitorInterval = ccp.getClientFCMonitorInterval();
            this.m_clientFCMonitorInterval = this.m_clientFCMonitorInterval == -1 ? clientDefaultFCMonitorInterval : this.m_clientFCMonitorInterval;
        }
    }

    public long getBrokerTransactionBufferSize() {
        return this.m_brokerTransactionBufferSize;
    }

    public final boolean getFaultTolerantBroker() {
        return (this.m_bitField1 & 2) > 0;
    }

    public boolean getNPReplUpgrade() {
        return (this.m_bitField1 & 1) > 0;
    }

    public boolean supportsBrokerFcEvents() {
        return (this.m_flags & 1) > 0;
    }

    public boolean isEnterpriseEdition() {
        return (this.m_flags & 2) > 0;
    }

    public int getClientFCMonitorInterval() {
        return this.m_clientFCMonitorInterval;
    }

    public static BrokerConnectParms unserialize(DataInput in) throws IOException {
        BrokerConnectParms parms = new BrokerConnectParms();
        short version = in.readShort();
        parms.m_brokerTransactionBufferSize = in.readLong();
        if (version >= 1) {
            parms.m_bitField1 = in.readByte();
        } else if (in.readBoolean()) {
            parms.m_bitField1 = (byte)(parms.m_bitField1 | 2);
        }
        if (version >= 2) {
            parms.m_name = in.readUTF();
            parms.m_majorVersion = in.readShort();
            parms.m_minorVersion = in.readByte();
            parms.m_pointVersion = in.readByte();
            parms.m_buildNumber = in.readInt();
        }
        if (version >= 3) {
            parms.m_flags = in.readShort();
        }
        if (version >= 4) {
            parms.m_clientFCMonitorInterval = in.readInt();
        }
        return parms;
    }

    public void serialize(OutputStream os) throws IOException {
        StreamUtil.writeShort(this.m_version, os);
        StreamUtil.writeLong(this.m_brokerTransactionBufferSize, os);
        if (this.m_version >= 1) {
            StreamUtil.writeByte(this.m_bitField1, os);
        } else {
            StreamUtil.writeBoolean(this.getFaultTolerantBroker(), os);
        }
        if (this.m_version >= 2) {
            if (this.m_name == null) {
                StreamUtil.writeUTF("", os);
            } else {
                StreamUtil.writeUTF(this.m_name, os);
            }
            StreamUtil.writeShort(this.m_majorVersion, os);
            StreamUtil.writeByte(this.m_minorVersion, os);
            StreamUtil.writeByte(this.m_pointVersion, os);
            StreamUtil.writeInt(this.m_buildNumber, os);
        }
        if (this.m_version >= 3) {
            StreamUtil.writeShort(this.m_flags, os);
        }
        if (this.m_version >= 4) {
            StreamUtil.writeInt(this.m_clientFCMonitorInterval, os);
        }
    }

    public static BrokerConnectParms unserialize(InputStream in) throws IOException {
        BrokerConnectParms parms = new BrokerConnectParms();
        short version = StreamUtil.readShort(in);
        parms.m_brokerTransactionBufferSize = StreamUtil.readLong(in);
        if (version >= 1) {
            parms.m_bitField1 = StreamUtil.readByte(in);
        } else if (StreamUtil.readBoolean(in)) {
            parms.m_bitField1 = (byte)(parms.m_bitField1 | 2);
        }
        if (version >= 2) {
            parms.m_name = StreamUtil.readUTF(in);
            parms.m_majorVersion = StreamUtil.readShort(in);
            parms.m_minorVersion = StreamUtil.readByte(in);
            parms.m_pointVersion = StreamUtil.readByte(in);
            parms.m_buildNumber = StreamUtil.readInt(in);
        }
        if (version >= 3) {
            parms.m_flags = StreamUtil.readShort(in);
        }
        if (parms.m_version >= 4) {
            parms.m_clientFCMonitorInterval = StreamUtil.readInt(in);
        }
        return parms;
    }

    public int length() {
        int size = 11;
        size = this.m_name != null ? (size += StringUtil.lengthUTF(this.m_name)) : (size += StringUtil.lengthUTF(""));
        size += 10;
        return size += 4;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Version=" + this.m_version).append(",TXBufferSize=" + this.m_brokerTransactionBufferSize).append(",FT=" + this.getFaultTolerantBroker()).append(",NPReplUpgrade=" + this.getNPReplUpgrade());
        sb.append(",Name=" + this.m_name);
        sb.append(",pdtVers= " + this.m_majorVersion + "." + this.m_minorVersion + "." + this.m_pointVersion + " B " + this.m_buildNumber);
        sb.append(",Flags=" + this.m_flags);
        sb.append(",FCMonitorInt=" + this.m_clientFCMonitorInterval);
        return sb.toString();
    }

    public VersionData getProductVersion() {
        if (this.m_majorVersion == 0) {
            return null;
        }
        return new VersionData(this.m_name, this.m_majorVersion, this.m_minorVersion, this.m_pointVersion, this.m_buildNumber);
    }
}

