/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient.xonce;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import progress.message.msg.IMgram;
import progress.message.zclient.BaseConnection;
import progress.message.zclient.IDebugCallback;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.xonce.MgramFilterSupport;
import progress.message.zclient.xonce.MgramTrace;

public class MgramTraceCallback
implements IDebugCallback {
    private static Class[] m_action_signature = new Class[]{String.class, BaseConnection.class, IMgram.class};
    private static Vector m_capture = new Vector(1000);
    private static int MAX_CAPTURES = 1000;

    @Override
    public void callback(String text, int method, Object params) {
        try {
            switch (method) {
                case 0: 
                case 2: 
                case 100: 
                case 101: 
                case 102: {
                    this.methodx(text, params);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void methodx(String text, Object params) {
        Object[] o = (Object[])params;
        BaseConnection c = (BaseConnection)o[0];
        IMgram m = (IMgram)o[1];
        String[] actions = MgramFilterSupport.match(text, c, m);
        String action = null;
        Object[] methparms = new Object[]{text, c, m};
        for (int i = 0; i < actions.length; ++i) {
            action = actions[i];
            try {
                Method meth = this.getClass().getMethod(action, m_action_signature);
                meth.invoke((Object)this, methparms);
                continue;
            }
            catch (NoSuchMethodException nsme) {
                System.err.println("MgramTraceCallback - unrecognised action:" + action);
                continue;
            }
            catch (Exception e) {
                SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            }
        }
    }

    public void printFully(String text, BaseConnection c, IMgram m) {
        MgramTrace.diagnose(MgramTraceCallback.hhmmssSSS() + ":" + text, c, m, true);
    }

    public void print(String text, BaseConnection c, IMgram m) {
        MgramTrace.diagnose(MgramTraceCallback.hhmmssSSS() + ":" + text, c, m);
    }

    public void dumpStack(String text, BaseConnection c, IMgram m) {
        Thread.dumpStack();
    }

    public void pass(String text, BaseConnection c, IMgram m) {
    }

    public void empty(String text, BaseConnection c, IMgram m) {
    }

    static String hhmmssSSS() {
        Date dt = new Date();
        return new SimpleDateFormat("HH_mm_ss.SSS").format(dt);
    }

    public void captureFullyWithTimestamp(String text, BaseConnection c, IMgram m) {
        String s = MgramTrace.diagnosticString(text, c, m, true);
        if (s == null) {
            return;
        }
        this.addCaptureString(MgramTraceCallback.hhmmssSSS() + ":" + s);
    }

    public void captureWithTimestamp(String text, BaseConnection c, IMgram m) {
        String s = MgramTrace.diagnosticString(text, c, m);
        if (s == null) {
            return;
        }
        this.addCaptureString(MgramTraceCallback.hhmmssSSS() + ":" + s);
    }

    public void printCaptureBuffer(String text, BaseConnection c, IMgram m) {
        MgramTraceCallback.printCaptureBuffer();
    }

    public static void printCaptureBuffer() {
        Object[] c = MgramTraceCallback.getCaptureBuffer();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == null) continue;
            System.out.println(c[i].toString());
        }
    }

    public void captureFully(String text, BaseConnection c, IMgram m) {
        String s = MgramTrace.diagnosticString(text, c, m, true);
        if (s == null) {
            return;
        }
        this.addCaptureString(s);
    }

    public void capture(String text, BaseConnection c, IMgram m) {
        String s = MgramTrace.diagnosticString(text, c, m);
        if (s == null) {
            return;
        }
        this.addCaptureString(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCaptureString(String s) {
        Vector vector = m_capture;
        synchronized (vector) {
            if (m_capture.size() >= MAX_CAPTURES) {
                m_capture.removeElementAt(0);
            }
            m_capture.add(s);
        }
    }

    public static void clearCaptureBuffer() {
        m_capture.clear();
    }

    public static Object[] getCaptureBuffer() {
        return m_capture.toArray();
    }
}

