/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.impl;

import com.sonicsw.blackbird.http.impl.HTTPParseUtil;

public final class HTTPHeader {
    private final String m_headerName;
    private String m_headerValue;
    private String[][] m_tokenized = null;

    HTTPHeader(String headerName, String headerValue) {
        this.m_headerName = headerName;
        this.m_headerValue = headerValue;
    }

    public final String getHeaderName() {
        return this.m_headerName;
    }

    public final String getHeaderValue() {
        return this.m_headerValue;
    }

    public final HTTPHeader addHeaderValue(HTTPHeader header) {
        this.m_headerValue = this.m_headerValue + ", " + header.m_headerValue;
        return this;
    }

    public final HTTPHeader appendToHeaderValue(String value) {
        this.m_headerValue = this.m_headerValue + value;
        return this;
    }

    public final String toString() {
        return this.m_headerName + ":" + " " + this.m_headerValue;
    }

    public boolean containsToken(String token) {
        if (this.m_tokenized == null) {
            this.m_tokenized = HTTPParseUtil.tokenizeHeader(this.m_headerValue);
        }
        for (int i = 0; i < this.m_tokenized.length; ++i) {
            if (this.m_tokenized[i][0] == null) {
                return false;
            }
            if (!this.m_tokenized[i][0].equalsIgnoreCase(token)) continue;
            this.m_tokenized[i][0] = token;
            return true;
        }
        return false;
    }
}

