/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.interceptor;

import com.sonicsw.interceptor.SimpleContext;
import com.sonicsw.interceptor.pointcuts.JMSPointCut;
import progress.message.msg.IMgram;
import progress.message.zclient.ISidebandData;

public class AgentMessageContext
extends SimpleContext
implements JMSPointCut.IJMSMessageContext {
    private IMgram m_msg = null;
    private ISidebandData m_sideband = null;

    public AgentMessageContext(IMgram msg) {
        this.m_msg = msg;
        this.m_sideband = msg.getSidebandDataReadOnly();
    }

    @Override
    public Object getMessage() {
        return this.m_msg;
    }

    @Override
    public String getMessageID() {
        if (this.m_sideband == null) {
            return null;
        }
        return Long.toString(this.m_sideband.getConnectionAndLocalID());
    }

    @Override
    public String getDestination() {
        return this.m_msg.getSubject().getJMSName();
    }

    @Override
    public void setBrokerName(String broker) {
        this.setProperty("BROKER_NAME_ATTR", broker);
    }

    @Override
    public String getBrokerName() {
        return (String)this.getProperty("BROKER_NAME_ATTR");
    }

    @Override
    public void setEndpointURL(String endpoint) {
        this.setProperty("ENDPOINT_URL_ATTR", endpoint);
    }

    @Override
    public String getEndpointURL() {
        return (String)this.getProperty("ENDPOINT_URL_ATTR");
    }

    @Override
    public String getMessageProducer() {
        return (String)this.getProperty("MESSAGE_PRODUCER_ATTR");
    }

    @Override
    public void setMessageProducer(String producer) {
        this.setProperty("MESSAGE_PRODUCER_ATTR", producer);
    }

    @Override
    public String getMessageConsumer() {
        return (String)this.getProperty("MESSAGE_CONSUMER_ATTR");
    }

    @Override
    public void setMessageConsumer(String consumer) {
        this.setProperty("MESSAGE_CONSUMER_ATTR", consumer);
    }

    @Override
    public Object getProperty(String name) {
        Object ret = super.getProperty(name);
        if (ret == null && this.m_sideband != null) {
            ret = this.m_sideband.getProperty(name);
        }
        return ret;
    }

    @Override
    public boolean containsProperty(String name) {
        boolean ret = super.containsProperty(name);
        if (!ret && this.m_sideband != null) {
            ret = this.m_sideband.getProperty(name) == null;
        }
        return ret;
    }
}

