/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.interceptor.impls.actional;

import com.actional.lg.interceptor.sdk.ClientInteraction;
import com.actional.lg.interceptor.sdk.IMsgFieldEvaluator;
import com.actional.lg.interceptor.sdk.Interaction;
import com.actional.lg.interceptor.sdk.MsgFieldTransportEvaluator;
import com.actional.lg.interceptor.sdk.ServerInteraction;
import com.actional.lg.interceptor.sdk.SiteStub;
import com.actional.lg.interceptor.sdk.helpers.InterHelpBase;
import com.sonicsw.interceptor.impls.actional.Config;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import progress.message.broker.MgramURLHelper;
import progress.message.jimpl.Message;
import progress.message.msg.IMgram;
import progress.message.util.DraDestUtil;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISidebandData;

public class InteractionHelper {
    public static void setPayload(Interaction interaction, IMgram msg, String payloadType) {
        int type = 0;
        if (payloadType != null) {
            if (payloadType.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR_HEADER")) {
                type = 1;
            } else if (payloadType.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR_BODY")) {
                type = 2;
            } else if (payloadType.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR_ALL")) {
                type = 3;
            }
        }
        if (type == 1 || type == 3) {
            InteractionHelper.writeTransportHeaders(msg, interaction);
        }
        if (type == 2) {
            if (!interaction.getIncludeMsg()) {
                type = 0;
            }
        } else if (type == 3 && !interaction.getIncludeMsg()) {
            type = 1;
        }
        if (type == 2 || type == 3) {
            InteractionHelper.traceInteraction("payload is needed", interaction);
            if (msg != null && msg.hasBody()) {
                switch (msg.getSidebandDataReadOnly().getBodyType()) {
                    case 6: 
                    case 7: {
                        progress.message.zclient.Message zm = new progress.message.zclient.Message(msg.getRawBody());
                        try {
                            interaction.setPayload(zm.readUTF().getBytes("UTF-8"));
                        }
                        catch (Exception ex) {
                            Config.logMessage("Unable to capture the payload: " + ex.getMessage());
                        }
                        break;
                    }
                }
            }
        }
        interaction.setSize(msg != null ? (long)msg.networkLength() : 0L);
    }

    private static void writeTransportHeaders(IMgram msg, Interaction inter) {
        if (inter == null) {
            return;
        }
        if (msg == null) {
            return;
        }
        if (!msg.hasSidebandData()) {
            return;
        }
        ISidebandData sideband = msg.getSidebandDataReadOnly();
        Hashtable sidebandProperties = sideband.getProperties();
        HashMap<String, String> m = new HashMap<String, String>();
        Enumeration iter = sidebandProperties.keys();
        while (iter.hasMoreElements()) {
            String header = (String)iter.nextElement();
            if ("LG_Header".equals(header) || "LG_PARENT_SITE_STUB".equals(header) || "LG_Header_Producer_PeerAddress".equals(header)) continue;
            String val = null;
            Object property = sidebandProperties.get(header);
            val = property instanceof String ? (String)property : (property instanceof Boolean ? ((Boolean)property).toString() : (property instanceof Number ? ((Number)property).toString() : "<unknown>"));
            m.put(header.toLowerCase(), val);
        }
        int mode = Message.getJMSDeliveryMode(msg.isJMSPersistent(), msg.isDiscardable(), msg.isNonPersistentReplicated());
        m.put("jmsdeliverymode", Integer.toString(mode));
        m.put("jmsredelivered", Boolean.toString(msg.isSuccessor()));
        m.put("jmsexpiration", Long.toString(msg.getTTE()));
        m.put("jmstimestamp", Long.toString(sideband.getTimestamp()));
        m.put("jmspriority", Integer.toString(msg.getPriority()));
        m.put("jmsdestination", msg.getSubject().getJMSName());
        String val = null;
        val = sideband.getReplyTo();
        if (val != null) {
            m.put("jmsreplyto", val);
        }
        if ((val = Envelope.getMessageID(msg)) != null) {
            m.put("jmsmessageid", val);
        }
        if ((val = sideband.getCorrelationID()) != null) {
            m.put("jmscorrelationid", val);
        }
        if ((val = sideband.getType()) != null) {
            m.put("jmstype", sideband.getType());
        }
        if (!m.isEmpty()) {
            MsgFieldTransportEvaluator transportEval = new MsgFieldTransportEvaluator(m);
            inter._addMsgFieldEvaluator((IMsgFieldEvaluator)transportEval);
        }
    }

    private static boolean skip(IMgram msg) {
        String remoteNode;
        boolean skip = false;
        String string = remoteNode = msg.forRemoteNode(Config.BROKER_ROUTING_NODE_NAME) ? msg.getRouting() : null;
        if (remoteNode != null) {
            skip = MgramURLHelper.isValidRemoteHttpNode(remoteNode) || DraDestUtil.isSubjectURL(msg.getSubject());
        }
        return skip;
    }

    public static ServerInteraction beginServerInteractionOnReceived(IMgram msg) {
        if (InteractionHelper.skip(msg)) {
            return null;
        }
        ServerInteraction si = ServerInteraction.begin();
        try {
            String lgHeader = (String)msg.getSidebandDataReadOnly().getProperty("LG_Header");
            if (lgHeader != null) {
                InterHelpBase.readHeader((String)lgHeader, (ServerInteraction)si);
            }
        }
        catch (Exception e) {
            Config.logMessage(e);
        }
        return si;
    }

    public static void addParentInteractionToMessage(ServerInteraction si, IMgram msg) {
        SiteStub stub = null;
        try {
            stub = si.split();
            Hashtable properties = msg.getSidebandData().getProperties();
            properties.remove("LG_Header");
            Object esbFault = properties.remove("Actional.Failure");
            if (esbFault != null && esbFault instanceof String) {
                si.setFailure((String)esbFault);
            }
            properties.put("LG_PARENT_SITE_STUB", stub.serializeAsBytes());
            msg.setInstrumented(true);
            msg.getSidebandData().setProperties(properties);
        }
        catch (Exception ex) {
            Config.logMessage(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerInteraction resumeServerInteractionOnDelivery(IMgram msg) {
        ServerInteraction si = null;
        byte[] stub = (byte[])msg.getSidebandDataReadOnly().getProperty("LG_PARENT_SITE_STUB");
        if (stub != null) {
            try {
                si = ServerInteraction.begin((SiteStub)((SiteStub)SiteStub.deserialize((byte[])stub)));
            }
            catch (IOException ioe) {
                try {
                    ByteArrayInputStream bis;
                    SiteStub parent = null;
                    ByteArrayInputStream byteArrayInputStream = bis = new ByteArrayInputStream(stub);
                    synchronized (byteArrayInputStream) {
                        ObjectInputStream is = new ObjectInputStream(bis);
                        parent = (SiteStub)is.readObject();
                        is.close();
                        bis.close();
                    }
                    si = ServerInteraction.begin((SiteStub)parent);
                }
                catch (Exception ex) {
                    Config.logMessage(ex);
                }
            }
            catch (Exception ex) {
                Config.logMessage(ex);
            }
        }
        return si;
    }

    public static void populateInteraction(Interaction interaction, String peerAddress, String peerType, String serviceURL, String groupName, String serviceName, String opName) {
        interaction.setOneWay(true);
        if (peerAddress != null) {
            interaction.setPeerAddr(peerAddress);
            if (peerType != null) {
                if (peerType.equalsIgnoreCase("PEER_TYPE_QUEUE")) {
                    interaction.setPeerType((short)-256);
                } else if (peerType.equalsIgnoreCase("PEER_TYPE_TOPIC")) {
                    interaction.setPeerType((short)-250);
                }
            }
        }
        if (serviceURL != null) {
            interaction.setUrl(serviceURL);
        }
        if (groupName != null) {
            interaction.setGroupName(groupName);
        }
        if (serviceName != null) {
            interaction.setServiceName(serviceName);
        }
        if (opName != null) {
            interaction.setOpName(opName);
        }
        interaction.setMsgField("RoutingNodeName", Config.BROKER_ROUTING_NODE_NAME, true);
        interaction.setMsgField("BrokerName", Config.BROKER_NAME, true);
    }

    public static void writeLGHeaderToMessage(ClientInteraction ci, IMgram msg) {
        try {
            String correlationHeader = InterHelpBase.writeHeader((ClientInteraction)ci);
            Hashtable properties = msg.getSidebandData().getProperties();
            properties.put("LG_Header", correlationHeader);
            properties.remove("LG_PARENT_SITE_STUB");
            msg.setInstrumented(false);
            msg.getSidebandData().setProperties(properties);
        }
        catch (Exception ex) {
            Config.logMessage(ex);
        }
    }

    public static void traceInteraction(String tracePrefix, Interaction interaction) {
        if (!Config.isInterceptorDebugEnabled()) {
            return;
        }
        String intType = "";
        String intID = "";
        if (interaction == null) {
            Config.logDebugMessage("traceInteraction called on a null Interaction");
            return;
        }
        intType = interaction instanceof ServerInteraction ? "SI" : "CI";
        intID = interaction.getInteractionID();
        StringBuffer msgBuffer = new StringBuffer();
        msgBuffer.append(tracePrefix).append(" ").append(intType).append("(").append(intID).append(") on thread: ").append(Thread.currentThread().getName());
        if (interaction != null) {
            msgBuffer.append(" ==>");
            msgBuffer.append(" PeerAddr: [ " + interaction.getPeerAddr());
            msgBuffer.append(" ] URL: [ " + interaction.getUrl());
            msgBuffer.append(" ] Type: [ " + interaction.getSvcType());
            msgBuffer.append(" ] Flow ID: [ " + interaction.getFlowID());
            msgBuffer.append(" ] Op ID: [ " + interaction.getOpID());
            msgBuffer.append(" ] Locus ID: [ " + interaction.getParentID());
            msgBuffer.append(" ] Chain ID: [ " + interaction.getChainID());
            msgBuffer.append(" ] OneWay: [ " + interaction.getOneWay());
            msgBuffer.append(" ] isFault: [ " + (interaction.getFailure() != null));
            msgBuffer.append(" ] G: " + interaction.getGroupName());
            msgBuffer.append(" S: " + interaction.getServiceName());
            msgBuffer.append(" O: " + interaction.getOpName());
        }
        Config.logDebugMessage(msgBuffer.toString());
    }
}

