/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.ssl;

import com.sonicsw.security.ssl.KeyStoreHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class KeyTool {
    private static final String _usage = "\nUsage:\n\n\tKeyTool -import certs -ca <ca directory path> -store <keystore> -storepass <storepass> -storetype <storetype>\nor\n\tKeyTool -import key -alias <key_alias> -keypass <keypass> [-pkcs7 <pkcs7 path> -pkcs8 <pkcs8 path> | -pkcs12 <pkcs12 path>] -store <keystore> -storepass <storepass> -storetype <storetype>";

    private static final void printUsage(String err) {
        System.err.println(err + _usage);
    }

    public static void main(String[] argv) {
        String importType = null;
        String caDir = null;
        String alias = "sonic";
        String keyPass = null;
        String pkcs7 = null;
        String pkcs8 = null;
        String pkcs12 = null;
        String storeLocation = null;
        String storeType = "JKS";
        String storePassword = null;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if ("-import".equals(arg)) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    KeyTool.printUsage("Error: missing import type: ");
                    System.exit(1);
                }
                importType = argv[++i];
                continue;
            }
            if ("-ca".equals(arg)) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    KeyTool.printUsage("Error: missing CA directory: ");
                    System.exit(1);
                }
                caDir = argv[++i];
                continue;
            }
            if ("-alias".equals(arg)) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    KeyTool.printUsage("Error: missing key entry alias: ");
                    System.exit(1);
                }
                alias = argv[++i];
                continue;
            }
            if ("-keypass".equals(arg)) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    KeyTool.printUsage("Error: missing key entry password: ");
                    System.exit(1);
                }
                keyPass = argv[++i];
                continue;
            }
            if ("-pkcs7".equals(arg)) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    KeyTool.printUsage("Error: missing PKCS7 certificate chain file: ");
                    System.exit(1);
                }
                pkcs7 = argv[++i];
                continue;
            }
            if ("-pkcs8".equals(arg)) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    KeyTool.printUsage("Error: missing PKCS8 private key file: ");
                    System.exit(1);
                }
                pkcs8 = argv[++i];
                continue;
            }
            if ("-pkcs12".equals(arg)) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    KeyTool.printUsage("Error: missing PKCS12 file: ");
                    System.exit(1);
                }
                pkcs12 = argv[++i];
                continue;
            }
            if ("-store".equals(arg)) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    KeyTool.printUsage("Error: missing keystore/truststore location: ");
                    System.exit(1);
                }
                storeLocation = argv[++i];
                continue;
            }
            if ("-storepass".equals(arg)) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    KeyTool.printUsage("Error: missing keystore/truststore password: ");
                    System.exit(1);
                }
                storePassword = argv[++i];
                continue;
            }
            if ("-storetype".equals(arg)) {
                if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                    KeyTool.printUsage("Error: missing keystore/truststore type: ");
                    System.exit(1);
                }
                storeType = argv[++i];
                continue;
            }
            KeyTool.printUsage("Error: invalid argument - " + arg + ": ");
            System.exit(1);
        }
        boolean importKey = false;
        if (importType == null) {
            KeyTool.printUsage("Error: import type must be specified: ");
            System.exit(1);
        } else if ("certs".equalsIgnoreCase(importType)) {
            if (caDir == null) {
                KeyTool.printUsage("Error: CA directory must be specified to import certificate(s) to truststore: ");
                System.exit(1);
            }
        } else if ("key".equalsIgnoreCase(importType)) {
            if (keyPass == null) {
                KeyTool.printUsage("Error: key password must be specified to import private key to keystore: ");
                System.exit(1);
            }
            if ((pkcs7 == null || pkcs8 == null) && pkcs12 == null) {
                KeyTool.printUsage("Error: Either PKCS7 and PKCS8 or PKCS12 must be specified to import private key to keystore: ");
                System.exit(1);
            }
            if ((pkcs7 != null || pkcs8 != null) && pkcs12 != null) {
                KeyTool.printUsage("Error: Either PKCS7 and PKCS8 or PKCS12 can be specified to import private key to keystore: ");
                System.exit(1);
            }
            importKey = true;
        } else {
            KeyTool.printUsage("Error: invalid import type - " + importType + ": ");
            System.exit(1);
        }
        KeyStore store = null;
        char[] password = null;
        if (storeLocation == null) {
            KeyTool.printUsage("Error: keystore or truststore location must be specified: ");
            System.exit(1);
        } else {
            try {
                store = KeyStore.getInstance(storeType);
            }
            catch (KeyStoreException ex) {
                System.err.println("Error: unable to create a keystore or truststore of type " + storeType + ": " + ex.getMessage());
                System.exit(1);
            }
            if (storePassword != null) {
                password = storePassword.toCharArray();
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(storeLocation.trim());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            try {
                store.load(fis, password);
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex) {
                System.err.println("Error: unable to load the keystore or truststore from " + storeLocation + ": " + ex.getMessage());
                System.exit(1);
            }
        }
        try {
            if (importKey) {
                if (pkcs7 != null) {
                    KeyStoreHelper.keyStoreFromPKCS7AndPKCS8(pkcs7, pkcs8, true, keyPass, alias, store);
                } else {
                    KeyStoreHelper.loadKeyStoreFromPKCS12(pkcs12, keyPass, alias, store);
                }
            } else {
                X509Certificate[] caCerts = KeyStoreHelper.loadCertificatesFromDirectory(caDir);
                KeyStoreHelper.trustStoreFromCertificates(caCerts, store);
            }
            FileOutputStream fos = new FileOutputStream(storeLocation.trim());
            store.store(fos, password);
            fos.close();
            KeyTool.listStore(storeLocation, storePassword, storeType, keyPass);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static final void listStore(String store, String storePass, String storeType, String keyPass) {
        try {
            KeyStore ks = KeyStore.getInstance(storeType);
            ks.load(new FileInputStream(store), storePass.toCharArray());
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (ks.isKeyEntry(alias)) {
                    System.out.println("Key entry for alias \"" + alias + "\":\nkey info: " + ks.getKey(alias, keyPass.toCharArray()));
                    Certificate[] chain = ks.getCertificateChain(alias);
                    for (int i = 0; i < chain.length; ++i) {
                        System.out.println("cert[" + i + "]:\n" + chain[i]);
                    }
                    continue;
                }
                System.out.println("CA entry for alias \"" + alias + "\":\n" + ks.getCertificate(alias));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

