/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.receiver.fsm;

import com.sonicsw.net.http.ws.WSHttpOutRequest;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.rm.common.OfferContext;
import com.sonicsw.ws.rm.common.RMEvent;
import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.ws.rm.common.RMSequence;
import com.sonicsw.ws.rm.common.RMSequenceSupport;
import com.sonicsw.ws.rm.common.ReliableMessageWrapper;
import com.sonicsw.ws.rm.common.SequenceCapsule;
import com.sonicsw.ws.rm.policy.RMPolicy;
import com.sonicsw.ws.rm.protocol.Accept;
import com.sonicsw.ws.rm.protocol.AcksTo;
import com.sonicsw.ws.rm.protocol.Constants;
import com.sonicsw.ws.rm.protocol.ElementCreator;
import com.sonicsw.ws.rm.protocol.Expires;
import com.sonicsw.ws.rm.protocol.Identifier;
import com.sonicsw.ws.rm.protocol.Offer;
import com.sonicsw.ws.rm.protocol.ReliableHeaders;
import com.sonicsw.ws.rm.protocol.SequenceFault;
import com.sonicsw.ws.rm.protocol.prAccessor;
import com.sonicsw.ws.rm.receiver.fsm.CreateInboundSequenceEvent;
import com.sonicsw.ws.rm.receiver.fsm.IReceiveState;
import com.sonicsw.ws.rm.receiver.fsm.InboundAckRetransmitTimeoutEvent;
import com.sonicsw.ws.rm.receiver.fsm.InboundDataEvent;
import com.sonicsw.ws.rm.receiver.fsm.InboundExpiresEvent;
import com.sonicsw.ws.rm.receiver.fsm.InboundInactivityTimeoutEvent;
import com.sonicsw.ws.rm.receiver.fsm.RMReceiveSequence;
import com.sonicsw.ws.rm.receiver.fsm.RequestAckEvent;
import com.sonicsw.ws.rm.receiver.fsm.RequestAsynchronousSendEvent;
import com.sonicsw.ws.rm.receiver.fsm.RequestFaultEvent;
import com.sonicsw.ws.rm.receiver.fsm.TerminateInboundSequenceEvent;
import com.sonicsw.ws.rm.sender.fsm.InitialSendState;
import com.sonicsw.ws.rm.sender.fsm.RMSendSequence;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jms.Destination;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.types.URI;

public abstract class BaseReceiveState
implements IReceiveState {
    @Override
    public void expiresTimeout(InboundExpiresEvent e) {
        this.traceFSM(e);
        RMSequenceSupport support = e.getSequence();
        support.faultSequence(this.makeTerminateFault(support));
        RMManager rmm = RMManager.getRMManager();
        rmm.removeRMSequenceSupport(support);
    }

    @Override
    public void ackRetransmitTimeout(InboundAckRetransmitTimeoutEvent e) {
        this.traceFSM(e);
        RequestAckEvent evt = new RequestAckEvent();
        evt.setContext(e.getContext());
        evt.setSequence(e.getSequence());
        e.getSequence().enqueue(evt, 12);
    }

    @Override
    public void inactivityTimeout(InboundInactivityTimeoutEvent e) {
        this.traceFSM(e);
        RMSequenceSupport support = e.getSequence();
        support.faultSequence(this.makeTerminateFault(support));
        RMManager rmm = RMManager.getRMManager();
        rmm.removeRMSequenceSupport(support);
    }

    @Override
    public void terminateSequence(TerminateInboundSequenceEvent e) {
        this.traceFSM(e);
        RMSequenceSupport support = e.getSequence();
        RMManager rmm = RMManager.getRMManager();
        rmm.removeRMSequenceSupport(support);
    }

    @Override
    public void faultSequence(RequestFaultEvent e) {
        this.traceFSM(e);
        RMSequenceSupport support = e.getSequence();
        support.faultSequence(this.makeFault(support, e.getCode(), e.getSubCode(), e.getReason()));
        RMManager rmm = RMManager.getRMManager();
        rmm.removeRMSequenceSupport(support);
    }

    @Override
    public void receive(InboundDataEvent e) {
        this.traceFSM(e);
        MessageContext mc = e.getContext();
        Constants rmc = (Constants)mc.getProperty("COM_SONIC_WS_RM_CONSTANTS");
        RMPolicy policy = (RMPolicy)e.getContext().getProperty("com.sonicsw.ws.rm.policy.RMPolicy");
        boolean mustBeExplicitCreate = true;
        if (policy != null && !policy.getSequenceCreation()) {
            mustBeExplicitCreate = false;
        }
        SequenceCapsule capsule = (SequenceCapsule)mc.getProperty("com.sonicsw.ws.rm.common.RxSequenceCapsule");
        RMReceiveSequence support = null;
        support = mustBeExplicitCreate ? this.getReceiveSequence(mc, capsule.getId()) : this.registerReceiveSequence(mc, null, capsule.getId(), true, null, null, null);
        if (support == null) {
            this.faultAccordingToWSA(SequenceFault.makeUnknownSequenceFault(rmc, capsule.getId()), mc, rmc, capsule);
            return;
        }
        support.getSequenceState().setLastActivity(System.currentTimeMillis());
        if (support.getSequenceState().getDesignatedLastMessageNumber() > 0L && capsule.getNr() > support.getSequenceState().getDesignatedLastMessageNumber()) {
            AcksTo a2 = support.getSequenceState().getAcksTo();
            String transportURL = a2.getAddress().getAddress().toString();
            if (com.sonicsw.ws.addressing.AddressingUtils.isAnonymousURI(transportURL)) {
                this.faultAccordingToWSA(SequenceFault.makeLastMessageNumberExceededFault(rmc, capsule.getId()), mc, rmc, capsule);
                return;
            }
            RequestFaultEvent evt = new RequestFaultEvent();
            evt.setContext(e.getContext());
            evt.setSequence(e.getSequence());
            evt.setCode(prAccessor.getString("CODE_SENDER"));
            evt.setReason(prAccessor.getString("REASON_LAST_MESSAGE_NUMBER_EXCEEDED"));
            evt.setSubCode("LastMessageNumberExceeded");
            e.getSequence().enqueue(evt, 12);
            mc.setProperty("COM_SONIC_RM_REMOVE_MESSAGE", (Object)new Boolean(true));
            return;
        }
        ReliableMessageWrapper rmw = this.createReceiveMessageWrapper(mc, capsule);
        boolean discard = support.getSequenceState().insertReceivedMessage(rmw);
        if (discard) {
            mc.setProperty("COM_SONIC_RM_REMOVE_MESSAGE", (Object)new Boolean(true));
            return;
        }
        support.setAcksTransmissionCount(0L);
    }

    private void faultAccordingToWSA(AxisFault af, MessageContext mc, Constants rmc, SequenceCapsule capsule) {
        try {
            if (mc.getPastPivot()) {
                return;
            }
            AddressingHeaders headers = (AddressingHeaders)mc.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
            SOAPEnvelope envelope = ElementCreator.createSimpleEnvelope(AddressingUtils.getFaultActionURI(), null, mc.getSOAPConstants(), rmc);
            ElementCreator.reverseAddressesForFaultEnvelope(envelope, headers);
            SOAPBody sb = (SOAPBody)envelope.getBody();
            SOAPFault ft = (SOAPFault)sb.addFault();
            ft.setFault(af);
            SequenceFault.toSequenceFaultHeader(rmc, envelope, capsule.getId(), "UnknownSequence");
            BaseReceiveState.createDummyMessage(envelope, mc);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public AxisFault makeTerminateFault(RMSequenceSupport support) {
        return this.makeFault(support, prAccessor.getString("CODE_RECEIVER"), "SequenceTerminated", prAccessor.getString("REASON_TERMINATED"));
    }

    public AxisFault makeFault(RMSequenceSupport support, String code, String sub, String reason) {
        AxisFault flt = new AxisFault();
        Constants rmc = support.getConstants();
        QName qn = new QName(rmc.getNSURI(), "Identifier", "wsrm");
        flt.setFaultCode(new QName(code));
        flt.addFaultSubCode(new QName(rmc.getNSURI(), sub, "wsrm"));
        flt.clearFaultDetails();
        flt.addFaultDetail(qn, support.getId());
        flt.setFaultReason(reason);
        return flt;
    }

    @Override
    public void createSequence(CreateInboundSequenceEvent e) {
        this.traceFSM(e);
        try {
            RMReceiveSequence support;
            MessageContext mc = e.getContext();
            Message m = mc.getRequestMessage();
            AddressingHeaders headers = (AddressingHeaders)mc.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
            MessageID mid = headers.getMessageID();
            Constants RMConstants = (Constants)e.getContext().getProperty("COM_SONIC_WS_RM_CONSTANTS");
            if (mid == null) {
                if (DebugObjects.getReceiverFSMDebug().getDebug()) {
                    DebugObjects.getReceiverFSMDebug().debug(this.fdate() + ": Refusing sequence, no wsa:MessageID present");
                }
                this.refuseSequence(mc, headers);
                return;
            }
            EndpointReference r2 = headers.getReplyTo();
            if (r2 == null) {
                r2 = headers.getFrom();
            }
            if (r2 == null) {
                r2 = new EndpointReference(new Address(AddressingUtils.getAnonymousRoleURI()));
            }
            if ((support = RMManager.getRMManager().getRMReceiveSequenceSupportByRequestMid(r2, mid)) == null) {
                ReliableHeaders rh = new ReliableHeaders();
                rh.fromSOAPEnvelope(m.getSOAPEnvelope());
                if (RMConstants.getNSURI().equalsIgnoreCase("http://schemas.xmlsoap.org/ws/2005/02/rm") && rh.getCreateSequence().getAcksTo() == null) {
                    if (DebugObjects.getReceiverFSMDebug().getDebug()) {
                        DebugObjects.getReceiverFSMDebug().debug(this.fdate() + ": Refusing sequence there is no acksTo present.");
                    }
                    this.refuseSequence(mc, headers);
                    return;
                }
                AcksTo acks2 = rh.getCreateSequence().getAcksTo();
                try {
                    acks2.getAddress().getAddress().toString();
                }
                catch (Exception e2) {
                    if (DebugObjects.getReceiverFSMDebug().getDebug()) {
                        DebugObjects.getReceiverFSMDebug().debug(this.fdate() + ": Refusing sequence acksTo malformed.");
                    }
                    this.refuseSequence(mc, headers);
                    return;
                }
                Offer offer = rh.getCreateSequence().getOffer();
                String returnId = null;
                if (offer != null) {
                    Identifier offered = offer.getIdentifier();
                    if (RMManager.getRMManager().getRMSendSequenceSupport(offered.getIdentifier()) != null) {
                        if (DebugObjects.getReceiverFSMDebug().getDebug()) {
                            DebugObjects.getReceiverFSMDebug().debug(this.fdate() + ": Refusing sequence offered identifier:" + offered.getIdentifier() + " is in use.");
                        }
                        this.refuseSequence(mc, headers);
                        return;
                    }
                    Destination dest = (Destination)mc.getProperty("DEST");
                    long negotiatedExpires = Long.MAX_VALUE;
                    Expires ex = offer.getExpires();
                    if (ex != null) {
                        negotiatedExpires = ex.getExpires();
                    }
                    RMSendSequence rms = new InitialSendState().registerSendSequence(r2, offered.getIdentifier(), e.getContext(), (RMPolicy)e.getContext().getProperty("com.sonicsw.ws.rm.policy.RMPolicy"), false, dest, negotiatedExpires, true);
                    rms.setLocallyHomed(true);
                    rms.getSequenceState().setEndpointReference(r2);
                    returnId = offered.getIdentifier();
                }
                String id = ElementCreator.generateUUID();
                Expires ex = rh.getCreateSequence().getExpires();
                long now = System.currentTimeMillis();
                Date exd = null;
                if (ex != null && ex.getExpires() != Long.MAX_VALUE) {
                    long expires = now + ex.getExpires();
                    exd = new Date(expires);
                } else {
                    RMPolicy p = (RMPolicy)mc.getProperty("com.sonicsw.ws.rm.policy.RMPolicy");
                    if (p != null && p.getExpires() != null) {
                        exd = p.getExpires();
                    }
                }
                support = this.registerReceiveSequence(e.getContext(), mid, id, false, acks2, exd, returnId);
                support.getSequenceState().setClientAssigned(false);
            }
            WSHttpOutRequest request = (WSHttpOutRequest)e.getContext().getProperty("com.sonicsw.net.http.HttpOutRequest");
            try {
                SOAPEnvelope se = null;
                if (RMConstants.getNSURI().equalsIgnoreCase("http://schemas.xmlsoap.org/ws/2004/03/rm")) {
                    AddressingHeaders ah = new AddressingHeaders((javax.xml.soap.SOAPEnvelope)m.getSOAPEnvelope());
                    se = ElementCreator.createCreateSequenceResponseEnvelope(support.getId(), ah, e.getContext().getSOAPConstants(), RMConstants);
                } else {
                    EndpointReference sacks22 = null;
                    if (support.getSequenceState().getReturnSequenceIdentifier() != null) {
                        sacks22 = support.getSequenceState().getEndpointReference();
                    }
                    AddressingHeaders ah = new AddressingHeaders((javax.xml.soap.SOAPEnvelope)m.getSOAPEnvelope());
                    se = ElementCreator.createCreateSequenceResponseEnvelope(sacks22, -1L, support.getId(), ah, e.getContext().getSOAPConstants(), RMConstants);
                }
                Message dummy = null;
                if (r2 == null || com.sonicsw.ws.addressing.AddressingUtils.isAnonymousURI(r2.getAddress().toString())) {
                    dummy = new Message((Object)se);
                } else {
                    RequestAsynchronousSendEvent evt = new RequestAsynchronousSendEvent();
                    evt.setContext(mc);
                    evt.setEnvelope(se);
                    support.enqueue(evt, 12);
                }
                e.getContext().setResponseMessage(dummy);
                e.getContext().setPastPivot(true);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void refuseSequence(MessageContext mc, AddressingHeaders headers) throws Exception {
        Constants RMConstants = (Constants)mc.getProperty("COM_SONIC_WS_RM_CONSTANTS");
        SOAPEnvelope envelope = ElementCreator.createSimpleEnvelope(AddressingUtils.getFaultActionURI(), null, mc.getSOAPConstants(), RMConstants);
        ElementCreator.reverseAddressesForFaultEnvelope(envelope, headers);
        AxisFault af = this.makeSequenceRefusedFault(RMConstants, mc.getSOAPConstants());
        SOAPBody sb = (SOAPBody)envelope.getBody();
        SOAPFault ft = (SOAPFault)sb.addFault();
        ft.setFault(af);
        BaseReceiveState.createDummyMessage(envelope, mc);
    }

    private static void createDummyMessage(SOAPEnvelope envelope, MessageContext mc) {
        Message dummy = new Message((Object)envelope);
        mc.setResponseMessage(dummy);
        mc.setPastPivot(true);
    }

    public AxisFault makeSequenceRefusedFault(Constants rmc, SOAPConstants sc) {
        AxisFault refusedFault = new AxisFault();
        if (sc instanceof SOAP11Constants) {
            refusedFault.setFaultCode(new QName(rmc.getNSURI(), "CreateSequenceRefused", "wsrm"));
        } else {
            refusedFault.setFaultCode(prAccessor.getString("CODE_SENDER"));
            refusedFault.addFaultSubCode(new QName(rmc.getNSURI(), "CreateSequenceRefused", "wsrm"));
        }
        refusedFault.clearFaultDetails();
        refusedFault.setFaultString(prAccessor.getString("REASON_SEQUENCE_REFUSED"));
        return refusedFault;
    }

    public RMReceiveSequence getReceiveSequence(MessageContext mc, String id) {
        RMManager rmm = RMManager.getRMManager();
        return rmm.getRMReceiveSequenceSupport(id);
    }

    public RMReceiveSequence registerReceiveSequence(MessageContext mc, MessageID mid, String id, boolean clientAssigned, AcksTo a2, Date expires, String returnId) {
        RMReceiveSequence support = this.getReceiveSequence(mc, id);
        if (support == null) {
            support = new RMReceiveSequence();
            RMSequence se = new RMSequence();
            Constants RMConstants = (Constants)mc.getProperty("COM_SONIC_WS_RM_CONSTANTS");
            SOAPConstants soapConstants = mc.getSOAPConstants();
            Identifier ide = new Identifier(RMConstants);
            ide.setIdentifier(id);
            se.setSequenceIdentifier(ide);
            se.setReturnSequenceIdentifier(returnId);
            RMPolicy p = (RMPolicy)mc.getProperty("com.sonicsw.ws.rm.policy.RMPolicy");
            if (p == null) {
                p = new RMPolicy();
                p.setInactivityTimeout(0L);
            }
            se.setPolicy(p);
            se.setClientAssigned(clientAssigned);
            se.setRMConstants(RMConstants);
            AddressingHeaders headers = (AddressingHeaders)mc.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
            se.setEndpointReference(new EndpointReference((URI)headers.getTo()));
            se.setAcksTo(a2);
            se.setExpires(expires);
            se.setLastActivity(System.currentTimeMillis());
            se.getReorderBuffer().setConditionListener(support);
            support.setSequenceState(se);
            support.setConstants(RMConstants);
            support.setSOAPConstants(soapConstants);
            support.setWSANS((String)mc.getProperty("addressing.namespace.URI"));
            support.setRequestMessageID(mid);
            EndpointReference r2 = headers.getReplyTo();
            if (r2 == null) {
                r2 = headers.getFrom();
            }
            if (r2 == null) {
                try {
                    r2 = new EndpointReference(new Address(AddressingUtils.getAnonymousRoleURI()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            support.setRequestReplyTo(r2);
            RMManager.getRMManager().addRMSequenceSupport(support);
        }
        return support;
    }

    public RMReceiveSequence constructReceiveSequenceFromAcceptedOffer(MessageContext mc, OfferContext offer, Accept accept, String returnId) {
        RMReceiveSequence support = new RMReceiveSequence();
        RMSequence se = new RMSequence();
        Constants RMConstants = (Constants)mc.getProperty("COM_SONIC_WS_RM_CONSTANTS");
        Identifier ide = new Identifier(RMConstants);
        ide.setIdentifier(offer.getId());
        se.setSequenceIdentifier(ide);
        se.setReturnSequenceIdentifier(returnId);
        se.setRMConstants(RMConstants);
        se.setEndpointReference(offer.getEndpoint());
        RMPolicy p = (RMPolicy)mc.getProperty("com.sonicsw.ws.rm.policy.RMPolicy");
        if (p == null) {
            p = new RMPolicy();
        }
        se.setPolicy(p);
        se.setClientAssigned(false);
        if (offer.getExpires() > 0L) {
            long expire = offer.getExpires();
            if (expire != Long.MAX_VALUE) {
                expire += System.currentTimeMillis();
            }
            se.setExpires(new Date(expire));
        }
        se.setAcksTo(accept.getAcksTo());
        support.setSequenceState(se);
        support.setConstants((Constants)mc.getProperty("COM_SONIC_WS_RM_CONSTANTS"));
        support.setSOAPConstants(mc.getSOAPConstants());
        support.setWSANS((String)mc.getProperty("addressing.namespace.URI"));
        se.getReorderBuffer().setConditionListener(support);
        RMManager.getRMManager().addRMSequenceSupport(support);
        return support;
    }

    public ReliableMessageWrapper createReceiveMessageWrapper(MessageContext mc, SequenceCapsule cap) {
        ReliableMessageWrapper rmc = new ReliableMessageWrapper();
        rmc.setLastProcessedTime(System.currentTimeMillis());
        rmc.setMsgContext(mc);
        rmc.setSequenceInfo(cap);
        return rmc;
    }

    protected String fdate() {
        Date dt = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("hh:mm:ss");
        String str = formatter.format(dt);
        return str;
    }

    protected void traceFSM(RMEvent e) {
        RMSequenceSupport rmss = e.getSequence();
        String seqStr = "";
        if (rmss != null) {
            seqStr = rmss.toString();
        }
        if (DebugObjects.getReceiverFSMDebug().getDebug()) {
            DebugObjects.getReceiverFSMDebug().debug(this.fdate() + ":" + this.toString() + " " + rmss + " " + e.toString());
        }
    }
}

