/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.receiver.fsm;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.ws.axis.handlers.HandlerUtils;
import com.sonicsw.ws.rm.common.RMEvent;
import com.sonicsw.ws.rm.common.SequenceCapsule;
import com.sonicsw.ws.rm.protocol.ReliableHeaders;
import com.sonicsw.ws.rm.receiver.fsm.ReceiverClient;
import java.net.SocketException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.addressing.AddressingHeaders;
import progress.message.msg.IMgram;

public class RequestAsynchronousSendEvent
extends RMEvent {
    private SOAPEnvelope m_envelope = null;

    public void setEnvelope(SOAPEnvelope se) {
        this.m_envelope = se;
    }

    public SOAPEnvelope getEnvelope() {
        return this.m_envelope;
    }

    @Override
    public void execute() {
        String transportURL = null;
        try {
            SequenceCapsule capsule;
            IMgram mg;
            AddressingHeaders ah = new AddressingHeaders((javax.xml.soap.SOAPEnvelope)this.m_envelope);
            Message m = new Message((Object)this.m_envelope);
            ReceiverClient rc = ReceiverClient.getReceiverClient();
            MessageContext mc = new MessageContext((AxisEngine)rc.getAxisClient());
            transportURL = ah.getTo().toString();
            ReliableHeaders rh = new ReliableHeaders();
            rh.fromSOAPEnvelope(this.m_envelope);
            mc.setPastPivot(false);
            mc.setResponseMessage(null);
            mc.setRequestMessage(m);
            mc.setProperty("COM_SONIC_RM_REQUEST_HEADERS", (Object)rh);
            HttpLock lock = new HttpLock(610L);
            String wsaNS = (String)this.getContext().getProperty("addressing.namespace.URI");
            if (wsaNS != null) {
                mc.setProperty("addressing.namespace.URI", (Object)wsaNS);
            }
            if ((mg = (IMgram)this.getContext().getProperty("progress.message.msg.IMgram")) != null) {
                mc.setProperty("progress.message.msg.IMgram", (Object)mg);
            }
            if ((mg = (IMgram)this.getContext().getProperty("COM_SONIC_RESPONSEMGRAM")) != null) {
                mc.setProperty("COM_SONIC_RESPONSEMGRAM", (Object)mg);
            }
            if ((capsule = (SequenceCapsule)this.getContext().getProperty("com.sonicsw.ws.rm.common.SequenceCapsule")) != null) {
                mc.setProperty("com.sonicsw.ws.rm.common.SequenceCapsule", (Object)capsule);
            }
            mc.setProperty("com.sonicsw.net.http.HttpLock", (Object)lock);
            mc.setSOAPConstants(this.m_envelope.getSOAPConstants());
            mc.setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)ah);
            mc.setProperty("transport.url", (Object)transportURL);
            mc.setProperty("addressing.setMustUnderstand", (Object)"true");
            mc.setMessage((SOAPMessage)m);
            HttpOutboundHandler handler = HandlerUtils.locateHttpRoutingHandler(transportURL);
            if (handler != null) {
                mc.setProperty("com.sonicsw.net.http.HttpOutboundHandler", (Object)handler);
            }
            rc.sendAxis(mc);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof SocketException) {
                BrokerComponent.getComponentContext().logMessage("Failure attempting to send to " + transportURL, BrokerComponent.getLevelWarning().intValue());
            }
            BrokerComponent.getComponentContext().logMessage("Failure attempting to send for RM", (Throwable)e, BrokerComponent.getLevelWarning().intValue());
        }
    }

    public String toString() {
        return "RequestAsynchronousSendEvent";
    }
}

