/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy.parser.processors;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.policy.parser.SecurityPolicy;
import com.sonicsw.ws.security.policy.parser.processors.KeyStoreEntryProcessor;
import com.sonicsw.ws.security.policy.parser.processors.X509IssuerSerialProcessor;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;

public class X509TokenProcessor
extends org.apache.ws.security.policy.parser.processors.X509TokenProcessor {
    private boolean initializedPerMessageOverride = false;

    private void initializePerMessageOverride(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.keyStoreEntry.copy();
        tmpSpt.setProcessTokenMethod((Object)new KeyStoreEntryProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.x509IssuerSerial.copy();
        tmpSpt.setProcessTokenMethod((Object)new X509IssuerSerialProcessor());
        spt.setChildToken(tmpSpt);
    }

    public Object doX509Token(SecurityProcessorContext spc) {
        DebugObjects.getPolicyDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        super.doX509Token(spc);
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (this.initializedPerMessageOverride) break;
                try {
                    this.initializePerMessageOverride(spt);
                    this.initializedPerMessageOverride = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doRequireEmbeddedTokenReference(SecurityProcessorContext spc) {
        return super.doRequireEmbeddedTokenReference(spc);
    }

    public Object doRequireIssuerSerialReference(SecurityProcessorContext spc) {
        return super.doRequireIssuerSerialReference(spc);
    }

    public Object doRequireKeyIdentifierReference(SecurityProcessorContext spc) {
        return super.doRequireKeyIdentifierReference(spc);
    }

    public Object doRequireThumbprintReference(SecurityProcessorContext spc) {
        return super.doRequireThumbprintReference(spc);
    }

    public Object doWssX509Pkcs7Token10(SecurityProcessorContext spc) {
        return super.doWssX509Pkcs7Token10(spc);
    }

    public Object doWssX509Pkcs7Token11(SecurityProcessorContext spc) {
        return super.doWssX509Pkcs7Token11(spc);
    }

    public Object doWssX509PkiPathV1Token10(SecurityProcessorContext spc) {
        return super.doWssX509PkiPathV1Token10(spc);
    }

    public Object doWssX509PkiPathV1Token11(SecurityProcessorContext spc) {
        return super.doWssX509PkiPathV1Token11(spc);
    }

    public Object doWssX509V1Token10(SecurityProcessorContext spc) {
        return super.doWssX509V1Token10(spc);
    }

    public Object doWssX509V1Token11(SecurityProcessorContext spc) {
        return super.doWssX509V1Token11(spc);
    }

    public Object doWssX509V3Token10(SecurityProcessorContext spc) {
        return super.doWssX509V3Token10(spc);
    }

    public Object doWssX509V3Token11(SecurityProcessorContext spc) {
        return super.doWssX509V3Token11(spc);
    }
}

