/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.ArrayList;
import java.util.HashMap;
import progress.message.broker.Broker;
import progress.message.broker.IPostponedOperation;
import progress.message.broker.MsgSaver;
import progress.message.broker.MsgSaverOp;
import progress.message.util.LinkedList;
import progress.message.util.ListNode;
import progress.message.zclient.DebugObject;

public class PostponedMsgSaver
extends DebugObject
implements Runnable {
    private MsgSaver m_msgSaver = null;
    private LinkedList m_ops = new LinkedList();
    private HashMap m_idToOplist = new HashMap();
    private int m_count = 0;
    private boolean m_isRunning = false;
    private volatile boolean m_isShutdown = false;
    private Thread m_postponedMsgSaverThread = null;
    private int m_threadCount;
    private static final int IDLE_TIMEOUT = 300000;

    public PostponedMsgSaver(MsgSaver msgSaver) {
        super("PostponedMsgSaver");
        this.m_msgSaver = msgSaver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long numOps = 0L;
        try {
            if (this.DEBUG) {
                this.debug("Thread starting " + Thread.currentThread().getName());
            }
            while (!(Broker.exiting || Thread.currentThread().isInterrupted() || this.m_isShutdown)) {
                IPostponedOperation op = this.getNextOp();
                if (op == null) {
                    return;
                }
                this.m_msgSaver.performPostponedOperation(op);
                if (!this.DEBUG || ++numOps % 100L != 0L) continue;
                this.debug("run: numOps= " + numOps + " " + Thread.currentThread().getName());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (this.DEBUG) {
                this.debug("run: Exiting PostponedMsgSaver; numOps= " + numOps + " thread= " + Thread.currentThread().getName());
            }
            this.threadExiting(Thread.currentThread());
        }
    }

    public synchronized void checkStartThread() {
        if (!(this.m_isRunning || Broker.exiting || this.m_isShutdown)) {
            ++this.m_threadCount;
            this.m_postponedMsgSaverThread = new Thread((Runnable)this, "Postponed Message Saver " + this.m_threadCount);
            this.m_postponedMsgSaverThread.start();
            this.m_isRunning = true;
            if (this.DEBUG) {
                this.debug("checkStartThread: Started thread " + this.m_postponedMsgSaverThread.getName());
            }
        }
    }

    public synchronized void shutdown() {
        this.m_isShutdown = true;
        if (this.m_isRunning && this.m_postponedMsgSaverThread.isAlive()) {
            this.m_postponedMsgSaverThread.interrupt();
        }
    }

    public synchronized void performPostponedOperation(IPostponedOperation op) {
        if (this.m_isShutdown || Broker.exiting) {
            return;
        }
        ListNode<IPostponedOperation> node = this.m_ops.append(op);
        long id = op.getId();
        if (id != -1L) {
            Long ID = new Long(id);
            ArrayList<ListNode<IPostponedOperation>> list = (ArrayList<ListNode<IPostponedOperation>>)this.m_idToOplist.get(ID);
            if (list == null) {
                list = new ArrayList<ListNode<IPostponedOperation>>();
                this.m_idToOplist.put(ID, list);
            }
            list.add(node);
            ++this.m_count;
        }
        this.checkStartThread();
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(long id) throws InterruptedException {
        Long ID = new Long(id);
        ArrayList canceledOpList = null;
        PostponedMsgSaver postponedMsgSaver = this;
        synchronized (postponedMsgSaver) {
            canceledOpList = (ArrayList)this.m_idToOplist.get(ID);
            if (canceledOpList != null) {
                int size = canceledOpList.size();
                this.m_count -= size;
                this.m_idToOplist.remove(ID);
                for (ListNode node : canceledOpList) {
                    this.m_ops.remove(node);
                }
                if (this.DEBUG) {
                    this.debug("cancel: canceled " + size + " ID= " + ID + " totalOps= " + this.m_ops.count());
                }
            }
        }
        if (canceledOpList != null) {
            while (!canceledOpList.isEmpty()) {
                ListNode node = (ListNode)canceledOpList.remove(0);
                IPostponedOperation op = (IPostponedOperation)node.obj;
                op.postProcess();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws InterruptedException {
        PostponedMsgFlushOp op = null;
        Object object = this;
        synchronized (object) {
            if (!this.m_isRunning) {
                return;
            }
            op = new PostponedMsgFlushOp();
            this.performPostponedOperation(op);
        }
        if (this.DEBUG) {
            this.debug("flush: Enqueued flush request");
        }
        object = op;
        synchronized (object) {
            while (!(op.isCompleted() || Broker.exiting || Thread.currentThread().isInterrupted())) {
                op.wait();
                if (!this.m_isShutdown) continue;
            }
        }
        if (this.DEBUG) {
            this.debug("Flush completed");
        }
    }

    private synchronized void threadExiting(Thread t) {
        if (this.m_isRunning && t != null && t == this.m_postponedMsgSaverThread) {
            this.m_isRunning = false;
            if (this.DEBUG) {
                this.debug("threadExiting: " + t.getName());
            }
        }
    }

    private synchronized IPostponedOperation getNextOp() throws InterruptedException {
        Thread caller = Thread.currentThread();
        while (this.m_ops.isEmpty() && !Broker.exiting && !Thread.currentThread().isInterrupted() && !this.m_isShutdown) {
            this.wait(300000L);
            if (!this.m_ops.isEmpty()) continue;
            this.threadExiting(caller);
            if (this.DEBUG) {
                this.debug("getNextOp: PostponedMsgSaver timed out ");
            }
            return null;
        }
        if (Broker.exiting || Thread.currentThread().isInterrupted() || this.m_isShutdown) {
            this.threadExiting(caller);
            return null;
        }
        IPostponedOperation op = (IPostponedOperation)this.m_ops.dequeue();
        long opid = op.getId();
        if (opid != -1L) {
            Long ID = new Long(op.getId());
            ArrayList list = (ArrayList)this.m_idToOplist.get(ID);
            if (list != null) {
                if (!list.isEmpty()) {
                    list.remove(0);
                    --this.m_count;
                    if (list.isEmpty()) {
                        this.m_idToOplist.remove(ID);
                    }
                } else if (this.DEBUG) {
                    this.debug("******** getNextOp: Removed op from m_ops; no corresponding op; id= " + ID);
                }
            } else if (this.DEBUG) {
                this.debug("******** getNextOp: Removed op from m_ops; no corresponding id; id= " + ID);
            }
        }
        return op;
    }

    final class PostponedMsgFlushOp
    implements IPostponedOperation {
        boolean flushCompleted = false;

        PostponedMsgFlushOp() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preProcess() {
            PostponedMsgFlushOp postponedMsgFlushOp = this;
            synchronized (postponedMsgFlushOp) {
                this.flushCompleted = true;
                this.notifyAll();
            }
        }

        @Override
        public void postProcess() {
        }

        @Override
        public boolean isPostProcessed() {
            return false;
        }

        @Override
        public MsgSaverOp getOperation() {
            return null;
        }

        @Override
        public long getId() {
            return -1L;
        }

        @Override
        public int memsize() {
            return 0;
        }

        boolean isCompleted() {
            return this.flushCompleted;
        }

        public String toString() {
            return "PostponedMsgFlushOp ";
        }
    }
}

