/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.client.EGeneralException;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.Envelope;
import progress.message.zclient.Message;

public class TempQueueCreationEvt
extends LogEvent {
    private int m_maxSize;
    private int m_type;
    private long m_cid;
    private boolean m_isGlobal;
    private String m_queueName;
    private Envelope m_env;
    private boolean m_replyDone;

    public TempQueueCreationEvt() {
    }

    public TempQueueCreationEvt(long clientId, int queueType, String queueName, boolean isGlobal, int maxSize, Envelope env) {
        this.m_queueName = queueName;
        this.m_type = queueType;
        this.m_cid = clientId;
        this.m_isGlobal = isGlobal;
        this.m_maxSize = maxSize;
        this.m_env = env;
        this.m_replyDone = env == null;
    }

    @Override
    public short type() {
        return 79;
    }

    @Override
    protected int memSizeBody() {
        return this.m_queueName.length() + 4 + 8 + 1 + 4 + 8;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        return StringUtil.lengthUTF(this.m_queueName) + 8 + 1 + 4 + 4;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeInt(this.m_type, os);
        StreamUtil.writeUTF(this.m_queueName, os);
        StreamUtil.writeLong(this.m_cid, os);
        StreamUtil.writeBoolean(this.m_isGlobal, os);
        StreamUtil.writeInt(this.m_maxSize, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_type = StreamUtil.readInt(in);
        this.m_queueName = StreamUtil.readUTF(in);
        this.m_cid = StreamUtil.readLong(in);
        this.m_isGlobal = StreamUtil.readBoolean(in);
        this.m_maxSize = StreamUtil.readInt(in);
    }

    public String getQueueName() {
        return this.m_queueName;
    }

    @Override
    public long getClientID() {
        return this.m_cid;
    }

    public boolean isGlobal() {
        return this.m_isGlobal;
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }

    public int getType() {
        return this.m_type;
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoTempQueueCreationEvt(this);
    }

    @Override
    public String toString() {
        return super.toString() + "TempQueueCreationEvt";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onFlush() {
        boolean reply = false;
        TempQueueCreationEvt tempQueueCreationEvt = this;
        synchronized (tempQueueCreationEvt) {
            reply = !this.m_replyDone;
            this.m_replyDone = true;
        }
        if (reply) {
            try {
                Message rep = new Message();
                rep.writeBoolean(true);
                AgentRegistrar.getAgentRegistrar().getAdminSession().reply(rep, this.m_env, false);
            }
            catch (ESecurityPolicyViolation eSecurityPolicyViolation) {
            }
            catch (EGeneralException eGeneralException) {
                // empty catch block
            }
        }
    }
}

