/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.Transaction;
import progress.message.broker.TxMsg;
import progress.message.client.EIntegrityCompromised;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;

class TxMsgPubSub
extends TxMsg {
    AgentGuarMsgTracker m_tracker;

    TxMsgPubSub(int tid, AgentGuarMsgTracker trk) {
        super(tid, trk.getEvent().getOrigSender(), trk.getEvent().getMessage());
        this.m_tracker = trk;
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("TxMsgPubSub " + tid + " trk= " + this.m_tracker.getTracking());
        }
        if (this.DEBUG) {
            this.debug("Created ");
        }
    }

    @Override
    void deliverMsg(int seq, boolean retry, Transaction txn) throws EIntegrityCompromised, InterruptedException {
        if (this.DEBUG) {
            this.debug("delivering ");
        }
        IMgram msg = this.m_tracker.getEvent().getMessage();
        msg.setGuarenteed(this.m_tracker.getTracking());
        msg.getBrokerHandle().setTxnPublishFromLog(true);
        super.deliverMsg(0, retry, txn);
    }

    @Override
    void cancelMsg() {
        if (this.DEBUG) {
            this.debug("Canceling " + this.m_tracker.getTracking());
        }
        this.m_tracker.canceled();
    }
}

