/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EOldVirtualClockException;
import progress.message.broker.gs.GSManager;
import progress.message.broker.gs.GSRequest;
import progress.message.broker.gs.GSSubscribeEvt;
import progress.message.broker.gs.GSTransport;
import progress.message.broker.parser.ParseException;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.EInvalidTTLException;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.msg.IMgram;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;

class GSIBReconciliationHandler
extends DebugObject
implements IMessageHandler {
    private AgentRegistrar m_reg;
    private GSTransport m_transport;
    private GSManager m_manager;

    GSIBReconciliationHandler(AgentRegistrar reg, GSManager manager, GSTransport transport) {
        super("GSIBReconciliationHandler");
        this.m_reg = reg;
        this.m_manager = manager;
        this.m_transport = transport;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        if (!BrokerStateManager.getBrokerStateManager().isActive()) {
            return;
        }
        try {
            IMgram mgram = env.getMgram();
            ObjectInput in = mgram.getPayloadInputStreamHandle();
            String subject = mgram.getSubject().getSubjectString();
            in.readByte();
            int mask = in.readInt();
            int seqnr = in.readInt();
            String neighbor = in.readUTF();
            GSRequest req = null;
            boolean isSelectorAtBroker = true;
            if (this.DEBUG) {
                this.debug("Received: globalIBReconcile from neighbor " + neighbor + ",mask=" + mask + ",seqnr=" + seqnr);
            }
            while (true) {
                GSSubscribeEvt evt = null;
                try {
                    evt = null;
                    req = GSRequest.deserialize(in);
                    if (this.DEBUG) {
                        this.debug("Xfer:" + req.toString());
                    }
                    long clientID = this.m_reg.getRouterManager().getRemoteBrokerGSClientID(req.getHomeNodeName(), req.getHomeBrokerName());
                    this.m_reg.getGSManager().createRemoteBrokerCC(req.getHomeNodeName(), req.getHomeBrokerName());
                    evt = new GSSubscribeEvt(env, clientID, new Subject(req.getTopic()), this.m_reg.getGSManager().getLabel(), req.getSelectors(), isSelectorAtBroker, req.getVirtualClock());
                    this.m_reg.subscribeAndWaitForFlush(evt, true, false, null);
                    if (!this.DEBUG) continue;
                    this.debug("Subscribe was successful");
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (EOFException e) {
                }
                catch (EOldVirtualClockException e) {
                    if (!this.DEBUG) continue;
                    this.debug("re-subscribe rejected stale vc:" + e);
                    continue;
                }
                catch (EClientNotRegistered e) {
                    SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
                    continue;
                }
                catch (ESecurityPolicyViolation e) {
                    if (!this.DEBUG) continue;
                    this.debug("re-subscribe rejected not authorised:" + e);
                    continue;
                }
                catch (EInvalidSubjectSyntax e) {
                    SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
                    continue;
                }
                catch (EInvalidTTLException e) {
                    SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
                    continue;
                }
                catch (ParseException e) {
                    SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
                    continue;
                }
                break;
            }
        }
        catch (EClientNotRegistered e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
        catch (IOException ioe) {
            SessionConfig.logMessage("Corrupt globalIBReconcile reconciliation message:", ioe, SessionConfig.getLevelWarning());
        }
    }
}

