/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.RemoteSubscriptionHolder;
import progress.message.broker.gs.GSManager;
import progress.message.broker.gs.GSPropagationRule;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.SessionConfig;

public class GSPropagationRuleList
extends DebugObject
implements Cloneable,
Serializable {
    private transient AgentRegistrar m_reg;
    private Hashtable m_rules = new Hashtable();
    private int m_lastID = -1;

    GSPropagationRuleList() {
    }

    GSPropagationRuleList(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "GSPropagationRuleList" : null);
        this.m_reg = reg;
        this.loadFromDS();
    }

    public Hashtable getRules() {
        return this.m_rules;
    }

    public boolean isEmpty() {
        return this.m_rules.isEmpty();
    }

    public GSPropagationRuleList clone() throws CloneNotSupportedException {
        return (GSPropagationRuleList)super.clone();
    }

    private void loadFromDS() {
        Vector v = Broker.getBroker().getGlobalSubscriptionsVector();
        if (v != null) {
            Enumeration rules = v.elements();
            while (rules.hasMoreElements()) {
                RemoteSubscriptionHolder holder = (RemoteSubscriptionHolder)rules.nextElement();
                this.addRule(holder.getTopic(), GSManager.convertNodes(holder.getNodes()), null);
            }
        }
    }

    synchronized boolean addRule(GSPropagationRule r) {
        if (r.getTopic() == null || "".equals(r.getTopic())) {
            return false;
        }
        int ruleNum = r.getID();
        if (ruleNum < 0 || this.getRule(ruleNum) != null) {
            r.setID(this.genRuleID());
        }
        this.m_rules.put(Integer.toString(ruleNum), r);
        return true;
    }

    public synchronized GSPropagationRule addRule(String topic, String toNodeList, String fromNodeList) {
        if (topic == null || toNodeList == null) {
            return null;
        }
        int ruleID = this.genRuleID();
        GSPropagationRule r = new GSPropagationRule(ruleID, topic, toNodeList, fromNodeList);
        this.m_rules.put(Integer.toString(ruleID), r);
        if (this.DEBUG) {
            this.debug("[.addRule] \n" + r.toString());
        }
        return r;
    }

    public synchronized boolean deleteRule(GSPropagationRule aRule) {
        return this.deleteRule(aRule.getTopic(), aRule.getID());
    }

    public synchronized boolean deleteRule(String topic, int ruleNumber) {
        if (topic == null) {
            return false;
        }
        String index = Integer.toString(ruleNumber);
        GSPropagationRule r = (GSPropagationRule)this.m_rules.get(index);
        if (r != null && r.getTopic().equals(topic)) {
            this.m_rules.remove(index);
            if (this.DEBUG) {
                this.debug("[.deleteRule ] : " + r.toString());
            }
            return true;
        }
        if (this.DEBUG) {
            this.debug("[deleteRule failed, can't find rule. topic: ] : " + topic + " [ruleNum] " + ruleNumber);
        }
        return false;
    }

    public synchronized boolean updateRule(String topic, int ruleNumber, String toNodeList, String fromNodeList) {
        if (this.deleteRule(topic, ruleNumber)) {
            GSPropagationRule r = new GSPropagationRule(ruleNumber, topic, toNodeList, fromNodeList);
            this.m_rules.put(Integer.toString(ruleNumber), r);
            return true;
        }
        return false;
    }

    GSPropagationRule getRule(int ruleNumber) {
        return (GSPropagationRule)this.m_rules.get(Integer.toString(ruleNumber));
    }

    public GSPropagationRule[] getRule(String topic) {
        if (topic == null) {
            return null;
        }
        Vector<GSPropagationRule> matches = new Vector<GSPropagationRule>();
        Enumeration rules = this.m_rules.elements();
        while (rules.hasMoreElements()) {
            GSPropagationRule r = (GSPropagationRule)rules.nextElement();
            if (!r.getTopic().equals(topic)) continue;
            matches.addElement(r);
        }
        int size = matches.size();
        if (size == 0) {
            return null;
        }
        GSPropagationRule[] getRules = new GSPropagationRule[size];
        for (int i = 0; i < size; ++i) {
            getRules[i] = (GSPropagationRule)matches.elementAt(i);
        }
        return getRules;
    }

    public synchronized void serialize(DataOutput output) throws IOException {
        Enumeration rules = this.m_rules.elements();
        output.writeInt(this.m_rules.size());
        while (rules.hasMoreElements()) {
            ((GSPropagationRule)rules.nextElement()).serialize(output);
        }
    }

    public synchronized void unserialize(DataInput input) throws IOException {
        int size = input.readInt();
        this.m_rules = new Hashtable(size);
        for (int i = 0; i < size; ++i) {
            GSPropagationRule rule = new GSPropagationRule();
            rule.unserialize(input);
            int ruleNumber = rule.getID();
            this.m_rules.put(Integer.toString(ruleNumber), rule);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.serialize(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("GSPropagationRuleList");
        }
        this.unserialize(in);
    }

    public void dump() {
        System.out.println("[GSPropagationRuleList Dump]: \n");
        if (this.m_rules.isEmpty()) {
            System.out.println("ruels table is empty");
            return;
        }
        Enumeration rules = this.m_rules.elements();
        while (rules.hasMoreElements()) {
            System.out.println(((GSPropagationRule)rules.nextElement()).toString());
        }
    }

    public void dumpToFile(String fileName) {
        System.out.println("[GSPropagationRuleList Dump] to [file]: " + fileName);
        try {
            FileOutputStream ostream = new FileOutputStream(fileName);
            ObjectOutputStream p = new ObjectOutputStream(ostream);
            this.writeObject(p);
            p.flush();
            ostream.close();
            if (this.DEBUG) {
                GSPropagationRuleList t = new GSPropagationRuleList();
                t.loadFromFile(fileName);
                t.dump();
            }
        }
        catch (FileNotFoundException e1) {
            SessionConfig.logMessage(e1, SessionConfig.getLevelWarning());
        }
        catch (IOException e2) {
            SessionConfig.logMessage(e2, SessionConfig.getLevelWarning());
        }
    }

    public void loadFromFile(String fileName) {
        System.out.println("[GSPropagationRuleList Load] from [file]: " + fileName);
        try {
            FileInputStream istream = new FileInputStream(fileName);
            ObjectInputStream p = new ObjectInputStream(istream);
            this.readObject(p);
            istream.close();
        }
        catch (ClassNotFoundException e1) {
            SessionConfig.logMessage(e1, SessionConfig.getLevelWarning());
        }
        catch (IOException e2) {
            SessionConfig.logMessage(e2, SessionConfig.getLevelWarning());
        }
    }

    int genRuleID() {
        return ++this.m_lastID;
    }

    Vector findWildCardRules() {
        Vector<GSPropagationRule> returnRules = new Vector<GSPropagationRule>();
        Enumeration rules = this.m_rules.elements();
        while (rules.hasMoreElements()) {
            GSPropagationRule r = (GSPropagationRule)rules.nextElement();
            if (!r.isToAllNodes()) continue;
            returnRules.addElement(r);
        }
        return returnRules;
    }

    Vector findRulesContain(String node) {
        Vector<GSPropagationRule> returnRules = new Vector<GSPropagationRule>();
        Enumeration rules = this.m_rules.elements();
        while (rules.hasMoreElements()) {
            GSPropagationRule r = (GSPropagationRule)rules.nextElement();
            if (!r.isToNodeListContains(node)) continue;
            returnRules.addElement(r);
        }
        return returnRules;
    }
}

