/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import progress.message.broker.gs.GSManager;
import progress.message.broker.gs.GSTracker;
import progress.message.msg.IMgram;

public class GSRoutingQueueListener {
    GSManager m_gsman = null;

    GSRoutingQueueListener(GSManager gsman) {
        this.m_gsman = gsman;
    }

    public void messageAdded(IMgram mg) {
        GSTracker tracker = this.locateGSTracker(mg);
        if (tracker == null) {
            return;
        }
        tracker.messageAdded(mg);
    }

    public void messageRemoved(IMgram mg) {
        GSTracker tracker = this.locateGSTracker(mg);
        if (tracker == null) {
            return;
        }
        tracker.messageRemoved(mg);
    }

    public void clear(String node) {
        GSTracker tracker = this.m_gsman.locateGSTracker(node);
        if (tracker == null) {
            return;
        }
        tracker.reset();
    }

    private GSTracker locateGSTracker(IMgram mg) {
        if (!this.isGSAMessage(mg)) {
            return null;
        }
        return this.m_gsman.locateGSTracker(mg.getRouting());
    }

    private boolean isGSAMessage(IMgram m) {
        if (!m.isPubSub()) {
            return false;
        }
        return m.getRoutingHandle().isGSAPublication();
    }
}

