/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Date;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.broker.SubscribeEvt;
import progress.message.broker.UnsubscribeEvt;
import progress.message.broker.gs.GSManager;
import progress.message.broker.gs.GSTransport;
import progress.message.broker.gs.IGSSubscriptionExpirationManager;
import progress.message.client.ENetworkFailure;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;

public class GSSubscriptionExpirationManager
extends DebugObject
implements IGSSubscriptionExpirationManager {
    private AgentRegistrar m_reg;
    private GSTransport m_transport;
    private GSManager m_manager;
    private static final byte CURRENT_VERSION = 0;
    private static final long BACKOFF_INTERVAL = 60000L;
    private static final long SETTLING_INTERVAL = 120000L;
    private long m_startTime = 0L;

    GSSubscriptionExpirationManager(AgentRegistrar reg, GSManager manager, GSTransport transport) {
        super("GSSubscriptionExpirationManager");
        this.m_reg = reg;
        this.m_manager = manager;
        this.m_transport = transport;
    }

    @Override
    public void onExpire(BrokerSubscription bs) {
        try {
            String remoteNode = bs.getClient().getRemoteNode();
            if (this.DEBUG) {
                this.debug("onExpire:" + remoteNode);
            }
            if (!this.isStartupSettlingComplete(remoteNode)) {
                if (this.DEBUG) {
                    this.debug("onExpire:system settling period backoff!");
                }
                bs.setTTE(System.currentTimeMillis() + 60000L);
                this.m_reg.getExpirationQueue().insert(bs);
                return;
            }
            IRemoteBroker currentWayOut = this.m_reg.getRouterManager().getRouteForwarder().getRemoteBroker(remoteNode, null, false);
            if (currentWayOut != null && currentWayOut.isNeighbor()) {
                if (this.DEBUG) {
                    this.debug("onExpire-no longer in boundary boundary role! - current boundary broker:" + currentWayOut.getBrokerName());
                }
                this.stopExpirationTimer(remoteNode);
                return;
            }
            Message request = new Message("$ISYS.GSA.globalAdminDelete");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            out.writeByte(0);
            out.writeUTF(Config.BROKER_NAME);
            out.writeInt(1);
            out.writeUTF(remoteNode);
            baos.close();
            request.setBody(baos.toByteArray());
            Envelope env = new Envelope(request);
            AgentRegistrar.getAgentRegistrar().getAdminSession().publishInternal(env, 0, false, true);
            this.stopExpirationTimer(remoteNode);
            if (this.DEBUG) {
                this.debug("onExpire:expired!");
            }
        }
        catch (ENetworkFailure enf) {
            if (!Broker.isInShutdown()) {
                SessionConfig.logMessage(enf, SessionConfig.getLevelWarning());
            }
        }
        catch (Exception e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
    }

    @Override
    public void onFailedConnectInitiation(IRemoteBroker rb) {
        IRemoteBroker currentWayOut;
        if (this.DEBUG) {
            this.debug("onFailedConnectInitiation:" + rb.getNodeName() + ":" + rb.getBrokerName() + ", neighbor:" + rb.isNeighbor());
        }
        if ((currentWayOut = this.m_reg.getRouterManager().getRouteForwarder().getRemoteBroker(rb.getNodeName(), null, false)) == null || currentWayOut == rb) {
            this.startExpirationTimer(rb.getNodeName());
        }
    }

    @Override
    public void onFailedConnection(IRemoteBroker rb) {
    }

    @Override
    public void notifyRemoteNodeWayOutUpdate(String remoteNode) {
        IRemoteBroker currentWayOut;
        if (this.DEBUG) {
            this.debug("notifyRemoteNodeWayOutRouteUpdate:" + remoteNode);
        }
        if ((currentWayOut = this.m_reg.getRouterManager().getRouteForwarder().getRemoteBroker(remoteNode, null, false)) != null && currentWayOut.isNeighbor()) {
            if (this.DEBUG) {
                this.debug("notifyRemoteNodeWayOutUpdate:no longer routing directly... stopping the expiration timer.");
            }
            this.stopExpirationTimer(remoteNode);
        }
    }

    @Override
    public void onNewConnection(IRemoteBroker rb, boolean inbound) {
        if (this.DEBUG) {
            this.debug("onNewConnection:" + rb.getNodeName() + ":" + rb.getBrokerName());
        }
        this.stopExpirationTimer(rb.getNodeName());
    }

    @Override
    public void startExpirationMonitoring(String remoteNode) {
    }

    @Override
    public void startExpirationTimer(String remoteNode) {
        if (this.DEBUG) {
            this.debug("startExpirationTimer:" + remoteNode);
        }
        if (this.getConfiguredExpirationTTL(remoteNode) <= 0L) {
            if (this.DEBUG) {
                this.debug("startExpirationTimer:no expiration TTL configured!");
            }
            return;
        }
        if (this.m_manager.locateGSTracker(remoteNode) == null) {
            if (this.DEBUG) {
                this.debug("startExpirationTimer:no remote subscriptions!");
            }
            return;
        }
        BrokerSubscription bs = this.getExpirableSubscription(remoteNode);
        if (bs != null) {
            if (this.DEBUG) {
                this.debug("startExpirationTimer:already running!");
            }
            return;
        }
        if (this.DEBUG) {
            this.debug("startExpirationTimer:creating new timer !");
        }
        this.createDummyExpirableSubscription(remoteNode, this.getExpirableLabel(remoteNode));
        bs = this.getExpirableSubscription(remoteNode);
        bs.setTTE(bs.getLabel().getExpiration().getTime() + System.currentTimeMillis());
        this.m_reg.getExpirationQueue().insert(bs);
    }

    @Override
    public void stopExpirationMonitoring(String remoteNode) {
        this.stopExpirationTimer(remoteNode);
    }

    @Override
    public void stopExpirationTimer(String remoteNode) {
        if (this.DEBUG) {
            this.debug("stopExpirationTimer:" + remoteNode);
        }
        if (this.getExpirableSubscription(remoteNode) == null) {
            return;
        }
        long clientID = this.m_reg.getRouterManager().getRemoteNodeGSClientID(remoteNode);
        try {
            if (this.DEBUG) {
                this.debug("stopExpirationTimer:canning timer !");
            }
            this.m_reg.unsubscribe(new UnsubscribeEvt(null, clientID, new Subject("$ISYS.GSA.expirableSubject")));
        }
        catch (Exception e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
    }

    @Override
    public void start() {
        if (this.m_startTime == 0L) {
            this.m_startTime = System.currentTimeMillis();
        }
    }

    @Override
    public void shutdown() {
        this.m_startTime = 0L;
    }

    private void createDummyExpirableSubscription(String remoteNode, Label label) {
        try {
            long clientID = this.m_reg.getRouterManager().getRemoteNodeGSClientID(remoteNode);
            this.m_reg.getGSManager().createRemoteNodeCC(remoteNode);
            SubscribeEvt evt = new SubscribeEvt(null, clientID, new Subject("$ISYS.GSA.expirableSubject"), label);
            this.m_reg.subscribe(evt, false, true, null);
        }
        catch (Exception e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
    }

    private Label getExpirableLabel(String proxyingHomeNode) {
        Label label = new Label();
        label.setGuaranteed(true);
        label.setRouteLimit(1);
        long ttl = this.getConfiguredExpirationTTL(proxyingHomeNode);
        if (ttl > 0L) {
            label.setExpiration(new Date(ttl));
        }
        return label;
    }

    private long getConfiguredExpirationTTL(String proxyingHomeNode) {
        long ttl = 0L;
        RoutingConnectionInfo ri = this.m_reg.getRoutingConfig().getRoutingConnection(proxyingHomeNode);
        ttl = ri != null ? ri.getGlobalSubscriptionExpiration() : Config.GLOBAL_SUBSCRIPTION_EXPIRATION;
        return ttl * 3600000L;
    }

    private BrokerSubscription getExpirableSubscription(String rn) {
        long clientID = this.m_reg.getRouterManager().getRemoteNodeGSClientID(rn);
        return this.getExpirableSubscription(clientID);
    }

    private BrokerSubscription getExpirableSubscription(IRemoteBroker rb) {
        long clientID = this.m_reg.getRouterManager().getRemoteNodeGSClientID(rb.getNodeName());
        return this.getExpirableSubscription(clientID);
    }

    private BrokerSubscription getExpirableSubscription(long rcid) {
        IClientContext cc = null;
        try {
            cc = this.m_reg.getClient(rcid);
        }
        catch (EClientNotRegistered ecnr) {
            return null;
        }
        return (BrokerSubscription)cc.getSubscriptions().get(new Subject("$ISYS.GSA.expirableSubject"));
    }

    private boolean isStartupSettlingComplete(String remoteNode) {
        return this.m_startTime != 0L && System.currentTimeMillis() > this.m_startTime + 120000L;
    }
}

