/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse.pc.pubsub.v2;

import com.odi.ClassInfo;
import com.odi.Database;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.Placement;
import com.odi.imp.ObjectReference;
import com.odi.util.DuplicateKeyException;
import com.odi.util.IndexIterator;
import com.odi.util.IndexMap;
import com.odi.util.OSTreeSet;
import java.util.Date;
import progress.message.dbsc.pse.pc.PSEByteArrayWrapper;
import progress.message.dbsc.pse.pc.pubsub.IPSEMessage;
import progress.message.dbsc.pse.pc.pubsub.IPSEMessages;
import progress.message.dbsc.pse.pc.pubsub.v2.PSEMessage2;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;

public class PSEMessages2
implements IPSEMessages,
IPersistent,
IPersistentHooks {
    private OSTreeSet _AllMessages;
    private static Class msgClass2;
    private transient DebugObject _debugObj;
    private transient boolean DEBUG;
    private transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance;

    public PSEMessages2(Database db) {
        this._AllMessages = new OSTreeSet((Placement)db, msgClass2, "getMessageId()");
        this._AllMessages.addIndex(msgClass2, "getJMSMessageId()", true, true);
    }

    public void postInitializeContents() {
        if (DebugState.GLOBAL_DEBUG_ON) {
            this._debugObj = new DebugObject("PSEMessages");
            this.DEBUG = this._debugObj.getDebug();
        }
    }

    @Override
    public long getMaxMessageId() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        long max = 0L;
        Long maxL = (Long)this._AllMessages.getMaxPrimaryKey();
        if (maxL != null) {
            max = maxL;
        }
        return max;
    }

    @Override
    public boolean messageExists(long id) {
        IPSEMessage msg = this.get(id);
        return msg != null && msg.hasBody();
    }

    @Override
    public int getCount() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._AllMessages.size();
    }

    @Override
    public boolean deleteIfNoRecips(long id) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        boolean result = false;
        IPSEMessage msg = this.get(id);
        if (msg != null && !msg.hasRecipients()) {
            this._AllMessages.remove((Object)msg);
            ObjectStore.destroy((Object)msg);
            result = true;
        }
        return result;
    }

    @Override
    public boolean deleteIfNoRecips(IPSEMessage msg) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        boolean result = false;
        if (!msg.hasRecipients() && (result = this._AllMessages.remove((Object)msg))) {
            ObjectStore.destroy((Object)msg);
        }
        return result;
    }

    private boolean add(IPSEMessage msg) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (msg.getJMSMessageId() == null) {
            msg.setJMSMessageId(Long.toString(msg.getMessageId()));
        }
        boolean added = this._AllMessages.add((Object)msg);
        return added;
    }

    @Override
    public IPSEMessage getMessage(long mid, long seq, int size, Date exp, Date timestamp) {
        IPSEMessage msg = this.get(mid);
        if (msg == null) {
            msg = new PSEMessage2(mid, seq, size, exp, timestamp, null, null);
            if (this.DEBUG) {
                this.debug("Adding message w/o body; mid= " + mid);
            }
            this.add(msg);
        }
        return msg;
    }

    @Override
    public boolean addMessage(long mid, long seq, int size, Date exp, Date timestamp, String jmsId, byte[] msgBody) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this.DEBUG) {
            this.debug("PSEMessages: Adding mid= " + mid + " jmsId= " + jmsId);
        }
        if (msgBody == null) {
            throw new EAssertFailure("Message body cannot be null");
        }
        IPSEMessage msg = null;
        boolean added = false;
        try {
            msg = new PSEMessage2(mid, seq, size, exp, timestamp, jmsId, msgBody);
            added = this.add(msg);
        }
        catch (DuplicateKeyException dke) {
            added = false;
        }
        if (!added && !(msg = this.get(mid)).hasBody()) {
            if (this.DEBUG) {
                this.debug("addMessage(mid,...,body): Adding body to msg; mid= " + mid);
            }
            msg.setMessageBodyIfNull(msgBody);
            added = true;
            if (jmsId != null) {
                this._AllMessages.removeFromIndex(msgClass2, "getJMSMessageId()", (Object)msg);
                msg.setJMSMessageId(jmsId);
                this._AllMessages.addToIndex(msgClass2, "getJMSMessageId()", (Object)msg);
            }
        }
        if (added) {
            ObjectStore.migrate((Object)msg, (Placement)Database.of((Object)this), (boolean)false);
            ObjectStore.evict((Object)msg, (int)3);
        }
        return added;
    }

    @Override
    public boolean addMessage(long mid, long seq, int size, Date exp, Date timestamp, String jmsId, PSEByteArrayWrapper body) {
        if (this.DEBUG) {
            this.debug("PSEMessages: Adding mid= " + mid + " jmsId= " + jmsId);
        }
        PSEMessage2 msg = null;
        boolean added = false;
        try {
            msg = new PSEMessage2(mid, seq, size, exp, timestamp, jmsId, null);
            msg.setMessageBody(body);
            added = this.add(msg);
        }
        catch (DuplicateKeyException dke) {
            added = false;
        }
        return added;
    }

    @Override
    public void removingMsg(IPSEMessage msg) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        this._AllMessages.removeFromIndex(msgClass2, "getJMSMessageId()", (Object)msg);
    }

    @Override
    public IPSEMessage get(String jmsid) {
        IPSEMessage msg = (IPSEMessage)this.getJMSMsgIdIndex().get((Object)jmsid);
        return msg;
    }

    @Override
    public IPSEMessage get(long id) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        IPSEMessage msg = (IPSEMessage)this._AllMessages.getFromPrimaryIndex((Object)new Long(id));
        return msg;
    }

    @Override
    public IndexIterator getIterator() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._AllMessages.primaryIndexIterator();
    }

    @Override
    public IndexIterator getIterator(long strt) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (strt >= 0L) {
            return this._AllMessages.primaryIndexIterator((Object)new Long(strt));
        }
        return this._AllMessages.primaryIndexIterator();
    }

    @Override
    public IndexIterator getJMSIdIterator(String strt) {
        IndexIterator it = strt != null ? this.getJMSMsgIdIndex().iterator((Object)strt) : this.getJMSMsgIdIndex().iterator();
        return it;
    }

    @Override
    public String toStringAll() {
        StringBuffer buf = new StringBuffer("PSEMessages: ");
        buf.append("\tCountMessages: " + this.getCount());
        return buf.toString();
    }

    public String toString() {
        return "PSEMessages ";
    }

    public void preDestroyPersistent() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        ObjectStore.destroy((IPersistent)this._AllMessages);
    }

    private IndexMap getMsgIdIndex() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._AllMessages.getPrimaryIndex();
    }

    private IndexMap getJMSMsgIdIndex() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._AllMessages.getIndex(msgClass2, "getJMSMessageId()", true);
    }

    private void debug(String str) {
        this._debugObj.debug(str);
    }

    static {
        myOdiClassInfoInstance = PSEMessages2.getClassInfoInstance();
        String msgClassName = "progress.message.dbsc.pse.pc.pubsub.IPSEMessage";
        try {
            msgClass2 = Class.forName(msgClassName);
        }
        catch (ClassNotFoundException cnfe) {
            new EAssertFailure("Class Not Found: " + msgClassName).printStackTrace();
        }
    }

    public ObjectReference ODIgetRef() {
        return this.ODIref;
    }

    public void ODIsetRef(ObjectReference objectReference) {
        this.ODIref = objectReference;
    }

    public byte ODIgetState() {
        return this.ODIObjectState;
    }

    public void ODIsetState(byte by) {
        this.ODIObjectState = by;
    }

    protected synchronized Object clone() throws CloneNotSupportedException {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        ((PSEMessages2)super.clone()).ODIref = null;
        ((PSEMessages2)super.clone()).ODIObjectState = 0;
        return (PSEMessages2)super.clone();
    }

    public void preFlushContents() {
    }

    public void preClearContents() {
    }

    public void initializeContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        this._AllMessages = (OSTreeSet)genericObject.getClassField(1, classInfo);
    }

    public void flushContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        genericObject.setClassField(1, (Object)this._AllMessages, classInfo);
    }

    public void clearContents() {
        this._AllMessages = null;
    }

    public PSEMessages2(ClassInfo classInfo) {
    }

    private static final ClassInfo getClassInfoInstance() {
        try {
            return ClassInfo.get(Class.forName("progress.message.dbsc.pse.pc.pubsub.v2.PSEMessages2"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

