/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UTFDataFormatException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.ESecurityGeneralException;
import progress.message.msg.IDefaultPayloadHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.IRoutingHandle;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.DefaultPayloadInputWrapper;
import progress.message.msg.v26.DefaultPayloadOutputWrapper;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.Payload;
import progress.message.msg.v26.SidebandData;
import progress.message.resources.prMessageFormat;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.CryptoInfo;
import progress.message.zclient.CryptoInfoLinkedList;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.ISubject;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;
import progress.message.zclient.SubjectUtil;
import progress.message.zclient.prAccessor;

class DefaultPayload
extends Payload
implements IOperationHandle,
IRoutingHandle,
IDefaultPayloadHandle {
    private static final boolean DEBUG_TRACE_DATA = false;
    static final int s_dpMemSize = MemoryUtil.estimateBaseSize(DefaultPayload.class);
    private static int PAYLOAD_CHUNK_SIZE = 65536;
    private static final int RRS_SEND = 0;
    private static final int RRS_REQUEST = 2;
    private static final int RRS_REPLY = 3;
    private static final byte SUBJECT_MASK = 1;
    private static final byte BODY_MASK = 2;
    private static final byte SIDEBAND_MASK = 4;
    private byte[] m_prebodyBuffer = null;
    private int m_preBodyLength = 0;
    private boolean m_preBodyDirty = true;
    private byte[] m_bodyBuffer = null;
    private int m_bodyBufferLength = 0;
    private boolean m_hasBody = false;
    private boolean m_hasID = false;
    private long m_idHigh = 0L;
    private long m_idLow = 0L;
    private boolean m_hasSideband = false;
    private Subject m_replySubject = new Subject();
    private int m_raf;
    private int m_replyPrio;
    private byte m_requestProtection;
    private ISubject m_subject = null;
    private String m_routing;
    private byte[] m_routingUTF;
    private boolean m_hasRouting = false;
    private boolean m_isGSAPublication = false;
    private boolean m_isNonPersistentReplicated = false;
    private boolean m_hasUndeliveredDestination = false;
    private int m_txnId;
    private long m_trackingNum;
    private StreamUtilCounter m_utilCounter = null;
    private ISidebandData m_sidebandData;
    private byte[] m_sidebandDataCache = null;
    private boolean m_sidebandDataCacheLenDirty = false;
    private Object m_sidebandLock = new Object();
    private byte[] m_padArray = null;
    private boolean m_preBodyProtected = false;
    private boolean m_sidebandProtected = false;
    private boolean m_bodyProtected = false;
    private boolean m_isReadOnly = false;
    private boolean m_isEncrypted = false;
    private int m_cachedMemoryLength = -1;
    private int m_operationType = -1;
    private LinkedList m_operationMgramLinkedList = null;
    private int m_bitField1;
    static final int ROUTING_MASK = 1;
    static final int GSA_MASK = 2;
    static final int NON_PERSISTENT_REPLICATED_MASK = 4;
    static final int UNDELIVERED_DESTINATION_MASK = 8;

    public DefaultPayload(Mgram m) {
        super(m);
    }

    protected DefaultPayload(DefaultPayload dp, Mgram m) {
        super(dp, m);
        this.m_prebodyBuffer = dp.m_prebodyBuffer;
        this.m_preBodyLength = dp.m_preBodyLength;
        this.m_preBodyDirty = dp.m_preBodyDirty;
        this.m_bodyBuffer = dp.m_bodyBuffer;
        this.m_bodyBufferLength = dp.m_bodyBufferLength;
        this.m_hasBody = dp.m_hasBody;
        this.m_hasID = dp.m_hasID;
        this.m_idHigh = dp.m_idHigh;
        this.m_idLow = dp.m_idLow;
        this.m_hasSideband = dp.m_hasSideband;
        this.m_replySubject = dp.m_replySubject;
        this.m_replyPrio = dp.m_replyPrio;
        this.m_raf = dp.m_raf;
        this.m_requestProtection = dp.m_requestProtection;
        this.m_subject = dp.m_subject;
        this.m_routing = dp.m_routing;
        this.m_routingUTF = dp.m_routingUTF;
        this.m_hasRouting = dp.m_hasRouting;
        this.m_isGSAPublication = dp.m_isGSAPublication;
        this.m_isNonPersistentReplicated = dp.m_isNonPersistentReplicated;
        this.m_hasUndeliveredDestination = dp.m_hasUndeliveredDestination;
        this.m_txnId = dp.m_txnId;
        this.m_trackingNum = dp.m_trackingNum;
        this.m_utilCounter = dp.m_utilCounter;
        this.m_sidebandData = dp.m_sidebandData;
        this.m_sidebandDataCache = dp.m_sidebandDataCache;
        this.m_sidebandDataCacheLenDirty = dp.m_sidebandDataCacheLenDirty;
        this.m_padArray = dp.m_padArray;
        this.m_preBodyProtected = dp.m_preBodyProtected;
        this.m_sidebandProtected = dp.m_sidebandProtected;
        this.m_bodyProtected = dp.m_bodyProtected;
        this.m_isReadOnly = dp.m_isReadOnly;
        this.m_isEncrypted = dp.m_isEncrypted;
        this.m_cachedMemoryLength = dp.m_cachedMemoryLength;
        this.m_operationType = dp.m_operationType;
        this.m_operationMgramLinkedList = dp.m_operationMgramLinkedList;
        this.m_bitField1 = dp.m_bitField1;
    }

    @Override
    public Object clone(Mgram m) throws CloneNotSupportedException {
        DefaultPayload dp = new DefaultPayload(this, m);
        this.cloneInternalData(dp);
        return dp;
    }

    protected void cloneInternalData(DefaultPayload dp) throws CloneNotSupportedException {
        if (!this.m_preBodyDirty && this.m_prebodyBuffer != null) {
            dp.m_prebodyBuffer = new byte[this.m_preBodyLength];
            System.arraycopy(this.m_prebodyBuffer, 0, dp.m_prebodyBuffer, 0, this.m_preBodyLength);
        }
        if (this.m_sidebandData != null) {
            dp.m_sidebandData = (ISidebandData)this.m_sidebandData.clone();
        }
        if (this.m_sidebandDataCache != null) {
            dp.m_sidebandDataCache = new byte[this.m_sidebandDataCache.length];
            System.arraycopy(this.m_sidebandDataCache, 0, dp.m_sidebandDataCache, 0, this.m_sidebandDataCache.length);
        }
        if (this.m_bodyBuffer != null) {
            dp.m_bodyBuffer = new byte[this.m_bodyBufferLength];
            System.arraycopy(this.m_bodyBuffer, 0, dp.m_bodyBuffer, 0, this.m_bodyBufferLength);
        }
        dp.m_preBodyProtected = false;
        dp.m_sidebandProtected = false;
        dp.m_bodyProtected = false;
        if (this.supportsOperationHandle() && this.m_operationMgramLinkedList != null) {
            dp.m_operationMgramLinkedList = new LinkedList();
            for (IMgram subMgram : this.m_operationMgramLinkedList) {
                dp.m_operationMgramLinkedList.add(subMgram.clone());
            }
        }
    }

    @Override
    public Object shallowClone(Mgram m) throws CloneNotSupportedException {
        DefaultPayload dp = new DefaultPayload(this, m);
        this.shallowCloneInternalData(dp);
        return dp;
    }

    protected void shallowCloneInternalData(DefaultPayload dp) throws CloneNotSupportedException {
        if (this.m_sidebandData != null) {
            dp.m_sidebandData = (SidebandData)this.m_sidebandData.shallowClone();
        }
        if (this.supportsOperationHandle() && this.m_operationMgramLinkedList != null) {
            dp.m_operationMgramLinkedList = new LinkedList();
            for (IMgram subMgram : this.m_operationMgramLinkedList) {
                dp.m_operationMgramLinkedList.add(subMgram.shallowClone());
            }
        }
    }

    @Override
    public Object protectedClone(Mgram m) throws CloneNotSupportedException {
        this.protectAll();
        DefaultPayload dp = new DefaultPayload(this, m);
        this.protectedCloneInternalData(dp);
        return dp;
    }

    protected void protectAll() {
        this.m_preBodyProtected = true;
        this.m_sidebandProtected = true;
        this.m_bodyProtected = true;
    }

    protected void protectedCloneInternalData(DefaultPayload dp) throws CloneNotSupportedException {
        if (this.supportsOperationHandle() && this.m_operationMgramLinkedList != null) {
            dp.m_operationMgramLinkedList = new LinkedList();
            for (IMgram subMgram : this.m_operationMgramLinkedList) {
                dp.m_operationMgramLinkedList.add(subMgram.protectedClone());
            }
        }
    }

    @Override
    protected boolean isDirty() {
        return this.m_preBodyDirty || this.m_sidebandData != null && this.m_sidebandData.isDirty() || this.m_cachedMemoryLength == -1;
    }

    @Override
    public void protect() {
        this.m_preBodyProtected = true;
        this.m_sidebandProtected = true;
        this.m_bodyProtected = true;
    }

    private void unprotectPreBody() {
        if (this.m_preBodyProtected) {
            this.checkReadOnly();
            if (this.m_prebodyBuffer != null && !this.m_preBodyDirty) {
                this.m_prebodyBuffer = this.copyByteArray(this.m_prebodyBuffer);
            }
            this.m_replySubject = (Subject)this.m_replySubject.clone();
            if (this.m_subject != null) {
                this.m_subject = (Subject)this.m_subject.protectedClone();
            }
            this.m_preBodyProtected = false;
        }
    }

    private void unprotectSideBand() {
        if (this.m_sidebandProtected && !this.m_isReadOnly) {
            this.checkReadOnly();
            if (this.m_sidebandData != null) {
                this.m_sidebandData = (ISidebandData)this.m_sidebandData.clone();
            }
            if (this.m_sidebandDataCache != null) {
                byte[] newCache = new byte[this.m_sidebandDataCache.length];
                System.arraycopy(this.m_sidebandDataCache, 0, newCache, 0, this.m_sidebandDataCache.length);
                this.m_sidebandDataCache = newCache;
            }
            this.m_sidebandProtected = false;
        }
    }

    public void checkReadOnly() {
        if (this.m_isReadOnly) {
            throw new EAssertFailure("Payload is read only");
        }
    }

    private void unprotectBody() {
        if (this.m_bodyProtected) {
            this.checkReadOnly();
            if (this.m_bodyBuffer != null) {
                this.m_bodyBuffer = this.copyByteArray(this.m_bodyBuffer);
            }
            if (this.m_padArray != null) {
                this.m_padArray = this.copyByteArray(this.m_padArray);
            }
            this.m_bodyProtected = false;
        }
    }

    private byte[] copyByteArray(byte[] src) {
        byte[] result = new byte[src.length];
        System.arraycopy(src, 0, result, 0, result.length);
        return result;
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        this.checkReadOnly();
        this.m_utilCounter = sc;
        if (this.m_utilCounter == null) {
            this.m_utilCounter = new StreamUtilCounter(false);
        }
        this.readPreBodyFromStream(is);
        if (this.m_hasSideband) {
            this.readSidebandFromStream(is);
        }
        if (this.supportsSidebandSubjectBody()) {
            if (this.m_hasBody) {
                int length = this.m_mgram.getMessageLength() - this.m_utilCounter.getCounter();
                this.m_utilCounter.checkMessageLength(length);
                this.m_bodyBuffer = new byte[length];
                this.m_bodyBufferLength = length;
                this.m_utilCounter.readBytes(is, this.m_bodyBuffer, 0, length);
            }
        } else if (this.supportsSimpleBody()) {
            int lengthLeft = this.m_mgram.getMessageLength() - this.m_utilCounter.getCounter();
            if (lengthLeft > 0) {
                this.m_bodyBuffer = new byte[lengthLeft];
                this.m_bodyBufferLength = lengthLeft;
                this.m_utilCounter.readBytes(is, this.m_bodyBuffer, 0, lengthLeft);
                this.m_hasBody = true;
            } else {
                this.m_hasBody = false;
            }
        } else {
            throw new EMgramFormatError(prMessageFormat.format(prAccessor.getString("STR071"), new Object[]{Byte.toString(this.m_mgram.getType())}));
        }
        if (this.m_mgram.isSecure()) {
            this.m_utilCounter.skip(is, this.m_mgram.getMessagePad());
        }
        this.m_mgram.setStatus(3);
    }

    void setPreBodyBuffer(byte[] preBody) {
        this.checkReadOnly();
        this.m_prebodyBuffer = preBody;
        this.m_preBodyDirty = false;
        this.m_preBodyLength = preBody.length;
    }

    void setSidebandBuffer(byte[] sideband) {
        this.checkReadOnly();
        if (this.m_sidebandData != null) {
            this.m_sidebandData.setSidebandBuffer(sideband);
        } else {
            this.m_sidebandDataCache = sideband;
            this.m_sidebandDataCacheLenDirty = true;
        }
    }

    void setPadBuffer(byte[] pad) {
        this.checkReadOnly();
        this.m_padArray = pad;
    }

    @Override
    byte[] getPadBuffer() {
        return this.m_padArray;
    }

    private void readPreBodyFromStream(InputStream is) throws IOException, EMgramFormatError {
        this.m_preBodyDirty = true;
        if (this.m_mgram.hasID()) {
            this.m_idHigh = this.m_utilCounter.readLong(is);
            this.m_idLow = this.m_utilCounter.readLong(is);
            this.m_hasID = true;
        }
        if (this.m_mgram.getSubjectFormat() != 4) {
            this.initMSubject();
            this.m_utilCounter.incrementCounter(DefaultPayload.readSubjectFromStream((Subject)this.m_subject, is, this.m_mgram.getSubjectFormat()));
        }
        this.readRequestReplyBytes(is);
        if (this.m_mgram.isGuarenteedInternal()) {
            this.m_trackingNum = this.m_utilCounter.read6ByteLong(is);
        }
        if (this.m_mgram.hasTxn()) {
            this.m_txnId = this.m_utilCounter.readInt(is);
        }
        this.readBitFields(is);
        if (this.m_hasRouting) {
            this.m_routingUTF = this.m_utilCounter.readUTFString(is);
        }
        if (this.supportsOperationHandle()) {
            this.m_operationType = this.m_utilCounter.readInt(is);
        }
        byte subjectBodyBits = 0;
        if (this.supportsSidebandSubjectBody()) {
            subjectBodyBits = this.m_utilCounter.readByte(is);
            this.m_hasBody = this.checkAndUpdateHasBody(subjectBodyBits, (byte)2, this.m_hasBody);
        }
        if (subjectBodyBits & true) {
            this.initMSubject();
            ((Subject)this.m_subject).initSubjectUTF(this.m_utilCounter.readUTFString(is));
        }
        this.m_hasSideband = this.checkAndUpdateHasBody(subjectBodyBits, (byte)4, this.m_hasSideband);
        this.m_preBodyLength = this.m_utilCounter.getCounter();
    }

    private boolean checkAndUpdateHasBody(byte subjectBodyBits, byte BODY_MASK, boolean m_hasBodyParam) {
        boolean m_hasBody = m_hasBodyParam;
        if ((subjectBodyBits & BODY_MASK) != 0) {
            m_hasBody = true;
        }
        return m_hasBody;
    }

    private void initMSubject() {
        if (this.m_subject == null) {
            this.m_subject = new Subject();
        }
    }

    private void readSidebandFromStream(InputStream is) throws IOException {
        this.m_sidebandData = null;
        int sidebandLength = 0;
        sidebandLength = this.m_utilCounter.readInt(is);
        this.m_sidebandDataCache = new byte[sidebandLength];
        this.m_utilCounter.readBytes(is, this.m_sidebandDataCache, 4, sidebandLength - 4);
        ArrayUtil.writeInt(this.m_sidebandDataCache, 0, sidebandLength);
        this.m_sidebandDataCacheLenDirty = true;
    }

    private void readBitFields(InputStream is) throws IOException {
        this.m_bitField1 = this.m_utilCounter.readInt(is);
        this.m_hasRouting = (this.m_bitField1 & 1) > 0;
        this.m_isGSAPublication = (this.m_bitField1 & 2) > 0;
        this.m_isNonPersistentReplicated = (this.m_bitField1 & 4) > 0;
        this.m_hasUndeliveredDestination = (this.m_bitField1 & 8) > 0;
    }

    private void readRequestReplyBytes(InputStream is) throws IOException, EMgramFormatError {
        switch (this.m_mgram.getRequestReplyFieldType()) {
            case 0: {
                break;
            }
            case 2: {
                byte requestReplyBits = this.m_utilCounter.readByte(is);
                this.m_replyPrio = requestReplyBits & 0xF;
                this.m_raf = (requestReplyBits & 0xF0) >>> 4;
                this.m_utilCounter.incrementCounter(DefaultPayload.readSubjectFromStream(this.m_replySubject, is, this.m_raf));
                switch (this.m_raf) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.m_replySubject.initSubjectUTF(this.m_utilCounter.readUTFString(is));
                        break;
                    }
                }
                if (!this.m_mgram.isSecure()) break;
                this.m_requestProtection = this.m_mgram.getSecurity();
                break;
            }
            case 3: {
                if (!this.m_mgram.isSecure()) break;
                this.m_requestProtection = this.m_mgram.getSecurity();
                break;
            }
            default: {
                throw new EMgramFormatError(prMessageFormat.format(prAccessor.getString("STR067"), new Object[]{Integer.toString(this.m_mgram.getRequestReplyFieldType())}));
            }
        }
    }

    private final int calculateRequestReplyBytesLength() {
        int length = 0;
        switch (this.m_mgram.getRequestReplyFieldType()) {
            case 0: {
                break;
            }
            case 2: {
                ++length;
                length += DefaultPayload.calculateSubjectLength(this.m_replySubject, this.m_raf, true);
                break;
            }
            case 3: {
                break;
            }
        }
        return length;
    }

    private static final int calculateSubjectLength(ISubject s, int format, boolean includeUTF) {
        if (s == null) {
            return 0;
        }
        int utfLen = includeUTF ? s.getSubjectUTFLength() : 0;
        switch (format) {
            case 2: {
                return 4 + utfLen;
            }
            case 3: {
                int varLength = 2 + s.getMatchVector().length * 4;
                if (s.isReply() && s.hasSubjectTracking()) {
                    return varLength + 4 + utfLen;
                }
                return varLength + utfLen;
            }
            case 1: {
                return s.getSubjectUTFLength() + utfLen;
            }
            case 5: {
                return s.getSerializedLength();
            }
            case 0: 
            case 4: {
                return 0;
            }
        }
        throw new EAssertFailure("Unrecognized subject format: " + format);
    }

    private final void writeRequestReplyBytes(OutputStream os) throws IOException {
        block0 : switch (this.m_mgram.getRequestReplyFieldType()) {
            case 0: {
                break;
            }
            case 2: {
                byte requestReplyBits = (byte)(this.m_replyPrio & 0xF);
                requestReplyBits = (byte)(requestReplyBits | (byte)(this.m_raf & 0xF) << 4);
                os.write(requestReplyBits);
                DefaultPayload.writeSubjectToStream(this.m_replySubject, this.m_raf, os);
                switch (this.m_raf) {
                    case 0: 
                    case 5: {
                        break block0;
                    }
                    case 4: {
                        throw new EAssertFailure("Invalid reply address format: AF_SUBJECT_DH");
                    }
                }
                os.write(this.m_replySubject.getSubjectUTF());
                break;
            }
            case 3: {
                break;
            }
        }
    }

    @Override
    boolean hasID() {
        return this.m_hasID;
    }

    @Override
    byte[] getID() {
        byte[] result = new byte[16];
        ArrayUtil.writeLong(result, 0, this.m_idHigh);
        ArrayUtil.writeLong(result, 8, this.m_idLow);
        return result;
    }

    @Override
    void setID(byte[] id) {
        this.checkReadOnly();
        this.setPreBodyDirty();
        this.unprotectPreBody();
        this.m_idHigh = ArrayUtil.readLong(id, 0);
        this.m_idLow = ArrayUtil.readLong(id, 8);
    }

    @Override
    public boolean isEncrypted() {
        return this.m_isEncrypted;
    }

    void setEncrypted() {
        this.m_isReadOnly = true;
        if (this.m_sidebandData != null) {
            this.m_sidebandData.setReadOnly();
        }
        this.m_isEncrypted = true;
    }

    void unsetDirtyFlagInPrebody() {
        if (this.m_preBodyDirty) {
            this.m_preBodyDirty = false;
        }
    }

    void setDecrypted() {
        this.m_isEncrypted = false;
    }

    void disableReadOnly() {
        this.m_isReadOnly = false;
        if (this.m_sidebandData != null) {
            this.m_sidebandData.disableReadOnly();
        }
    }

    @Override
    void setTxn(int tid) {
        this.checkReadOnly();
        this.setPreBodyDirty();
        this.unprotectPreBody();
        this.m_txnId = tid;
    }

    @Override
    void removeTxn() {
        this.setTxn(0);
    }

    @Override
    int getTxnId() {
        return this.m_txnId;
    }

    private void setPreBodyDirty() {
        this.checkReadOnly();
        this.m_preBodyDirty = true;
    }

    @Override
    void clearID() {
        this.checkReadOnly();
        if (this.m_idHigh != 0L || this.m_idLow != 0L || this.m_hasID) {
            this.setPreBodyDirty();
            this.unprotectPreBody();
        }
        this.m_idHigh = 0L;
        this.m_idLow = 0L;
        this.m_hasID = false;
    }

    @Override
    byte[] getRawPreBody() {
        this.syncPreBodyBuffer();
        return this.m_prebodyBuffer;
    }

    @Override
    public void setGuarenteed(long tracking) {
        this.checkReadOnly();
        this.setPreBodyDirty();
        this.unprotectPreBody();
        this.m_trackingNum = tracking;
    }

    @Override
    void setRequest(int tracking, String replySubject) {
        this.checkReadOnly();
        this.setPreBodyDirty();
        this.unprotectPreBody();
        this.m_replySubject = new Subject(replySubject);
        this.m_replySubject.initSubjectTracking(tracking);
        this.m_raf = 5;
    }

    @Override
    public ISubject getReplySubject() {
        return this.m_replySubject;
    }

    @Override
    int getReplyFormat() {
        return this.m_raf;
    }

    @Override
    void setReplyFormat(int format) {
        this.checkReadOnly();
        if (this.m_raf != format) {
            this.setPreBodyDirty();
            this.m_raf = format;
        }
    }

    @Override
    boolean canHaveReplyTracking() {
        if (this.m_subject == null) {
            return false;
        }
        return this.m_subject.isReply() && this.m_subject.hasSubjectTracking();
    }

    @Override
    protected byte[] toByteArray() {
        byte[] bodyBuffer;
        this.sync();
        int length = 0;
        length += this.m_preBodyLength;
        if (this.m_hasSideband) {
            length = this.m_sidebandData != null ? (length += this.getSidebandData().getSerializedLength()) : (length += this.m_sidebandDataCache.length);
        }
        if ((bodyBuffer = this.getRawBodyBuffer()) != null) {
            length += this.getBodyLength();
        }
        byte[] newByteArray = new byte[length];
        int pos = 0;
        if (this.m_prebodyBuffer != null) {
            System.arraycopy(this.m_prebodyBuffer, 0, newByteArray, pos, this.m_preBodyLength);
            pos += this.m_preBodyLength;
        }
        if (this.m_hasSideband) {
            int sidebandLength;
            byte[] sidebandBuffer;
            if (this.m_sidebandData != null) {
                sidebandBuffer = this.m_sidebandData.getRawSidebandBuffer();
                sidebandLength = this.m_sidebandData.getSerializedLength();
            } else {
                sidebandBuffer = this.m_sidebandDataCache;
                sidebandLength = sidebandBuffer.length;
            }
            System.arraycopy(sidebandBuffer, 0, newByteArray, pos, sidebandLength);
            pos += sidebandLength;
        }
        if (this.m_hasBody) {
            System.arraycopy(this.m_bodyBuffer, 0, newByteArray, pos, this.m_bodyBufferLength);
            pos += this.m_bodyBufferLength;
        }
        return newByteArray;
    }

    void syncSidebandBuffer() {
        if (this.m_hasSideband && this.m_sidebandData != null && this.m_sidebandData.isDirty()) {
            if (!this.m_isReadOnly) {
                this.unprotectSideBand();
            }
            if (this.m_sidebandData != null) {
                this.m_sidebandData.sync();
            }
        }
    }

    @Override
    byte[] getRawSidebandBuffer() {
        if (this.m_sidebandData != null) {
            return this.m_sidebandData.getRawSidebandBuffer();
        }
        return this.m_sidebandDataCache;
    }

    @Override
    byte[] getRawBodyBuffer() {
        return this.m_bodyBuffer;
    }

    private void syncPreBodyBuffer() {
        if (this.m_preBodyDirty && !this.isEncrypted()) {
            this.checkReadOnly();
            this.unprotectPreBody();
            this.m_preBodyLength = this.calculatePreBodyLength();
            this.m_prebodyBuffer = new byte[this.m_preBodyLength];
            try {
                this.writePreBodyToStream(ArrayUtil.getOutputStream(this.m_prebodyBuffer, 0));
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new EAssertFailure(ex.getMessage());
            }
            this.m_preBodyDirty = false;
        }
    }

    private final int calculatePreBodyLength() {
        int preBodyCounter = 0;
        if (this.m_preBodyDirty && !this.isEncrypted()) {
            if (this.m_mgram.hasID()) {
                preBodyCounter += 16;
            }
            preBodyCounter += DefaultPayload.calculateSubjectLength(this.m_subject, this.m_mgram.getSubjectFormat(), this.supportsSidebandSubjectBody());
            preBodyCounter += this.calculateRequestReplyBytesLength();
            if (this.m_mgram.isGuarenteedInternal()) {
                preBodyCounter += 6;
            }
            if (this.m_mgram.hasTxn()) {
                preBodyCounter += 4;
            }
            if (this.supportsSidebandSubjectBody()) {
                ++preBodyCounter;
            }
            preBodyCounter += 4;
            if (this.m_hasRouting) {
                preBodyCounter += this.m_routingUTF.length;
            }
            if (this.supportsOperationHandle()) {
                preBodyCounter += 4;
            }
            return preBodyCounter;
        }
        return this.m_prebodyBuffer.length;
    }

    private final void writePreBodyToStream(OutputStream os) throws IOException {
        if (this.m_preBodyDirty && !this.isEncrypted()) {
            if (this.m_mgram.hasID()) {
                StreamUtil.writeLong(this.m_idHigh, os);
                StreamUtil.writeLong(this.m_idLow, os);
            }
            boolean needsUTF = !DefaultPayload.writeSubjectToStream(this.m_subject, this.m_mgram.getSubjectFormat(), os);
            this.writeRequestReplyBytes(os);
            if (this.m_mgram.isGuarenteedInternal()) {
                StreamUtil.write6ByteLong(this.m_trackingNum, os);
            }
            if (this.m_mgram.hasTxn()) {
                StreamUtil.writeInt(this.m_txnId, os);
            }
            StreamUtil.writeInt(this.m_bitField1, os);
            if (this.m_hasRouting) {
                if (this.m_routingUTF != null) {
                    os.write(this.m_routingUTF);
                } else {
                    StreamUtil.writeUTF(this.m_routing, os);
                }
            }
            if (this.supportsOperationHandle()) {
                StreamUtil.writeInt(this.m_operationType, os);
            }
            if (this.supportsSidebandSubjectBody()) {
                int subjectBodyBits = 0;
                if (needsUTF && this.m_subject.isSubjectSet()) {
                    subjectBodyBits |= 1;
                }
                if (this.m_hasSideband) {
                    subjectBodyBits |= 4;
                }
                if (this.m_hasBody) {
                    subjectBodyBits |= 2;
                }
                os.write(subjectBodyBits);
                if (needsUTF && this.m_subject.isSubjectSet()) {
                    os.write(this.m_subject.getSubjectUTF());
                }
            }
        } else {
            os.write(this.m_prebodyBuffer, 0, this.m_preBodyLength);
        }
    }

    private static final boolean writeSubjectToStream(ISubject sub, int addressFormat, OutputStream os) throws IOException {
        switch (addressFormat) {
            case 3: {
                byte[] address = SubjectUtil.convertMatchVectorToVarFmt(sub.getMatchVector());
                int len = (address[0] & 0xFF) << 10 | (address[1] & 0xFF) << 2;
                if (sub.isReply() && sub.hasSubjectTracking() && (address[1] = (byte)(address[1] + 1)) == 0) {
                    address[0] = (byte)(address[0] + 1);
                }
                os.write(address, 0, len + 2);
                if (!sub.isReply() || !sub.hasSubjectTracking()) break;
                StreamUtil.writeInt((int)sub.getSubjectTracking(), os);
                break;
            }
            case 2: {
                StreamUtil.writeInt(sub.getMatchVector()[0], os);
                break;
            }
            case 1: {
                byte[] address = sub.getSubjectUTF();
                os.write(address, 0, address.length);
                break;
            }
            case 5: {
                sub.writeToStream(os);
                return true;
            }
            case 0: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private static final int readSubjectFromStream(Subject sub, InputStream is, int addressFormat) throws IOException {
        byte[] address = null;
        switch (addressFormat) {
            case 5: {
                return sub.initFromStream(is);
            }
            case 3: {
                byte byte1 = StreamUtil.readByte(is);
                byte byte2 = StreamUtil.readByte(is);
                int len = (byte1 & 0xFF) << 10 | (byte2 & 0xFF) << 2;
                boolean hasReplyTracking = false;
                if (len > 0) {
                    int[] mv = new int[len >> 2];
                    for (int i = 0; i < mv.length; ++i) {
                        mv[i] = StreamUtil.readInt(is);
                        if (i != 2 || mv[0] != SessionConfig.ISYS_SCODE || mv[1] != SessionConfig.USERS_SCODE || mv[2] != -1836570336) continue;
                        hasReplyTracking = true;
                        int[] newMV = new int[mv.length - 1];
                        System.arraycopy(mv, 0, newMV, 0, i + 1);
                        mv = newMV;
                    }
                    sub.initMatchVector(mv);
                }
                if (hasReplyTracking) {
                    sub.initSubjectTracking(StreamUtil.readInt(is));
                }
                return len + 2;
            }
            case 2: {
                int[] mv = new int[]{StreamUtil.readInt(is)};
                sub.initMatchVector(mv);
                return 4;
            }
            case 1: {
                address = StreamUtil.readUTFString(is);
                sub.initSubjectUTF(address);
                return address.length;
            }
            case 0: 
            case 4: {
                return 0;
            }
        }
        throw new EAssertFailure("Unrecognized address format: " + addressFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToStream(OutputStream os) throws IOException {
        this.writePreBodyToStream(os);
        if (this.supportsSidebandSubjectBody() && this.m_hasSideband) {
            ISidebandData sidebandData = null;
            byte[] sidebandDataCache = null;
            Object object = this.m_sidebandLock;
            synchronized (object) {
                sidebandData = this.m_sidebandData;
                sidebandDataCache = this.m_sidebandDataCache;
            }
            if (sidebandData != null) {
                sidebandData.writeToStream(os);
            } else {
                os.write(sidebandDataCache);
            }
        }
        if ((this.supportsSidebandSubjectBody() || this.supportsSimpleBody()) && this.m_hasBody) {
            this.chunkWrite(os, this.m_bodyBuffer, 0, this.m_bodyBufferLength, PAYLOAD_CHUNK_SIZE);
        }
        if (this.m_mgram.isSecure()) {
            if (!this.isEncrypted()) {
                boolean needPad = true;
                ISecureOutputStream sos = null;
                if (os instanceof ISecureOutputStream && !(sos = (ISecureOutputStream)((Object)os)).getMessageProtection().isSonicCipherSuite()) {
                    needPad = false;
                }
                if (needPad) {
                    int pad = this.m_mgram.getMessagePad();
                    byte[] padArray = new byte[pad];
                    os.write(padArray);
                }
                if (sos != null) {
                    sos.doFinal();
                }
            } else if (this.m_padArray != null) {
                os.write(this.m_padArray);
            }
        }
    }

    private boolean supportsSidebandSubjectBody() {
        switch (this.m_mgram.getType()) {
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    private boolean supportsSimpleBody() {
        switch (this.m_mgram.getType()) {
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 33: 
            case 36: 
            case 37: 
            case 38: {
                return true;
            }
        }
        return false;
    }

    private void chunkWrite(OutputStream os, byte[] data, int offset, int dataLength, int chunkSize) throws IOException {
        int remainder = dataLength % chunkSize;
        int numChunks = dataLength / chunkSize;
        if (numChunks != 0) {
            int currentPointer = offset;
            for (int count = 0; count < numChunks; ++count) {
                os.write(data, currentPointer, chunkSize);
                currentPointer += chunkSize;
                os.flush();
            }
            if (remainder != 0) {
                os.write(data, dataLength - remainder + offset, remainder);
            }
        } else {
            os.write(data, offset, dataLength);
        }
    }

    @Override
    int getReplyPriority() {
        return this.m_replyPrio;
    }

    @Override
    void setReplyPriority(int priority) {
        this.checkReadOnly();
        if (priority != this.m_replyPrio) {
            this.m_replyPrio = priority;
            this.setPreBodyDirty();
            this.unprotectPreBody();
        }
    }

    @Override
    ISidebandData getSidebandData() {
        try {
            this.unprotectSideBand();
            this.createSidebandDataFromCache();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.m_sidebandData;
    }

    @Override
    ISidebandData getSidebandDataReadOnly() {
        this.findSideBandData();
        return this.m_sidebandData;
    }

    @Override
    boolean hasSidebandData() {
        return this.m_hasSideband;
    }

    @Override
    void createSidebandDataIfNeeded() {
        if (this.m_sidebandData == null && this.m_sidebandDataCache == null) {
            this.checkReadOnly();
            this.m_hasSideband = true;
            this.m_sidebandData = new SidebandData();
            this.m_sidebandProtected = false;
            this.setPreBodyDirty();
            return;
        }
        this.findSideBandData();
    }

    private void findSideBandData() {
        try {
            this.createSidebandDataFromCache();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSidebandDataFromCache() {
        Object object = this.m_sidebandLock;
        synchronized (object) {
            if (this.m_sidebandDataCache != null) {
                SidebandData sidebandData = new SidebandData();
                sidebandData.fromByteArray(this.m_sidebandDataCache, 0);
                this.m_sidebandData = sidebandData;
                this.m_sidebandDataCache = null;
                this.m_sidebandDataCacheLenDirty = false;
            }
        }
    }

    @Override
    ISubject getSubject() {
        return this.m_subject;
    }

    @Override
    final void setSubject(ISubject subject, boolean SFChanged) {
        this.checkReadOnly();
        if (subject == null || SFChanged || !subject.strictlyEquals(this.m_subject)) {
            this.setPreBodyDirty();
            this.unprotectPreBody();
            this.m_subject = subject;
        }
    }

    @Override
    public long getGuarenteedTrackingNum() {
        return this.m_trackingNum;
    }

    @Override
    boolean hasBody() {
        return this.m_hasBody;
    }

    @Override
    void setBody(byte[] body, int length) {
        this.checkReadOnly();
        if (body != null && length > 0) {
            this.m_bodyBuffer = body;
            this.m_bodyBufferLength = length;
            this.m_hasBody = true;
            this.m_bodyProtected = false;
        } else {
            this.m_hasBody = false;
            this.m_bodyBuffer = null;
            this.m_bodyBufferLength = 0;
            this.m_bodyProtected = false;
        }
    }

    @Override
    int getBodyLength() {
        return this.m_bodyBufferLength;
    }

    @Override
    int getPreBodyLength() {
        this.syncPreBodyBuffer();
        return this.m_preBodyLength;
    }

    @Override
    void setSidebandData(ISidebandData sd) {
        this.checkReadOnly();
        if (sd != null) {
            this.m_sidebandData = sd;
            this.m_sidebandDataCache = null;
            this.m_sidebandDataCacheLenDirty = false;
            this.m_hasSideband = true;
            this.m_sidebandProtected = false;
        } else {
            this.m_hasSideband = false;
        }
    }

    @Override
    public int length() {
        this.syncSidebandBuffer();
        this.syncPreBodyBuffer();
        int length = 0;
        if (this.m_hasSideband) {
            length = this.m_sidebandData != null ? (length += this.m_sidebandData.getSerializedLength()) : (length += this.m_sidebandDataCache.length);
        }
        length += this.m_preBodyLength;
        if (this.m_hasBody) {
            length += this.m_bodyBufferLength;
        }
        return length;
    }

    @Override
    protected int memoryLength() {
        this.sync();
        return this.m_cachedMemoryLength;
    }

    @Override
    protected void saveMemory() {
        if (!this.m_isReadOnly) {
            this.setPreBodyDirty();
            this.m_prebodyBuffer = null;
            if (this.supportsOperationHandle() && this.m_operationMgramLinkedList != null && !this.m_operationMgramLinkedList.isEmpty()) {
                for (IMgram subMgram : this.m_operationMgramLinkedList) {
                    subMgram.saveMemory();
                }
            }
        }
        if (this.m_subject != null) {
            this.m_subject.saveMemory();
        }
    }

    @Override
    protected void syncPayload() {
        this.syncPayloadInternal();
    }

    private void syncPayloadInternal() {
        boolean calcMemSize = this.m_sidebandDataCacheLenDirty || this.isDirty();
        this.syncSidebandBuffer();
        this.syncPreBodyBuffer();
        if (calcMemSize) {
            int subjectSize = 0;
            if (!this.m_isEncrypted) {
                subjectSize += DefaultPayload.calculateSubjectLength(this.m_subject, this.m_mgram.getSubjectFormat(), this.supportsSidebandSubjectBody());
            }
            this.m_cachedMemoryLength = s_dpMemSize + subjectSize + (this.m_bodyBuffer == null ? 0 : this.m_bodyBuffer.length) + (this.m_prebodyBuffer == null ? 0 : this.m_prebodyBuffer.length) + (this.m_sidebandData == null ? 0 : this.m_sidebandData.memoryLength()) + (this.m_sidebandDataCache == null ? 0 : this.m_sidebandDataCache.length) + (this.m_padArray == null ? 0 : this.m_padArray.length) + DefaultPayload.calculateSubjectLength(this.m_replySubject, this.m_raf, true);
        }
        if (this.supportsOperationHandle() && this.m_operationMgramLinkedList != null && !this.m_operationMgramLinkedList.isEmpty()) {
            for (IMgram subMgram : this.m_operationMgramLinkedList) {
                subMgram.sync();
            }
        }
    }

    protected byte[] encryptPrimaryMgramWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        this.checkReadOnly();
        this.unprotectPreBody();
        this.unprotectSideBand();
        this.unprotectBody();
        this.sync();
        int keyLen = this.m_mgram.getMessageKey().length;
        byte[] key = new byte[keyLen];
        System.arraycopy(this.m_mgram.getMessageKey(), 0, key, 0, keyLen);
        CryptoInfoLinkedList encLinkedList = this.createEncInfoLinkedList(mp);
        this.m_padArray = mp.encrypt(key, encLinkedList);
        this.setEncrypted();
        return this.m_padArray;
    }

    @Override
    public byte[] encryptMessageWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        byte[] result = this.encryptPrimaryMgramWithMessageKey(mp);
        if (this.m_operationMgramLinkedList != null && !this.m_operationMgramLinkedList.isEmpty()) {
            for (IMgram subMgram : this.m_operationMgramLinkedList) {
                subMgram.getBrokerHandle().encryptMessageWithMessageKey(mp);
            }
        }
        return result;
    }

    @Override
    void decryptMessageWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        if (!this.isEncrypted()) {
            return;
        }
        this.disableReadOnly();
        this.unprotectPreBody();
        this.unprotectSideBand();
        this.unprotectBody();
        this.sync();
        int keyLen = this.m_mgram.getMessageKey().length;
        byte[] key = new byte[keyLen];
        System.arraycopy(this.m_mgram.getMessageKey(), 0, key, 0, keyLen);
        CryptoInfoLinkedList encLinkedList = this.createEncInfoLinkedList(mp);
        mp.decrypt(key, encLinkedList);
        this.m_padArray = null;
        this.setDecrypted();
        try {
            this.m_utilCounter = new StreamUtilCounter(false);
            ByteArrayInputStream bais = new ByteArrayInputStream(this.m_prebodyBuffer);
            this.readPreBodyFromStream(bais);
            this.m_utilCounter.resetCounter();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EMgramFormatError e) {
            e.printStackTrace();
        }
        if (this.m_operationMgramLinkedList != null && !this.m_operationMgramLinkedList.isEmpty()) {
            for (IMgram subMgram : this.m_operationMgramLinkedList) {
                subMgram.getBrokerHandle().decryptMessageWithMessageKey(mp);
            }
        }
    }

    @Override
    CryptoInfoLinkedList createMacInfoLinkedList() throws ESecurityGeneralException {
        this.syncAndCreateSideBandData();
        CryptoInfoLinkedList macLinkedList = new CryptoInfoLinkedList();
        macLinkedList.addLast(new CryptoInfo(this.m_prebodyBuffer, 0, this.m_preBodyLength));
        byte[] sideBandBuffer = this.getRawSidebandBuffer();
        if (sideBandBuffer != null) {
            macLinkedList.addLast(new CryptoInfo(sideBandBuffer, 0, this.m_sidebandData.getSerializedLength()));
        }
        if (this.m_bodyBuffer != null) {
            macLinkedList.addLast(new CryptoInfo(this.m_bodyBuffer, 0, this.m_bodyBufferLength));
        }
        return macLinkedList;
    }

    CryptoInfoLinkedList createEncInfoLinkedList(IMessageProtection mp) throws ESecurityGeneralException {
        byte[] sideBandBuffer;
        this.syncAndCreateSideBandData();
        this.m_mgram.recalculatePad(mp);
        int pad = this.m_mgram.getMessagePad();
        CryptoInfoLinkedList encLinkedList = new CryptoInfoLinkedList();
        if (this.m_preBodyLength > 0) {
            encLinkedList.addLast(new CryptoInfo(this.m_prebodyBuffer, 0, this.m_preBodyLength));
        }
        if ((sideBandBuffer = this.getRawSidebandBuffer()) != null) {
            encLinkedList.addLast(new CryptoInfo(sideBandBuffer, 0, this.m_sidebandData.getSerializedLength()));
        }
        if (this.m_bodyBuffer != null) {
            encLinkedList.addLast(new CryptoInfo(this.m_bodyBuffer, 0, this.m_bodyBufferLength));
        }
        if (!this.isEncrypted()) {
            CryptoInfo lastElement = encLinkedList.getLast();
            lastElement.setPad(pad);
        } else {
            if (this.m_padArray != null) {
                encLinkedList.addLast(new CryptoInfo(this.m_padArray, 0, this.m_padArray.length));
            }
            CryptoInfo lastElement = encLinkedList.getLast();
            lastElement.setPad(0);
        }
        return encLinkedList;
    }

    private void syncAndCreateSideBandData() throws EIntegrityCompromised {
        this.sync();
        try {
            this.createSidebandDataFromCache();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            EIntegrityCompromised ex1 = new EIntegrityCompromised(ex.toString());
            ex1.initCause(ex);
            throw ex1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            this.printMgramMessageID();
            log.println("Subject Format:");
            this.printAddressFormat(this.m_mgram.getSubjectFormat());
            log.println("Subject: " + this.getSubject());
            log.println("Reply Format: ");
            this.printAddressFormat(this.m_raf);
            log.println("Reply Subject: " + this.m_replySubject);
            this.printMgramReplyPriority();
            this.printMgramGuaranteedTrackingNumber();
            this.printMgramTransactionID();
            log.println("NON_PERSISTENT_REPLICATED: " + this.m_isNonPersistentReplicated);
            log.println("UNDELIVERED_DESTINATION: " + this.m_hasUndeliveredDestination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMgramMessageID() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Message ID: ");
            if (this.hasID()) {
                byte[] id = this.getID();
                for (int p = 0; p < id.length; ++p) {
                    log.print(Integer.toHexString(id[p]));
                }
                log.println();
            } else {
                log.println("NONE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printAddressFormat(int format) {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            switch (format) {
                case 0: {
                    log.println("NONE");
                    break;
                }
                case 1: {
                    log.println("AF_STRING");
                    break;
                }
                case 2: {
                    log.println("AF_FIXED");
                    break;
                }
                case 3: {
                    log.println("AF_VAR");
                    break;
                }
                default: {
                    log.println("UNKNOWN");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMgramReplyPriority() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Reply Priority: ");
            if (this.m_mgram.isRequest()) {
                log.println(this.getReplyPriority());
            } else {
                log.println("NONE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMgramGuaranteedTrackingNumber() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Guaranteed Tracking #: ");
            if (this.m_mgram.isGuarenteedInternal()) {
                log.println(this.m_trackingNum);
            } else {
                log.println("NONE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMgramTransactionID() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Transaction ID: ");
            if (this.m_mgram.hasTxn()) {
                log.println(this.getTxnId());
            } else {
                log.println("NONE");
            }
        }
    }

    @Override
    public ObjectInput getPayloadInputStreamHandle() {
        return new DefaultPayloadInputWrapper(this);
    }

    @Override
    public ObjectOutput getPayloadOutputStreamHandle() {
        return new DefaultPayloadOutputWrapper(this);
    }

    @Override
    final IOperationHandle getOperationHandle() {
        this.m_mgram.checkSupportsSubMgrams();
        return this;
    }

    @Override
    public void setOperationType(int operationType) {
        this.m_mgram.checkSupportsSubMgrams();
        this.checkReadOnly();
        this.setPreBodyDirty();
        this.unprotectPreBody();
        this.m_operationType = operationType;
    }

    @Override
    public int getOperationType() {
        this.m_mgram.checkSupportsSubMgrams();
        return this.m_operationType;
    }

    @Override
    public void addMgram(IMgram m) {
        this.m_mgram.checkSupportsSubMgrams();
        if (this.m_operationMgramLinkedList == null) {
            this.m_operationMgramLinkedList = new LinkedList();
        }
        this.m_operationMgramLinkedList.addLast(m);
    }

    @Override
    public LinkedList getMgramList() {
        this.m_mgram.checkSupportsSubMgrams();
        return this.getMgramListInternal();
    }

    protected LinkedList getMgramListInternal() {
        return this.m_operationMgramLinkedList;
    }

    @Override
    public int getMgramListNetworkLength() {
        if (this.m_operationMgramLinkedList == null || this.m_operationMgramLinkedList.isEmpty()) {
            return 0;
        }
        int result = 0;
        for (IMgram subMgram : this.m_operationMgramLinkedList) {
            result += subMgram.networkLength();
        }
        return result;
    }

    @Override
    public int getMgramListSerializedLength() {
        if (this.m_operationMgramLinkedList == null || this.m_operationMgramLinkedList.isEmpty()) {
            return 0;
        }
        int result = 0;
        for (IMgram subMgram : this.m_operationMgramLinkedList) {
            result += subMgram.serializedLength();
        }
        return result;
    }

    @Override
    public int getMgramListMemoryLength() {
        if (this.m_operationMgramLinkedList == null || this.m_operationMgramLinkedList.isEmpty()) {
            return 0;
        }
        int result = 0;
        for (IMgram subMgram : this.m_operationMgramLinkedList) {
            result += subMgram.memoryLength();
        }
        return result;
    }

    @Override
    public void macMgramListMessagesWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        if (this.m_operationMgramLinkedList == null || this.m_operationMgramLinkedList.isEmpty()) {
            return;
        }
        for (IMgram subMgram : this.m_operationMgramLinkedList) {
            subMgram.getBrokerHandle().macMessageWithMessageKey(mp);
        }
    }

    @Override
    public void macMgramListHeadersWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        if (this.m_operationMgramLinkedList == null || this.m_operationMgramLinkedList.isEmpty()) {
            return;
        }
        for (IMgram subMgram : this.m_operationMgramLinkedList) {
            subMgram.getBrokerHandle().macHeaderWithMessageKey(mp);
        }
    }

    @Override
    final IRoutingHandle getRoutingHandle() {
        return this;
    }

    @Override
    boolean supportsRouting() {
        return true;
    }

    @Override
    boolean supportsOperationHandle() {
        return this.m_mgram.getType() == 25;
    }

    @Override
    public boolean isPubSub() {
        return this.m_mgram.getType() == 2;
    }

    @Override
    public boolean isPTP() {
        return this.m_mgram.getType() == 12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRouting() {
        Mgram mgram = this.m_mgram;
        synchronized (mgram) {
            this.retrieveMRouting();
            if (this.m_routing == null) {
                return null;
            }
            int pos = -1;
            pos = this.m_routing.indexOf("::");
            if (pos != -1) {
                return this.m_routing.substring(0, pos);
            }
            pos = this.m_routing.indexOf("$$");
            if (pos != -1) {
                return this.m_routing.substring(0, pos);
            }
            return this.m_routing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRouting(String routing) {
        Mgram mgram = this.m_mgram;
        synchronized (mgram) {
            this.checkReadOnly();
            this.setPreBodyDirty();
            this.unprotectPreBody();
            if (routing == null) {
                this.resetRouting();
                return;
            }
            this.m_routing = routing.intern();
            this.configRouting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNodeToPath(String node) {
        Mgram mgram = this.m_mgram;
        synchronized (mgram) {
            this.checkReadOnly();
            this.setPreBodyDirty();
            this.unprotectPreBody();
            String r = this.getRouting();
            if (r == null || "".equals(r)) {
                this.m_routing = node;
            } else if (node != null && !"".equals(node) && !node.equals(r)) {
                this.m_routing = node + "$$" + this.m_routing;
            }
            if (this.m_routing != null && !"".equals(this.m_routing)) {
                this.configRouting();
            } else {
                this.resetRouting();
            }
            this.m_routing = this.m_routing == null ? null : this.m_routing.intern();
        }
    }

    private void configRouting() {
        try {
            this.m_routingUTF = StringUtil.stringToUTF(this.m_routing);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            // empty catch block
        }
        this.m_hasRouting = true;
        this.m_bitField1 |= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllRouting() {
        Mgram mgram = this.m_mgram;
        synchronized (mgram) {
            Vector<String> allNodes = new Vector<String>();
            this.retrieveMRouting();
            if (this.m_routing != null) {
                String SEP1 = "$$";
                String SEP2 = "::";
                String separator = null;
                if (this.m_routing.indexOf("$$") != -1) {
                    separator = "$$";
                } else if (this.m_routing.indexOf("::") != -1) {
                    separator = "::";
                }
                if (separator == null) {
                    allNodes.add(this.m_routing);
                } else {
                    String routingString = this.m_routing;
                    while (routingString != null && routingString.length() > 0) {
                        int i = routingString.indexOf(separator);
                        if (i != -1) {
                            allNodes.add(routingString.substring(0, i));
                            routingString = routingString.substring(i + separator.length());
                            continue;
                        }
                        allNodes.add(routingString);
                        routingString = null;
                    }
                }
            }
            return allNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAllRoutingString() {
        Mgram mgram = this.m_mgram;
        synchronized (mgram) {
            this.getRouting();
            return this.m_routing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNodeInPath(String targetNode) {
        Mgram mgram = this.m_mgram;
        synchronized (mgram) {
            if (targetNode == null || "".equals(targetNode)) {
                return false;
            }
            Vector nodes = this.getAllRouting();
            return nodes != null && nodes.contains(targetNode);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMultiHopRouting() {
        Mgram mgram = this.m_mgram;
        synchronized (mgram) {
            this.getRouting();
            return this.m_routing != null && this.m_routing.indexOf("::") != -1;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNextRouting(String targetNode) {
        Mgram mgram = this.m_mgram;
        synchronized (mgram) {
            String newRouting;
            this.checkReadOnly();
            this.setPreBodyDirty();
            this.unprotectPreBody();
            if (targetNode == null || targetNode.length() == 0) {
                return;
            }
            String r = this.getRouting();
            if (r != null && r.length() > 0 && !r.equals(targetNode)) {
                return;
            }
            this.m_routing = newRouting = this.m_routing.substring(2 + (r != null ? r.length() : 0));
            if (this.m_routing != null && !"".equals(this.m_routing)) {
                try {
                    this.m_routingUTF = StringUtil.stringToUTF(this.m_routing);
                }
                catch (UTFDataFormatException uTFDataFormatException) {}
            } else {
                this.resetRouting();
            }
            this.m_routing = this.m_routing == null ? null : this.m_routing.intern();
        }
    }

    private void resetRouting() {
        this.m_hasRouting = false;
        this.m_routing = null;
        this.m_routingUTF = null;
        this.m_bitField1 &= 0xFFFFFFFE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSourceRoutingNode() {
        Mgram mgram = this.m_mgram;
        synchronized (mgram) {
            this.retrieveMRouting();
            if (this.m_routing == null) {
                return null;
            }
            int pos = this.m_routing.lastIndexOf("$$");
            if (pos == -1) {
                return null;
            }
            return this.m_routing.substring(2 + pos);
        }
    }

    private void retrieveMRouting() {
        if (this.m_routing == null && this.m_routingUTF != null) {
            try {
                this.m_routing = StringUtil.UTFToString(this.m_routingUTF, 0).intern();
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGSAPublication() {
        Mgram mgram = this.m_mgram;
        synchronized (mgram) {
            return this.m_isGSAPublication;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGSAPublication(boolean b) {
        Mgram mgram = this.m_mgram;
        synchronized (mgram) {
            this.checkReadOnly();
            this.setPreBodyDirty();
            this.unprotectPreBody();
            this.m_isGSAPublication = b;
            this.m_bitField1 &= 0xFFFFFFFD;
            if (b) {
                this.m_bitField1 |= 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNonPersistentReplicated() {
        Mgram mgram = this.m_mgram;
        synchronized (mgram) {
            return this.m_isNonPersistentReplicated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNonPersistentReplicated(boolean b) {
        Mgram mgram = this.m_mgram;
        synchronized (mgram) {
            this.checkReadOnly();
            this.setPreBodyDirty();
            this.unprotectPreBody();
            this.m_isNonPersistentReplicated = b;
            this.m_bitField1 &= 0xFFFFFFFB;
            if (b) {
                this.m_bitField1 |= 4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasUndeliveredDestination() {
        Mgram mgram = this.m_mgram;
        synchronized (mgram) {
            return this.m_hasUndeliveredDestination;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUndeliveredDestination(boolean b) {
        Mgram mgram = this.m_mgram;
        synchronized (mgram) {
            this.checkReadOnly();
            this.setPreBodyDirty();
            this.unprotectPreBody();
            this.m_hasUndeliveredDestination = b;
            this.m_bitField1 &= 0xFFFFFFF7;
            if (b) {
                this.m_bitField1 |= 8;
            }
        }
    }

    @Override
    int getBitField1() {
        return this.m_bitField1;
    }

    @Override
    public boolean contains(Mgram m) {
        if (this.m_operationMgramLinkedList == null || this.m_operationMgramLinkedList.isEmpty()) {
            return false;
        }
        for (IMgram subMgram : this.m_operationMgramLinkedList) {
            if (!subMgram.contains(m)) continue;
            return true;
        }
        return false;
    }

    @Override
    public HashMap getPayloadProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("DP_BODY_BUFFER", this.m_bodyBuffer);
        result.put("DP_BODY_BUFFER_LENGTH", new Integer(this.m_bodyBufferLength));
        result.put("DP_BODY_PROTECTED", new Boolean(this.m_bodyProtected));
        result.put("DP_CACHED_MEMORY_LENGTH", new Integer(this.m_cachedMemoryLength));
        result.put("DP_HAS_BODY", new Boolean(this.m_hasBody));
        result.put("DP_HAS_ID", new Boolean(this.m_hasID));
        result.put("DP_HAS_SIDEBAND", new Boolean(this.m_hasSideband));
        result.put("DP_HAS_SUBJECT", new Boolean(this.m_subject != null && this.m_subject.isSubjectSet()));
        result.put("DP_ID_HIGH", new Long(this.m_idHigh));
        result.put("DP_ID_LOW", new Long(this.m_idLow));
        result.put("DP_IS_ENCRYPTED", new Boolean(this.m_isEncrypted));
        result.put("DP_IS_READ_ONLY", new Boolean(this.m_isReadOnly));
        result.put("DP_OPERATION_LINKED_LIST", this.m_operationMgramLinkedList);
        result.put("DP_OPERATION_TYPE", new Integer(this.m_operationType));
        result.put("DP_PAD_ARRAY", this.m_padArray);
        result.put("DP_PRE_BODY_BUFFER", this.m_prebodyBuffer);
        result.put("DP_PRE_BODY_LENGTH", new Integer(this.m_preBodyLength));
        result.put("DP_PRE_BODY_PROTECTED", new Boolean(this.m_preBodyProtected));
        result.put("DP_RAF", new Integer(this.m_raf));
        result.put("DP_REPLY_SUBJECT", this.m_replySubject);
        result.put("DP_REPLY_PRIO", new Integer(this.m_replyPrio));
        result.put("DP_REQUEST_PROTECTION", new Byte(this.m_requestProtection));
        result.put("DP_SIDEBAND_DATA", this.m_sidebandData);
        result.put("DP_SIDEBAND_DATA_CACHE", this.m_sidebandDataCache);
        result.put("DP_SIDEBAND_DATA_CACHE_LEN_DIRTY", new Boolean(this.m_sidebandDataCacheLenDirty));
        result.put("DP_SIDEBAND_PROTECTED", new Boolean(this.m_sidebandProtected));
        result.put("DP_SUBJECT", this.m_subject);
        result.put("DP_TRACKING_NUMBER", new Long(this.m_trackingNum));
        result.put("DP_TXN_ID", new Integer(this.m_txnId));
        return result;
    }

    @Override
    public void setPayloadProperties(HashMap map) {
        this.m_bodyBuffer = (byte[])map.get("DP_BODY_BUFFER");
        this.m_bodyBufferLength = (Integer)map.get("DP_BODY_BUFFER_LENGTH");
        this.m_bodyProtected = (Boolean)map.get("DP_BODY_PROTECTED");
        this.m_cachedMemoryLength = (Integer)map.get("DP_CACHED_MEMORY_LENGTH");
        this.m_hasBody = (Boolean)map.get("DP_HAS_BODY");
        this.m_hasID = (Boolean)map.get("DP_HAS_ID");
        this.m_hasSideband = (Boolean)map.get("DP_HAS_SIDEBAND");
        this.m_idHigh = (Long)map.get("DP_ID_HIGH");
        this.m_idLow = (Long)map.get("DP_ID_LOW");
        this.m_isEncrypted = (Boolean)map.get("DP_IS_ENCRYPTED");
        this.m_isReadOnly = (Boolean)map.get("DP_IS_READ_ONLY");
        this.m_operationMgramLinkedList = (LinkedList)map.get("DP_OPERATION_LINKED_LIST");
        this.m_operationType = (Integer)map.get("DP_OPERATION_TYPE");
        this.m_padArray = (byte[])map.get("DP_PAD_ARRAY");
        this.m_raf = (Integer)map.get("DP_RAF");
        this.m_replySubject = (Subject)map.get("DP_REPLY_SUBJECT");
        this.m_replyPrio = (Integer)map.get("DP_REPLY_PRIO");
        this.m_requestProtection = (Byte)map.get("DP_REQUEST_PROTECTION");
        this.m_sidebandData = (ISidebandData)map.get("DP_SIDEBAND_DATA");
        this.m_sidebandDataCache = (byte[])map.get("DP_SIDEBAND_DATA_CACHE");
        this.m_sidebandProtected = (Boolean)map.get("DP_SIDEBAND_PROTECTED");
        this.m_subject = (Subject)map.get("DP_SUBJECT");
        this.m_trackingNum = (Long)map.get("DP_TRACKING_NUMBER");
        this.m_txnId = (Integer)map.get("DP_TXN_ID");
        this.m_preBodyDirty = true;
        this.syncPayloadInternal();
    }
}

