/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.evs;

import com.sonicsw.blackbird.evs.nio.nwlink.INetworkLinkConfig;
import com.sonicsw.blackbird.http.client.HTTPClientFactory;
import com.sonicsw.blackbird.http.client.IHTTPCredentialsProvider;
import java.applet.Applet;
import java.util.Hashtable;
import java.util.Properties;
import progress.message.net.ProgressInetAddress;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.zclient.SessionConfig;

public class EVSNetworkLinkConfig
implements INetworkLinkConfig {
    private Hashtable m_props = null;
    private Applet m_applet = null;
    private boolean m_useBlocking = SessionConfig.USE_EVS_BLOCKING;
    private String m_linkType;
    private String m_remoteHost;
    private int m_remotePort;
    private int m_backLog;
    private String m_localHost;
    private int m_localPort;
    private boolean m_tcpNoDelay;
    private static final boolean m_tcpKeepAlive = false;
    private int m_socketMinRcvBufferSize;
    private int m_socketMinSendBufferSize;
    private int m_socketMaxRcvBufferSize;
    private int m_socketMaxSendBufferSize;
    private int m_socketInitialRcvBufferSize;
    private int m_socketInitialSendBufferSize;
    private int m_socketSoTimeout = 0;
    private boolean m_useHTTPProxy = false;
    IHttpProxyConfig m_proxyConfig = null;
    private IHTTPCredentialsProvider m_httpCreds;
    private IHTTPCredentialsProvider m_httpProxyCreds;
    private boolean m_HTTPAllowInteraction = false;
    private int m_HTTPMaxRequestSize;
    private int m_HTTPRequestRetries;
    private boolean m_HTTPMapHostNameToIP;
    private long m_HTTPServerReadResponseTimeout;
    private long m_HTTPServerIdleTimeout;
    private long m_HTTPServerConnectionIdleTimeout;
    private boolean m_httpPipeliningEnabled = true;
    private Properties m_HTTPCustomHeaders = new Properties();
    private int m_httpConnectTimeout = SessionConfig.HTTP_CONNECT_TIMEOUT;
    private int m_httpCloseTimeout = SessionConfig.HTTP_CLOSE_TIMEOUT;

    private EVSNetworkLinkConfig(String linkType, String remoteHost, int remotePort, IHttpProxyConfig pConfig) {
        this.m_linkType = linkType;
        this.m_remoteHost = remoteHost;
        this.m_remotePort = remotePort;
        this.m_localPort = -1;
        this.m_localHost = null;
        this.m_tcpNoDelay = SessionConfig.TCP_NODELAY;
        if (this.m_linkType == "http") {
            this.m_socketMaxRcvBufferSize = SessionConfig.HTTP_SOCKET_MAX_RCV_BUFFER_SIZE;
            this.m_socketMaxSendBufferSize = SessionConfig.HTTP_SOCKET_MAX_SEND_BUFFER_SIZE;
            this.m_socketMinRcvBufferSize = SessionConfig.HTTP_SOCKET_MIN_RCV_BUFFER_SIZE;
            this.m_socketMinSendBufferSize = SessionConfig.HTTP_SOCKET_MIN_SEND_BUFFER_SIZE;
            this.m_socketInitialRcvBufferSize = SessionConfig.HTTP_SOCKET_INITIAL_RCV_BUFFER_SIZE;
            this.m_socketInitialSendBufferSize = SessionConfig.HTTP_SOCKET_INITIAL_SEND_BUFFER_SIZE;
        } else {
            this.m_socketMaxRcvBufferSize = SessionConfig.SOCKET_MAX_RCV_BUFFER_SIZE;
            this.m_socketMaxSendBufferSize = SessionConfig.SOCKET_MAX_SEND_BUFFER_SIZE;
            this.m_socketMinRcvBufferSize = SessionConfig.SOCKET_MIN_RCV_BUFFER_SIZE;
            this.m_socketMinSendBufferSize = SessionConfig.SOCKET_MIN_SEND_BUFFER_SIZE;
            this.m_socketInitialRcvBufferSize = SessionConfig.SOCKET_INITIAL_RCV_BUFFER_SIZE;
            this.m_socketInitialSendBufferSize = SessionConfig.SOCKET_INITIAL_SEND_BUFFER_SIZE;
        }
        this.m_useBlocking = SessionConfig.USE_EVS_BLOCKING_HTTP_CLIENT;
        this.m_proxyConfig = pConfig;
        if (this.m_proxyConfig == null || this.m_proxyConfig.getHost() == null || this.m_proxyConfig.getHost().trim().length() == 0) {
            this.m_useHTTPProxy = false;
        } else {
            this.m_useHTTPProxy = true;
            String user = this.m_proxyConfig.getUserName();
            String password = this.m_proxyConfig.getUserPassword();
            this.m_httpProxyCreds = user != null && password != null && user.length() > 0 && password.length() > 0 ? HTTPClientFactory.createCredentialsProvider(user, password) : HTTPClientFactory.getDefaultCredentialsProvider();
        }
        this.m_httpCreds = HTTPClientFactory.getDefaultCredentialsProvider();
    }

    public EVSNetworkLinkConfig(String linkType, String remoteHost, int remotePort, Hashtable props, IHttpProxyConfig pConfig) {
        this(linkType, remoteHost, remotePort, pConfig);
        this.m_props = props;
        this.readProperties();
    }

    public EVSNetworkLinkConfig(String linkType, String remoteHost, int remotePort, Applet applet, IHttpProxyConfig pConfig) {
        this(linkType, remoteHost, remotePort, pConfig);
        this.m_applet = applet;
        this.readProperties();
    }

    public EVSNetworkLinkConfig(String linkType, ProgressInetAddress address, int localPort, int backLog, Properties props) {
        this.m_linkType = linkType;
        this.m_backLog = backLog;
        this.m_localPort = localPort;
        this.m_localHost = address.getHostAddress(false);
        this.m_props = props;
        this.m_tcpNoDelay = this.getBooleanProperty("TCP_NODELAY", true, true);
        this.m_socketMaxRcvBufferSize = this.getIntProperty("SOCKET_MAX_RCV_BUFFER_SIZE", 65536, true);
        this.m_socketInitialRcvBufferSize = this.getIntProperty("SOCKET_INITIAL_RCV_BUFFER_SIZE", 2048, true);
        this.m_socketMinRcvBufferSize = this.getIntProperty("SOCKET_MIN_RCV_BUFFER_SIZE", 2048, true);
        this.m_socketMaxSendBufferSize = this.getIntProperty("SOCKET_MAX_SEND_BUFFER_SIZE", 65536, true);
        this.m_socketInitialSendBufferSize = this.getIntProperty("SOCKET_INITIAL_SEND_BUFFER_SIZE", 2048, true);
        this.m_socketMinSendBufferSize = this.getIntProperty("SOCKET_MIN_SEND_BUFFER_SIZE", 2048, true);
        this.m_HTTPServerIdleTimeout = this.getLongProperty("HTTP_CLIENT_IDLE_TIMEOUT", 10000L, true);
        this.m_HTTPServerReadResponseTimeout = this.getLongProperty("HTTP_CLIENT_READ_TIMEOUT", 10000L, true);
        this.m_HTTPServerConnectionIdleTimeout = this.getLongProperty("HTTP_BROKER_READ_TIMEOUT", 20000L, true);
        this.m_httpPipeliningEnabled = this.getBooleanProperty("ENABLE_HTTP_PIPELINING", true, true);
        this.readProperties();
    }

    private final void readProperties() {
        this.m_HTTPMaxRequestSize = this.getIntProperty("HTTP_REQUEST_SIZE", 65535, false);
        this.m_HTTPRequestRetries = this.getIntProperty("HTTP_RETRY_ATTEMPTS", 3, false);
        this.m_HTTPAllowInteraction = this.getBooleanProperty("HTTP_ALLOW_INTERACTION", false, false);
        this.m_HTTPMapHostNameToIP = this.getBooleanProperty("HTTP_MAP_HOST_TO_IP", true, false);
        int customHTTPProps = this.getIntProperty("httpCustomHeaderCount", 0, false);
        for (int i = 0; i < customHTTPProps; ++i) {
            String value;
            String name = this.getStringProperty("httpCustomHeaderName_" + i, null);
            if (name == null) {
                new RuntimeException("Missing property httpCustomHeaderName_" + i + "!").printStackTrace();
            }
            if ((value = this.getStringProperty("httpCustomHeaderValue_" + i, null)) == null) {
                new RuntimeException("Missing property httpCustomHeaderValue_" + i + "!").printStackTrace();
            }
            this.m_HTTPCustomHeaders.put(name, value);
        }
    }

    public String getStringProperty(String propName, String defaultValue) {
        if (this.m_applet != null) {
            String val = this.m_applet.getParameter(propName);
            if (val == null) {
                return defaultValue;
            }
            return val;
        }
        if (this.m_props == null) {
            return defaultValue;
        }
        String val = (String)this.m_props.get(propName);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    private boolean getBooleanProperty(String propName, boolean defaultValue, boolean valIsObject) {
        if (this.m_applet != null) {
            String val = this.m_applet.getParameter(propName);
            if (val == null) {
                return defaultValue;
            }
            return Boolean.getBoolean(val);
        }
        if (this.m_props == null) {
            return defaultValue;
        }
        if (!valIsObject) {
            String val = (String)this.m_props.get(propName);
            if (val == null) {
                return defaultValue;
            }
            return Boolean.valueOf(val);
        }
        Boolean val = (Boolean)this.m_props.get(propName);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    private int getIntProperty(String propName, int defaultValue, boolean valIsObject) {
        if (this.m_applet != null) {
            String val = this.m_applet.getParameter(propName);
            if (val == null) {
                return defaultValue;
            }
            return Integer.parseInt(val);
        }
        if (this.m_props == null) {
            return defaultValue;
        }
        if (!valIsObject) {
            String val = (String)this.m_props.get(propName);
            if (val == null) {
                return defaultValue;
            }
            return Integer.parseInt(val);
        }
        Integer val = (Integer)this.m_props.get(propName);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    private long getLongProperty(String propName, long defaultValue, boolean valIsObject) {
        if (this.m_applet != null) {
            String val = this.m_applet.getParameter(propName);
            if (val == null) {
                return defaultValue;
            }
            return Long.parseLong(val);
        }
        if (this.m_props == null) {
            return defaultValue;
        }
        if (!valIsObject) {
            String val = (String)this.m_props.get(propName);
            if (val == null) {
                return defaultValue;
            }
            return Long.parseLong(val);
        }
        Long val = (Long)this.m_props.get(propName);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    @Override
    public final String getLinkType() {
        return this.m_linkType;
    }

    @Override
    public final boolean getBlockingIO() {
        return this.m_useBlocking;
    }

    @Override
    public String getLocalInterfaceAddress() {
        return this.m_localHost;
    }

    @Override
    public int getLocalPort() {
        return this.m_localPort;
    }

    @Override
    public String getRemoteInterfaceAddress() {
        return this.m_remoteHost;
    }

    @Override
    public int getRemotePort() {
        return this.m_remotePort;
    }

    @Override
    public int getTCPServerBackLog() {
        return this.m_backLog;
    }

    @Override
    public boolean getTCPKeelAlive() {
        return false;
    }

    @Override
    public boolean getTCPNoDelay() {
        return this.m_tcpNoDelay;
    }

    @Override
    public int getSocketSoTimeout() {
        return this.m_socketSoTimeout;
    }

    @Override
    public int getSocketMaxSendBufferSize() {
        return this.m_socketMaxSendBufferSize;
    }

    @Override
    public int getSocketMaxRcvBufferSize() {
        return this.m_socketMaxRcvBufferSize;
    }

    @Override
    public final int getSocketInitialSendBufferSize() {
        return this.m_socketInitialSendBufferSize;
    }

    @Override
    public final int getSocketInitialRcvBufferSize() {
        return this.m_socketInitialRcvBufferSize;
    }

    @Override
    public final int getSocketMinSendBufferSize() {
        return this.m_socketMinSendBufferSize;
    }

    @Override
    public final int getSocketMinRcvBufferSize() {
        return this.m_socketMinRcvBufferSize;
    }

    @Override
    public boolean getTCPLinger() {
        return false;
    }

    @Override
    public int getTCPLingerTime() {
        return 10;
    }

    @Override
    public IHTTPCredentialsProvider getHTTPCredentialsProvider() {
        return this.m_httpCreds;
    }

    @Override
    public boolean getHTTPMapHostToIp() {
        return this.m_HTTPMapHostNameToIP;
    }

    @Override
    public int getHTTPMaxMessagetSize() {
        return this.m_HTTPMaxRequestSize;
    }

    @Override
    public int getHTTPRetryAttempts() {
        return this.m_HTTPRequestRetries;
    }

    @Override
    public boolean getHTTPAllowUserInteraction() {
        return this.m_HTTPAllowInteraction;
    }

    @Override
    public long getHTTPServerReadResponseTimeout() {
        return this.m_HTTPServerReadResponseTimeout;
    }

    @Override
    public long getHTTPServerLinkIdleTimeout() {
        return this.m_HTTPServerIdleTimeout;
    }

    @Override
    public long getHTTPServerConnectionIdleTimeout() {
        return this.m_HTTPServerConnectionIdleTimeout;
    }

    @Override
    public boolean getHTTPPipeliningEnabled() {
        return this.m_httpPipeliningEnabled;
    }

    @Override
    public int getHTTPConnectTimeout() {
        return this.m_httpConnectTimeout;
    }

    @Override
    public int getHTTPCloseTimeout() {
        return this.m_httpCloseTimeout;
    }

    @Override
    public Properties getHTTPCustomHeaders() {
        return this.m_HTTPCustomHeaders;
    }

    @Override
    public boolean getHTTPProxyEnabled() {
        return this.m_useHTTPProxy;
    }

    @Override
    public final boolean getHTTPProxyTunnel() {
        if (this.m_proxyConfig == null || !this.m_useHTTPProxy) {
            return false;
        }
        return !this.m_linkType.equalsIgnoreCase("http");
    }

    @Override
    public final String getHTTPProxyProtocol() {
        if (this.m_proxyConfig != null) {
            return this.m_proxyConfig.getProtocol();
        }
        return null;
    }

    @Override
    public String getHTTPProxyHost() {
        if (this.m_proxyConfig != null) {
            return this.m_proxyConfig.getHost();
        }
        return null;
    }

    @Override
    public int getHTTPProxyPort() {
        if (this.m_proxyConfig != null) {
            return this.m_proxyConfig.getPort();
        }
        return -1;
    }

    @Override
    public IHTTPCredentialsProvider getHTTPProxyCredentialsProvider() {
        return this.m_httpProxyCreds;
    }
}

