/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.broker.AgentSubjectSpace;
import progress.message.security.SecurityBean;
import progress.message.security.SecurityCache;
import progress.message.security.SecurityEvent;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.QOP;

public final class DelQOPEvent
extends SecurityEvent {
    DelQOPEvent(SecurityBean source, long starttime, int vtime, String subject, QOP qop) {
        super(source, starttime, vtime);
        this.m_subject = subject;
        this.m_qop = qop;
    }

    DelQOPEvent() {
    }

    @Override
    void callProcessMethod(SecurityCache cache) {
        cache.processDelQOPEvent(this);
    }

    @Override
    public void updateSubjectSpace(AgentSubjectSpace ss) {
        ss.removeSubjectObject(this.m_subject, (ISubjectMatchObject)this.m_qop);
        ss.resetCache();
    }

    @Override
    short getType() {
        return 2;
    }

    @Override
    void serialize(ObjectOutput out) throws IOException {
        super.serialize(out);
        out.writeUTF(this.m_subject);
        out.writeObject(this.m_qop);
    }

    @Override
    void unserialize(ObjectInput in, SecurityCache cache) throws IOException {
        try {
            super.unserialize(in, cache);
            this.m_subject = in.readUTF();
            this.m_qop = (QOP)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.toString());
        }
    }
}

