/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import progress.message.broker.AgentSubjectSpace;
import progress.message.broker.SubjectAclEntry;
import progress.message.security.AddGroupMemberEvent;
import progress.message.security.DelAclEntryEvent;
import progress.message.security.DelPrincipalEvent;
import progress.message.security.DelQOPEvent;
import progress.message.security.DelRoutingUserAclEntryEvent;
import progress.message.security.NewAclEntryEvent;
import progress.message.security.NewGroupEvent;
import progress.message.security.NewRoutingUserAclEntryEvent;
import progress.message.security.NewUserEvent;
import progress.message.security.RemoveGroupMemberEvent;
import progress.message.security.SecurityBean;
import progress.message.security.SecurityCache;
import progress.message.security.SetQOPEvent;
import progress.message.security.UpdateAclEntryEvent;
import progress.message.security.UpdateUserEvent;
import progress.message.security.prAccessor;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.QOP;

public abstract class SecurityEvent {
    private Long m_starttime;
    private Integer m_vtime;
    protected ProgressPasswordUser m_user;
    protected ProgressGroup m_group;
    protected String m_subject;
    protected SubjectAclEntry m_aclEntry;
    protected QOP m_qop;
    static final short SET_QOP_TYPE = 1;
    static final short DEL_QOP_TYPE = 2;
    static final short NEW_ACL_ENTRY_TYPE = 3;
    static final short UPDATE_ACL_ENTRY_TYPE = 4;
    static final short DEL_ACL_ENTRY_TYPE = 5;
    static final short NEW_USER_TYPE = 6;
    static final short UPDATE_USER_TYPE = 7;
    static final short DEL_PRINCIPAL_TYPE = 8;
    static final short NEW_GROUP_TYPE = 9;
    static final short ADD_GROUP_MEMBER_TYPE = 10;
    static final short REMOVE_GROUP_MEMBER_TYPE = 11;
    static final short DEL_ROUTING_USER_ACL_ENTRY_TYPE = 12;
    static final short NEW_ROUTING_USER_ACL_ENTRY_TYPE = 13;

    protected SecurityEvent(SecurityBean source, long starttime, int vtime) {
        this.m_starttime = new Long(starttime);
        this.m_vtime = new Integer(vtime);
    }

    protected SecurityEvent() {
    }

    public long getStartTime() {
        return this.m_starttime;
    }

    public int getVTime() {
        return this.m_vtime;
    }

    public ProgressPasswordUser getUser() {
        return this.m_user;
    }

    public ProgressGroup getGroup() {
        return this.m_group;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public SubjectAclEntry getAclEntry() {
        return this.m_aclEntry;
    }

    public QOP getQOP() {
        return this.m_qop;
    }

    abstract void callProcessMethod(SecurityCache var1);

    public abstract void updateSubjectSpace(AgentSubjectSpace var1);

    void serialize(ObjectOutput out) throws IOException {
        out.writeShort(this.getType());
        out.writeLong(this.m_starttime);
        out.writeInt(this.m_vtime);
    }

    void unserialize(ObjectInput in, SecurityCache cache) throws IOException {
        this.m_starttime = new Long(in.readLong());
        this.m_vtime = new Integer(in.readInt());
    }

    public static SecurityEvent readEvent(ObjectInput in, SecurityCache cache) throws IOException {
        SecurityEvent evt = null;
        short type = in.readShort();
        switch (type) {
            case 1: {
                evt = new SetQOPEvent();
                break;
            }
            case 2: {
                evt = new DelQOPEvent();
                break;
            }
            case 3: {
                evt = new NewAclEntryEvent();
                break;
            }
            case 4: {
                evt = new UpdateAclEntryEvent();
                break;
            }
            case 5: {
                evt = new DelAclEntryEvent();
                break;
            }
            case 12: {
                evt = new DelRoutingUserAclEntryEvent();
                break;
            }
            case 13: {
                evt = new NewRoutingUserAclEntryEvent();
                break;
            }
            case 6: {
                evt = new NewUserEvent();
                break;
            }
            case 7: {
                evt = new UpdateUserEvent();
                break;
            }
            case 8: {
                evt = new DelPrincipalEvent();
                break;
            }
            case 9: {
                evt = new NewGroupEvent();
                break;
            }
            case 10: {
                evt = new AddGroupMemberEvent();
                break;
            }
            case 11: {
                evt = new RemoveGroupMemberEvent();
                break;
            }
            default: {
                String mf125 = prAccessor.getString("STR133");
                Object[] ob125 = new Object[]{Integer.toString(type)};
                throw new IOException(MessageFormat.format(mf125, ob125));
            }
        }
        evt.unserialize(in, cache);
        return evt;
    }

    abstract short getType();
}

