/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

public class BatchSplitEvt
extends LogEvent {
    private long m_tracking;
    private boolean m_isPubSub;

    public BatchSplitEvt() {
    }

    public BatchSplitEvt(long tracking, boolean isPubSub) {
        this.m_tracking = tracking;
        this.m_isPubSub = isPubSub;
    }

    public long getTracking() {
        return this.m_tracking;
    }

    public boolean isPubSub() {
        return this.m_isPubSub;
    }

    @Override
    public short type() {
        return 72;
    }

    @Override
    public int memSizeBody() {
        return 9;
    }

    @Override
    public void redo(RecoveryMgr mgr) {
        mgr.redoBatchSplit(this);
    }

    @Override
    protected int streamSizeBody() {
        return this.memSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        return this.memSizeBody();
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_tracking = StreamUtil.readLong(in);
        this.m_isPubSub = StreamUtil.readBoolean(in);
    }

    @Override
    protected void writeBodyToStream(OutputStream out, boolean tteTTLConvert) throws IOException {
        this.writeBody(out);
    }

    private void writeBody(OutputStream out) throws IOException {
        StreamUtil.writeLong(this.m_tracking, out);
        StreamUtil.writeBoolean(this.m_isPubSub, out);
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    @Override
    public String toString() {
        if (this.m_isPubSub) {
            return super.toString() + " Batch split for transacted topic message " + this.m_tracking;
        }
        return super.toString() + " Batch split for transacted queue message " + this.m_tracking;
    }
}

