/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.AgentDelayedDeliveryQueue;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.zclient.DebugThread;

class DelayedDeliveryDispatchThread
extends DebugThread {
    private final AgentDelayedDeliveryQueue m_delayedDeliveryQ;

    DelayedDeliveryDispatchThread(AgentDelayedDeliveryQueue delayedDeliveryQ) {
        super("DelayedDeliveryDispatchThread");
        this.m_delayedDeliveryQ = delayedDeliveryQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadMain() throws InterruptedException {
        try {
            while (!Broker.exiting && !this.isShuttingDown()) {
                Object object = this.m_delayedDeliveryQ.m_dispatchLock;
                synchronized (object) {
                    while (this.m_delayedDeliveryQ.getTotalEnqueued() == 0 && !Broker.exiting) {
                        if (this.DEBUG) {
                            this.debug("no messages found in SonicMQ.delayedDeliveryQueue, waiting...");
                        }
                        this.m_delayedDeliveryQ.m_dispatchLock.wait();
                    }
                }
                if (this.DEBUG) {
                    this.debug("dispatching messages to ultimate delivery destination...");
                }
                int dispatched = this.m_delayedDeliveryQ.dispatch(0L, 0, false);
                if (this.DEBUG) {
                    this.debug("# of delayed messages dispatched = " + dispatched);
                    this.debug("sleeping for " + Config.DELAYED_DELIVERY_INTERVAL + "ms");
                }
                Thread.sleep(Config.DELAYED_DELIVERY_INTERVAL);
            }
        }
        catch (InterruptedException ie) {
            if (!Broker.exiting) {
                throw ie;
            }
        }
        finally {
            if (this.DEBUG) {
                this.debug("broker exiting = " + Broker.exiting);
            }
        }
    }
}

